/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.google.common.base.Strings;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.util.StringUtil;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.commonservice.util.QueryExecutorUtil;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.StorageDeviceMultipathingInfo;
import com.vmware.vsphere.client.h5.storage.data.datastore.StorageDeviceMultipathingInfoWithPaths;
import com.vmware.vsphere.client.h5.storage.data.devices.HostStorageDevicePartitionDetailsItem;
import com.vmware.vsphere.client.h5.storage.data.devices.StorageDeviceItemData;
import com.vmware.vsphere.client.h5.storage.data.multipathing.BaseStoragePath;
import com.vmware.vsphere.client.h5.storage.data.multipathing.DeviceStoragePath;
import com.vmware.vsphere.client.h5.storage.data.multipathing.ProtocolEndpointPath;
import com.vmware.vsphere.client.h5.storage.data.wizard.DatastoreStorageDevice;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.DeviceMultipathingInfo;
import com.vmware.vsphere.client.storage.ScsiDiskInfo;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceData;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceTransport;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStorageDevicesPropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_DEVICES_PROPERTY = "storageAdapterDevices";
    private static final String DATASTORE_CONNECTED_HOST = "connectedHost";
    private static final String AVAILABLE_DISK_FOR_VMFS = "availableDisksForVmfs";
    private static final String DISK_PARTITION_INFO = "diskPartitionInfo";
    private static Log _logger = LogFactory.getLog(HostStorageDevicesPropertyProvider.class);
    private static final String STORAGE_DEVICE_MULTIPATHING_INFO_PROPERTY = "deviceMultipathingInfo";
    private static final String FILE_SYSTEM_MOUNT_INFO_PROPERTY = "config.fileSystemVolume.mountInfo";
    private static final String VMFS_VOLUME_UUID_PROPERTY = "info/vmfs/uuid";
    private static final String DATASTORE_NAME_PROPERTY = "info/name";
    private static final String DS_TYPE_PROPERTY = "summary/type";
    private static final String HOST_KEY_PROPERTY = "hostKey";
    private static final String VMFS_TYPE = "VMFS";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private QueryService _queryService;

    public HostStorageDevicesPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, QueryServiceFactory queryServiceFactory) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDevices")
    public StorageDeviceItemData[] getHostStorageDevices(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        Map devicesProperties;
        ArrayList<StorageDeviceItemData> result = new ArrayList<StorageDeviceItemData>();
        if (adapterKey == null) {
            devicesProperties = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{STORAGE_DEVICES_PROPERTY, FILE_SYSTEM_MOUNT_INFO_PROPERTY});
        } else {
            HashMap<String, String> propertyParams = new HashMap<String, String>();
            propertyParams.put(STORAGE_DEVICES_PROPERTY, adapterKey);
            devicesProperties = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String[])new String[]{STORAGE_DEVICES_PROPERTY, FILE_SYSTEM_MOUNT_INFO_PROPERTY}, propertyParams);
        }
        if (devicesProperties.get(STORAGE_DEVICES_PROPERTY) == null) {
            return result.toArray(new StorageDeviceItemData[result.size()]);
        }
        if (devicesProperties.get(FILE_SYSTEM_MOUNT_INFO_PROPERTY) == null) {
            return result.toArray(new StorageDeviceItemData[result.size()]);
        }
        StorageDeviceData[] storageDevices = (StorageDeviceData[])devicesProperties.get(STORAGE_DEVICES_PROPERTY);
        FileSystemMountInfo[] fileSystemMountInfos = (FileSystemMountInfo[])devicesProperties.get(FILE_SYSTEM_MOUNT_INFO_PROPERTY);
        HashMap<String, String> diskToDsUuid = new HashMap<String, String>();
        for (FileSystemMountInfo info : fileSystemMountInfos) {
            if (!(info.getVolume() instanceof VmfsVolume)) continue;
            for (ScsiDisk.Partition extent : ((VmfsVolume)info.getVolume()).getExtent()) {
                diskToDsUuid.put(extent.getDiskName(), ((VmfsVolume)info.getVolume()).getUuid());
            }
        }
        HashMap<String, ResourceItem> dsUuidToDatastore = new HashMap<String, ResourceItem>();
        if (diskToDsUuid.values().size() > 0) {
            ResultSet resultSet = this._queryService.select(new String[]{VMFS_VOLUME_UUID_PROPERTY, DATASTORE_NAME_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(DS_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)VMFS_TYPE), new PropertyPredicate(HOST_KEY_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef)}).fetch();
            if (resultSet == null) {
                return result.toArray(new StorageDeviceItemData[0]);
            }
            for (ResourceItem item : resultSet.getItems()) {
                dsUuidToDatastore.put((String)item.getPropertyValues().get(0), item);
            }
        }
        if (storageDevices != null) {
            for (StorageDeviceData storageDeviceData : storageDevices) {
                if (storageDeviceData == null || storageDeviceData.underlyingLun == null) continue;
                DatastoreItem datastoreData = HostStorageDevicesPropertyProvider.createDatastoreItem(dsUuidToDatastore, diskToDsUuid, storageDeviceData.underlyingLun);
                result.add(HostStorageDevicesPropertyProvider.buildStorageDevice(storageDeviceData, datastoreData));
            }
        }
        return result.toArray(new StorageDeviceItemData[result.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDevicePaths")
    public DeviceStoragePath[] getHostStorageDevicePaths(ManagedObjectReference hostRef, String deviceName) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, deviceName);
        if (deviceInfo == null || ArrayUtil.isNullOrEmpty((Object[])deviceInfo.paths)) {
            return new DeviceStoragePath[0];
        }
        String preferredPathName = BaseStoragePath.getPreferredPathName(deviceInfo.pathSelectionPolicy);
        ArrayList<DeviceStoragePath> devicePaths = new ArrayList<DeviceStoragePath>();
        for (StoragePathData path : deviceInfo.paths) {
            devicePaths.add(DeviceStoragePath.newInstance(path, preferredPathName));
        }
        return devicePaths.toArray(new DeviceStoragePath[devicePaths.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStoragePEPaths")
    public List<ProtocolEndpointPath> getHostStoragePEPaths(ManagedObjectReference hostRef, String endpointIdentifier) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, endpointIdentifier);
        if (deviceInfo == null || ArrayUtil.isNullOrEmpty((Object[])deviceInfo.paths)) {
            return Collections.emptyList();
        }
        String preferredPathName = BaseStoragePath.getPreferredPathName(deviceInfo.pathSelectionPolicy);
        ArrayList<ProtocolEndpointPath> endpointPaths = new ArrayList<ProtocolEndpointPath>();
        for (StoragePathData path : deviceInfo.paths) {
            endpointPaths.add(ProtocolEndpointPath.newInstance(path, preferredPathName));
        }
        return endpointPaths;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDeviceMultipathingInfo")
    public StorageDeviceMultipathingInfo getHostStorageDeviceMultipathingInfo(ManagedObjectReference hostRef, String deviceName) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, deviceName);
        if (deviceInfo == null) {
            return null;
        }
        StorageDeviceMultipathingInfo result = new StorageDeviceMultipathingInfo();
        result.pathSelectionPolicy = deviceInfo.pathSelectionPolicy;
        result.storageArrayTypePolicy = deviceInfo.storageArrayTypePolicy;
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDeviceMultipathingInfoWithPaths")
    public StorageDeviceMultipathingInfoWithPaths getHostStorageDeviceMultipathingInfoWithPaths(ManagedObjectReference hostRef, String deviceName) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, deviceName);
        if (deviceInfo == null) {
            return null;
        }
        return StorageDeviceMultipathingInfoWithPaths.newInstance(deviceInfo);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="partitionDetails")
    public HostStorageDevicePartitionDetailsItem getDatastoreStorageDevicePartitionDetails(ManagedObjectReference hostRef, String devicePath) throws Exception {
        if (Strings.isNullOrEmpty((String)devicePath)) {
            return new HostStorageDevicePartitionDetailsItem();
        }
        HashMap<String, String> propertyParams = new HashMap<String, String>();
        propertyParams.put(DISK_PARTITION_INFO, devicePath);
        Map result = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String[])new String[]{DISK_PARTITION_INFO}, propertyParams);
        DiskPartitionInfo info = (DiskPartitionInfo)result.get(DISK_PARTITION_INFO);
        if (info == null) {
            _logger.error((Object)String.format("Fetched null for property %s for host %s", DISK_PARTITION_INFO, hostRef));
            return new HostStorageDevicePartitionDetailsItem();
        }
        HostStorageDevicePartitionDetailsItem formattedResult = HostStorageDevicePartitionDetailsItem.newInstance(info);
        return formattedResult;
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="storagedevice", property="datastoreStorageDevices")
    public DatastoreStorageDevice getDatastoreStorageDevices(ManagedObjectReference datastoreRef) throws Exception {
        DatastoreStorageDevice result = new DatastoreStorageDevice();
        ManagedObjectReference connectedHost = (ManagedObjectReference)this._queryExecutor.getProperty((Object)datastoreRef, DATASTORE_CONNECTED_HOST);
        if (connectedHost == null) {
            _logger.error((Object)String.format("Connected host for datastore %s is null.", datastoreRef));
            return result;
        }
        result.connectedHost = connectedHost;
        HashMap<String, ManagedObjectReference> propertyParams = new HashMap<String, ManagedObjectReference>();
        propertyParams.put(AVAILABLE_DISK_FOR_VMFS, datastoreRef);
        Map devicesForSingleAdapter = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)connectedHost, (String[])new String[]{AVAILABLE_DISK_FOR_VMFS}, propertyParams);
        result.scsiDiskInfos = (ScsiDiskInfo[])devicesForSingleAdapter.get(AVAILABLE_DISK_FOR_VMFS);
        return result;
    }

    private DeviceMultipathingInfo getDeviceMultipathingInfo(ManagedObjectReference hostRef, String deviceCanonicalName) throws Exception {
        if (hostRef == null || deviceCanonicalName == null) {
            return null;
        }
        return (DeviceMultipathingInfo)QueryExecutorUtil.requestPropertyWithParam((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String)STORAGE_DEVICE_MULTIPATHING_INFO_PROPERTY, (Object)deviceCanonicalName);
    }

    private static StorageDeviceItemData buildStorageDevice(StorageDeviceData deviceData, DatastoreItem datastoreItem) {
        StorageDeviceItemData itemData = new StorageDeviceItemData();
        ScsiLun lun = deviceData.underlyingLun;
        itemData.name = HostStorageDevicesPropertyProvider.getScsiLunName(lun);
        itemData.identifier = StorageStringUtil.getEmptyIfNull(lun.canonicalName);
        itemData.lunUuid = StorageStringUtil.getEmptyIfNull(lun.uuid);
        itemData.lunNumber = deviceData.lunNumber;
        itemData.type = lun.deviceType;
        itemData.isScsiDisk = lun instanceof ScsiDisk;
        itemData.hardwareAcceleration = HostStorageDevicesPropertyProvider.getHardwareAcceleration(lun);
        itemData.operationalState = StorageUtil.getOperationalState(lun.operationalState);
        itemData.ownerPlugin = deviceData.ownerPlugin;
        itemData.adapter = deviceData.adapter;
        itemData.transport = HostStorageDevicesPropertyProvider.getTransport(deviceData.transport);
        itemData.physicalLocation = HostStorageDevicesPropertyProvider.getPhysicalLocation(lun);
        itemData.devicePath = HostStorageDevicesPropertyProvider.getDevicePath(lun);
        itemData.isFlash = HostStorageDevicesPropertyProvider.isFlashDevice(lun);
        itemData.isLocal = HostStorageDevicesPropertyProvider.isLocalDisk(lun);
        itemData.capacity = HostStorageDevicesPropertyProvider.getCapacity(lun);
        itemData.sectorFormat = StorageUtil.getSectorFormatByScsiLun(lun);
        itemData.isRenameSupported = lun.capabilities != null && lun.capabilities.updateDisplayNameSupported;
        itemData.datastoreItem = datastoreItem;
        return itemData;
    }

    private static String getScsiLunName(ScsiLun scsiLun) {
        if (!com.vmware.vise.util.StringUtil.isNullOrEmpty((String)scsiLun.displayName)) {
            return scsiLun.displayName;
        }
        return StorageStringUtil.getEmptyIfNull(scsiLun.canonicalName);
    }

    private static String[] getPhysicalLocation(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return ((ScsiDisk)scsiLun).physicalLocation;
        }
        return new String[0];
    }

    private static String getDevicePath(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return ((ScsiDisk)scsiLun).devicePath;
        }
        return "";
    }

    private static boolean isFlashDevice(ScsiLun scsiLun) {
        Boolean ssd;
        if (scsiLun instanceof ScsiDisk && (ssd = ((ScsiDisk)scsiLun).ssd) != null) {
            return ssd;
        }
        return false;
    }

    private static boolean isLocalDisk(ScsiLun scsiLun) {
        Boolean isLocalDisk;
        if (scsiLun instanceof ScsiDisk && (isLocalDisk = ((ScsiDisk)scsiLun).localDisk) != null) {
            return isLocalDisk;
        }
        return true;
    }

    private static long getCapacity(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return StorageUtil.lbaToBytes(((ScsiDisk)scsiLun).capacity);
        }
        return 0L;
    }

    private static String getTransport(StorageDeviceTransport[] transport) {
        if (transport != null && transport.length > 0) {
            Object[] localizedTransport = new String[transport.length];
            for (int i = 0; i < localizedTransport.length; ++i) {
                localizedTransport[i] = StorageStringUtil.getString("storage.adapters.devices.transport." + transport[i]);
            }
            return StringUtil.join((Object[])localizedTransport, (String)", ");
        }
        return StorageStringUtil.getString("storage.adapters.devices.transport.UnknownTransport");
    }

    private static String getHardwareAcceleration(ScsiLun scsiLun) {
        ScsiLun.VStorageSupportStatus vStorageSupportStatus = ScsiLun.VStorageSupportStatus.vStorageUnknown;
        if (scsiLun.vStorageSupport != null) {
            vStorageSupportStatus = ScsiLun.VStorageSupportStatus.valueOf((String)scsiLun.vStorageSupport);
        }
        return StorageStringUtil.getString("vStorage." + vStorageSupportStatus.toString());
    }

    private static DatastoreItem createDatastoreItem(Map<String, ResourceItem> dsUuidToDatastore, Map<String, String> diskToDsUuid, ScsiLun underlyingLun) {
        if (dsUuidToDatastore.values().size() == 0 || diskToDsUuid.values().size() == 0) {
            return null;
        }
        String diskName = underlyingLun.getCanonicalName();
        if (diskName == null) {
            return null;
        }
        String datastoreUuid = diskToDsUuid.get(diskName);
        if (datastoreUuid == null) {
            return null;
        }
        ResourceItem datastore = dsUuidToDatastore.get(datastoreUuid);
        if (datastore == null) {
            return null;
        }
        return new DatastoreItem((ManagedObjectReference)datastore.getKey(), (String)datastore.getPropertyValues().get(1));
    }
}

