/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl.cluster;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.storage.data.cluster.ClusterStorageAdaptersOverviewData;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterTopologyCountData;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClusterStorageAdapterPropertyProvider {
    private static final String STORAGE_DEVICE_INFO_PROPERTY = "config/storageDevice";
    private static final String NUMBER_OF_DATASTORES = "datastore/length";
    private static final String PARENT_PROPERTY = "parent";
    private static final String NAME_PROPERTY = "name";
    private static final String ICON_PROPERTY = "primaryIconId";
    private static final String LABEL_IDS_PROPERTY = "labelIds";
    private final QueryService _queryService;

    public ClusterStorageAdapterPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="ClusterComputeResource/clusterStorageAdaptersOverview")
    public ClusterStorageAdaptersOverviewData getClusterStorageAdaptersOverview(ManagedObjectReference clusterRef) throws Exception {
        ResultSet hostProperties = this._queryService.select(new String[]{NAME_PROPERTY, STORAGE_DEVICE_INFO_PROPERTY, NUMBER_OF_DATASTORES, ICON_PROPERTY, LABEL_IDS_PROPERTY}).from(new String[]{HostSystem.class.getSimpleName()}).where(PARENT_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)clusterRef).fetch();
        ClusterStorageAdaptersOverviewData result = new ClusterStorageAdaptersOverviewData();
        if (hostProperties == null || hostProperties.getItems() == null) {
            return result;
        }
        ArrayList<ClusterStorageAdaptersOverviewData.HostAdapterData> clusterHostsData = new ArrayList<ClusterStorageAdaptersOverviewData.HostAdapterData>();
        for (ResourceItem ri : hostProperties.getItems()) {
            ClusterStorageAdaptersOverviewData.HostAdapterData hostData = new ClusterStorageAdaptersOverviewData.HostAdapterData();
            hostData.name = (String)ri.get(NAME_PROPERTY);
            hostData.hostRef = (ManagedObjectReference)ri.getKey();
            hostData.labelIds = (String)ri.get(LABEL_IDS_PROPERTY);
            hostData.iconId = (String)ri.get(ICON_PROPERTY);
            hostData.numberOfDatastores = (Integer)ri.get(NUMBER_OF_DATASTORES);
            StorageDeviceInfo storageDeviceInfo = (StorageDeviceInfo)ri.get(STORAGE_DEVICE_INFO_PROPERTY);
            if (storageDeviceInfo != null) {
                ClusterStorageAdapterPropertyProvider.populateDeviceCounts(storageDeviceInfo, hostData);
                hostData.numberOfStorageAdapters = storageDeviceInfo.hostBusAdapter != null ? storageDeviceInfo.hostBusAdapter.length : 0;
                ClusterStorageAdapterPropertyProvider.populateTargetCounts(storageDeviceInfo, hostData);
                ClusterStorageAdapterPropertyProvider.populatePathCounts(storageDeviceInfo, hostData);
            }
            clusterHostsData.add(hostData);
        }
        result.hostStorageAdaptersData = clusterHostsData.toArray(new ClusterStorageAdaptersOverviewData.HostAdapterData[clusterHostsData.size()]);
        return result;
    }

    private static void populateTargetCounts(StorageDeviceInfo storageDeviceInfo, ClusterStorageAdaptersOverviewData.HostAdapterData hostData) {
        StorageAdapterTopologyCountData[] adaptersCountData = StorageUtil.getStorageAdapterTopologyCountData((StorageDeviceInfo)storageDeviceInfo);
        hostData.numberOfTargets = 0;
        if (adaptersCountData != null) {
            for (StorageAdapterTopologyCountData countData : adaptersCountData) {
                hostData.numberOfTargets += countData.numberOfTargets;
            }
        }
    }

    private static void populateDeviceCounts(StorageDeviceInfo storageDeviceInfo, ClusterStorageAdaptersOverviewData.HostAdapterData hostData) {
        ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData> devicesCountByStatus = new ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData>();
        devicesCountByStatus.add(ClusterStorageAdaptersOverviewData.StatusCountData.newInstance(ClusterStorageAdapterPropertyProvider.localizeDeviceState(ScsiLun.State.ok), 0));
        hostData.numberOfAttachedDevices = 0;
        if (storageDeviceInfo.scsiLun != null) {
            hostData.totalNumberOfDevices = storageDeviceInfo.scsiLun.length;
            for (ScsiLun scsiLun : storageDeviceInfo.scsiLun) {
                ScsiLun.State lunState = com.vmware.vsphere.client.h5.storage.util.StorageUtil.getOperationalState(scsiLun.operationalState);
                if (ScsiLun.State.ok == lunState) {
                    ++hostData.numberOfAttachedDevices;
                }
                ClusterStorageAdapterPropertyProvider.incStatusCount(devicesCountByStatus, ClusterStorageAdapterPropertyProvider.localizeDeviceState(lunState));
            }
        } else {
            hostData.totalNumberOfDevices = 0;
        }
        hostData.devicesCountByStatus = devicesCountByStatus.toArray(new ClusterStorageAdaptersOverviewData.StatusCountData[devicesCountByStatus.size()]);
    }

    private static void populatePathCounts(StorageDeviceInfo storageDeviceInfo, ClusterStorageAdaptersOverviewData.HostAdapterData hostData) {
        HashMap<String, MultipathInfo.Path> multipathInfoPathsByName = new HashMap<String, MultipathInfo.Path>();
        if (storageDeviceInfo.multipathInfo != null && storageDeviceInfo.multipathInfo.lun != null) {
            for (MultipathInfo.LogicalUnit logicalUnit : storageDeviceInfo.multipathInfo.lun) {
                if (logicalUnit.path == null) continue;
                for (MultipathInfo.Path path : logicalUnit.path) {
                    multipathInfoPathsByName.put(path.name, path);
                }
            }
        }
        hostData.totalNumberOfPaths = 0;
        hostData.numberOfActivePaths = 0;
        ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData> pathsCountByStatus = new ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData>();
        pathsCountByStatus.add(ClusterStorageAdaptersOverviewData.StatusCountData.newInstance(ClusterStorageAdapterPropertyProvider.localizePathState(MultipathInfo.PathState.active.toString()), 0));
        if (storageDeviceInfo.plugStoreTopology != null && storageDeviceInfo.plugStoreTopology.path != null) {
            for (PlugStoreTopology.Path pstPath : storageDeviceInfo.plugStoreTopology.path) {
                if (StorageUtil.isPathMasked((String)pstPath.key, (PlugStoreTopology.Plugin[])storageDeviceInfo.plugStoreTopology.plugin)) continue;
                ++hostData.totalNumberOfPaths;
                MultipathInfo.Path mpiPath = (MultipathInfo.Path)multipathInfoPathsByName.get(pstPath.name);
                if (mpiPath == null) continue;
                if (MultipathInfo.PathState.active.toString().equals(mpiPath.state)) {
                    ++hostData.numberOfActivePaths;
                }
                ClusterStorageAdapterPropertyProvider.incStatusCount(pathsCountByStatus, ClusterStorageAdapterPropertyProvider.localizePathState(mpiPath.state));
            }
        }
        hostData.pathsCountByStatus = pathsCountByStatus.toArray(new ClusterStorageAdaptersOverviewData.StatusCountData[pathsCountByStatus.size()]);
    }

    private static void incStatusCount(List<ClusterStorageAdaptersOverviewData.StatusCountData> statusCountData, String statusName) {
        for (ClusterStorageAdaptersOverviewData.StatusCountData countData : statusCountData) {
            if (!countData.statusName.equals(statusName)) continue;
            ++countData.count;
            return;
        }
        statusCountData.add(ClusterStorageAdaptersOverviewData.StatusCountData.newInstance(statusName, 1));
    }

    private static String localizePathState(String state) {
        return StorageStringUtil.getString("storage.adapters.paths.state." + state);
    }

    private static String localizeDeviceState(ScsiLun.State state) {
        return StorageStringUtil.getString("storage.adapters.devices.deviceState." + state.toString());
    }
}

