/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;

@QueryBinding(value="Datastore")
public class DatastoreDetailsData
extends IdentifiableQueryBinding {
    @Property(value="Datastore/specificType")
    private String specificType;
    @Property(value="Datastore/vm/length")
    private int totalVmCount;
    @Property(value="Datastore/info/nas/remoteHostNames")
    private String[] nfsServers;
    @Property(value="Datastore/info/nas/type")
    private String nasType;
    @Property(value="Datastore/info/url")
    public String location;
    @Property(value="Datastore/summary/type")
    public String dsType;
    @Property(value="Datastore/vmTemplateCount")
    public int vmTemplateCount;
    @Property(value="Datastore/host/length")
    public int hostCount;
    @Property(value="Datastore/info/nas/remoteHost")
    public String nfsServer;
    @Property(value="Datastore/info/nas/remotePath")
    public String nfsFolder;
    @Property(value="Datastore/device")
    public String storageDevice;

    public String getFormattedType() {
        return StorageUtil.localizeDatastoreSpecificType(this.specificType);
    }

    public int getVmCount() {
        return this.totalVmCount - this.vmTemplateCount;
    }

    public String getFormattedNfsServers() {
        if (this.nfsServers == null || this.nfsServers.length == 0) {
            return this.nfsServer;
        }
        StringBuilder sb = new StringBuilder(this.nfsServers[0]);
        for (int i = 1; i < this.nfsServers.length; ++i) {
            sb.append(", ");
            sb.append(this.nfsServers[i]);
        }
        return sb.toString();
    }
}

