/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.parser;

import com.vmware.vide.vwcsdktools.as.parser.BufferError;

public class RingBuffer {
    private final int size;
    private final char[] cbuf;
    private int iptr;
    private int optr;
    private int bptr;
    private BufferState state;
    private BufferState backState;
    private boolean latchBack;

    RingBuffer(int size) {
        this.size = size;
        this.cbuf = new char[size];
        this.iptr = 0;
        this.optr = 0;
        this.bptr = 0;
        this.state = BufferState.EMPTY;
        this.backState = BufferState.EMPTY;
        this.latchBack = false;
    }

    void put(int c) throws BufferError {
        if (this.state == BufferState.FULL) {
            throw new BufferError("Buffer is full.");
        }
        this.cbuf[this.iptr] = (char)c;
        ++this.iptr;
        if (this.iptr >= this.size) {
            this.iptr = 0;
        }
        if (this.bptr == this.iptr) {
            this.latchBack = true;
        }
        this.state = this.iptr == this.optr ? BufferState.FULL : BufferState.AVAIL;
        if (this.latchBack) {
            this.bptr = this.iptr;
        }
        this.backState = this.bptr == this.optr ? BufferState.EMPTY : BufferState.AVAIL;
    }

    int get() throws BufferError {
        if (this.state == BufferState.EMPTY) {
            throw new BufferError("Buffer is empty.");
        }
        char c = this.cbuf[this.optr];
        ++this.optr;
        if (this.optr >= this.size) {
            this.optr = 0;
        }
        this.state = this.optr == this.iptr ? BufferState.EMPTY : BufferState.AVAIL;
        this.backState = this.bptr == this.optr ? BufferState.FULL : BufferState.AVAIL;
        return c;
    }

    int at() throws BufferError {
        if (this.state == BufferState.EMPTY) {
            throw new BufferError("Buffer is empty.");
        }
        return this.cbuf[this.optr];
    }

    void back() throws BufferError {
        if (this.backState == BufferState.EMPTY) {
            throw new BufferError("Cannot back.");
        }
        --this.optr;
        if (this.optr < 0) {
            this.optr = this.size - 1;
        }
        this.backState = this.bptr == this.optr ? BufferState.EMPTY : BufferState.AVAIL;
        this.state = this.iptr == this.optr ? BufferState.FULL : BufferState.AVAIL;
    }

    boolean have() {
        return this.state != BufferState.EMPTY;
    }

    boolean canBack() {
        return this.backState != BufferState.EMPTY;
    }

    boolean have(int n) {
        if (this.state != BufferState.EMPTY) {
            if (this.iptr > this.optr) {
                return this.iptr - this.optr > n;
            }
            return this.size - this.optr + this.iptr > n;
        }
        return false;
    }

    int at(int n) throws BufferError {
        if (this.state == BufferState.EMPTY) {
            throw new BufferError("Buffer is empty.");
        }
        int ptr = this.iptr;
        if (this.optr >= this.iptr) {
            ptr += this.size;
        }
        if (ptr - this.optr <= n) {
            throw new BufferError("Out of range.");
        }
        ptr = this.optr + n;
        if (ptr >= this.size) {
            ptr -= this.size;
        }
        return this.cbuf[ptr];
    }

    static enum BufferState {
        EMPTY,
        AVAIL,
        FULL;

    }
}

