/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.parser;

import com.vmware.vide.vwcsdktools.as.parser.AmpersandAmpersand;
import com.vmware.vide.vwcsdktools.as.parser.AmpersandAmpersandEqual;
import com.vmware.vide.vwcsdktools.as.parser.AmpersandEqual;
import com.vmware.vide.vwcsdktools.as.parser.AmpersandToken;
import com.vmware.vide.vwcsdktools.as.parser.AsToken;
import com.vmware.vide.vwcsdktools.as.parser.AsteriskEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.AsteriskToken;
import com.vmware.vide.vwcsdktools.as.parser.AtToken;
import com.vmware.vide.vwcsdktools.as.parser.BlockCommentToken;
import com.vmware.vide.vwcsdktools.as.parser.BufferError;
import com.vmware.vide.vwcsdktools.as.parser.BufferedCharReader;
import com.vmware.vide.vwcsdktools.as.parser.ColonToken;
import com.vmware.vide.vwcsdktools.as.parser.CommaToken;
import com.vmware.vide.vwcsdktools.as.parser.DotToken;
import com.vmware.vide.vwcsdktools.as.parser.DoubleColonToken;
import com.vmware.vide.vwcsdktools.as.parser.DoubleDotToken;
import com.vmware.vide.vwcsdktools.as.parser.DoubleEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.DoubleLeftAngleEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.DoubleLeftAngleToken;
import com.vmware.vide.vwcsdktools.as.parser.DoubleRightAngleEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.DoubleRightAngleToken;
import com.vmware.vide.vwcsdktools.as.parser.EofAsToken;
import com.vmware.vide.vwcsdktools.as.parser.EqualToken;
import com.vmware.vide.vwcsdktools.as.parser.ExclamationEqualEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.ExclamationEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.ExclamationToken;
import com.vmware.vide.vwcsdktools.as.parser.HatEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.HatToken;
import com.vmware.vide.vwcsdktools.as.parser.IdentifierToken;
import com.vmware.vide.vwcsdktools.as.parser.Keyword;
import com.vmware.vide.vwcsdktools.as.parser.KeywordToken;
import com.vmware.vide.vwcsdktools.as.parser.LeftAngleEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.LeftAngleToken;
import com.vmware.vide.vwcsdktools.as.parser.LeftBraceToken;
import com.vmware.vide.vwcsdktools.as.parser.LeftBracketToken;
import com.vmware.vide.vwcsdktools.as.parser.LeftParenthesis;
import com.vmware.vide.vwcsdktools.as.parser.MetadataEndToken;
import com.vmware.vide.vwcsdktools.as.parser.MetadataStartToken;
import com.vmware.vide.vwcsdktools.as.parser.MinusEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.MinusMinusToken;
import com.vmware.vide.vwcsdktools.as.parser.MinusToken;
import com.vmware.vide.vwcsdktools.as.parser.NewLineToken;
import com.vmware.vide.vwcsdktools.as.parser.NumberLiteralToken;
import com.vmware.vide.vwcsdktools.as.parser.PercentEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.PercentToken;
import com.vmware.vide.vwcsdktools.as.parser.PipeEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.PipePipeEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.PipePipeToken;
import com.vmware.vide.vwcsdktools.as.parser.PipeToken;
import com.vmware.vide.vwcsdktools.as.parser.PlusEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.PlusPlusToken;
import com.vmware.vide.vwcsdktools.as.parser.PlusToken;
import com.vmware.vide.vwcsdktools.as.parser.QuestionToken;
import com.vmware.vide.vwcsdktools.as.parser.RegularExpressionLiteralToken;
import com.vmware.vide.vwcsdktools.as.parser.RightAngleEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.RightAngleToken;
import com.vmware.vide.vwcsdktools.as.parser.RightBraceToken;
import com.vmware.vide.vwcsdktools.as.parser.RightBracketToken;
import com.vmware.vide.vwcsdktools.as.parser.RightParenthesis;
import com.vmware.vide.vwcsdktools.as.parser.ScannerError;
import com.vmware.vide.vwcsdktools.as.parser.SemicolonToken;
import com.vmware.vide.vwcsdktools.as.parser.SlashEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.SlashSlashCommentToken;
import com.vmware.vide.vwcsdktools.as.parser.SlashToken;
import com.vmware.vide.vwcsdktools.as.parser.StringLiteralToken;
import com.vmware.vide.vwcsdktools.as.parser.TildeToken;
import com.vmware.vide.vwcsdktools.as.parser.TokenContext;
import com.vmware.vide.vwcsdktools.as.parser.TripleDotToken;
import com.vmware.vide.vwcsdktools.as.parser.TripleEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.TripleRightAngleEqualToken;
import com.vmware.vide.vwcsdktools.as.parser.TripleRightAngleToken;
import com.vmware.vide.vwcsdktools.as.parser.XmlCdataToken;
import com.vmware.vide.vwcsdktools.as.parser.XmlCommentToken;
import com.vmware.vide.vwcsdktools.as.parser.XmlDeclarationToken;
import com.vmware.vide.vwcsdktools.as.parser.XmlElement;
import com.vmware.vide.vwcsdktools.as.parser.XmlLiteralToken;
import com.vmware.vide.vwcsdktools.as.parser.XmlTokenType;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Scanner {
    static final char[] CDATA_START = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private static final String UNEXPECTED_EOF = "Unexpected EOF. %s";
    private static final String UNEXPECTED_CHAR = "Unexpected character [%c]%s";
    BufferedCharReader reader;
    TokenContext tc;
    String filePath;

    Scanner(InputStreamReader isr, String filePath, int line, int column) {
        this.reader = new BufferedCharReader(isr, line, column);
        this.filePath = filePath;
    }

    Scanner(InputStreamReader isr, String filePath) {
        this(isr, filePath, 0, 0);
    }

    private boolean isSpace(int cc) {
        return Character.isWhitespace((char)cc);
    }

    private int readBlockComment() throws BufferError, IOException, ScannerError {
        int len;
        block1: {
            int cc;
            this.reader.getChar();
            len = 2;
            do {
                cc = this.reader.getChar();
                ++len;
                if (cc == 42 && this.reader.peekChar() == 47) break block1;
            } while (cc != -1);
            throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of block comment."));
        }
        this.reader.getChar();
        return len + 1;
    }

    private int readSlashSlashComment() throws IOException, BufferError {
        int len;
        block1: {
            int cc;
            this.reader.getChar();
            len = 2;
            do {
                cc = this.reader.getChar();
                ++len;
                if (cc == 10) break block1;
            } while (cc != -1);
            --len;
        }
        return len;
    }

    /*
     * Unable to fully structure code
     */
    private int readRegularExpressionLiteral() throws IOException, BufferError, ScannerError {
        block3: {
            len = 1;
            do lbl-1000:
            // 3 sources

            {
                block4: {
                    cc = this.reader.getChar();
                    ++len;
                    if (cc != 92) break block4;
                    cc = this.reader.getChar();
                    ++len;
                    if (cc != -1) ** GOTO lbl-1000
                    throw new ScannerError(String.format("Unexpected EOF. %s", new Object[]{"No escape char."}));
                }
                if (cc == 47) break block3;
            } while (cc != -1);
            throw new ScannerError(String.format("Unexpected EOF. %s", new Object[]{"No end of regular expression literal."}));
        }
        while ((cc = this.reader.getChar()) == 103 || cc == 105 || cc == 109 || cc == 115 || cc == 120) {
            ++len;
        }
        this.reader.putCharBack();
        if (Character.isJavaIdentifierPart((char)cc)) {
            throw new ScannerError(String.format("Unexpected character [%c]%s", new Object[]{Character.valueOf((char)cc), " appended to the regular expression literal."}));
        }
        return len;
    }

    private boolean isPartOfNumericalExp(AsToken token) {
        return token.isIdentifier() || token.isNumberLiteral() || token.isRightParenthesis() || token.isRightBrace() || token.isRightBracket();
    }

    private boolean isHexDigit(int cc) {
        return cc >= 48 && cc <= 57 || cc >= 97 && cc <= 102 || cc >= 65 && cc <= 70;
    }

    int readExponent(StringBuilder sb) throws IOException, BufferError, ScannerError {
        int cc = this.reader.getChar();
        if (cc >= 48 && cc <= 57 || cc == 43 || cc == 45) {
            int len = 1;
            sb.append((char)cc);
            while ((cc = this.reader.getChar()) >= 48 && cc <= 57) {
                ++len;
                sb.append((char)cc);
            }
            this.reader.putCharBack();
            return len;
        }
        this.reader.putCharBack();
        throw new ScannerError(String.format(UNEXPECTED_CHAR, Character.valueOf((char)cc), " at the beginning of exponent."));
    }

    private int readAfterDecimalPoint(StringBuilder sb) throws IOException, BufferError, ScannerError {
        int cc;
        int len = 0;
        while ((cc = this.reader.getChar()) >= 48 && cc <= 57) {
            ++len;
            sb.append((char)cc);
        }
        if (cc == 101 || cc == 69) {
            ++len;
            sb.append((char)cc);
            int exponentLen = this.readExponent(sb);
            return len += exponentLen;
        }
        this.reader.putCharBack();
        return len;
    }

    private int readNumericalLiteral(int startDigit, StringBuilder sb) throws IOException, BufferError, ScannerError {
        int len = 1;
        if (startDigit == 48 && (this.reader.peekChar() == 120 || this.reader.peekChar() == 88)) {
            int cc = this.reader.getChar();
            sb.append((char)cc);
            ++len;
            while (this.isHexDigit(cc = this.reader.getChar())) {
                ++len;
                sb.append((char)cc);
            }
            if (len < 3) {
                throw new ScannerError(String.format(UNEXPECTED_CHAR, Character.valueOf((char)cc), ". Invalid hexadecimal value."));
            }
            this.reader.putCharBack();
            return len;
        }
        while (true) {
            int cc;
            if ((cc = this.reader.getChar()) == 46) {
                ++len;
                sb.append((char)cc);
                int n = this.reader.peekChar();
                if (n >= 48 && n <= 57) {
                    int decimalLen = this.readAfterDecimalPoint(sb);
                    return len += decimalLen;
                }
                if (n == 101 || n == 69) {
                    this.reader.getChar();
                    ++len;
                    sb.append((char)cc);
                    int expoLen = this.readExponent(sb);
                    return len += expoLen;
                }
                return len;
            }
            if (cc == 101 || cc == 69) {
                ++len;
                sb.append((char)cc);
                int expoLen = this.readExponent(sb);
                return len += expoLen;
            }
            if (cc < 48 || cc > 57) break;
            ++len;
            sb.append((char)cc);
        }
        this.reader.putCharBack();
        return len;
    }

    private boolean compareChars(char[] chars, char[] badChar) throws IOException, BufferError {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != this.reader.getChar()) {
                badChar[0] = c;
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int readXMLCdata(StringBuilder sb) throws IOException, BufferError, ScannerError {
        char[] badChar = new char[1];
        if (!this.compareChars(CDATA_START, badChar)) {
            throw new ScannerError(String.format(UNEXPECTED_CHAR, badChar, " in CDATA."));
        }
        int len = CDATA_START.length;
        while (true) {
            int cc = this.reader.getChar();
            ++len;
            if (cc == 93 && this.reader.peekChar() == 93 && this.reader.peekChar(1) == 62) {
                this.reader.getChar();
                this.reader.getChar();
                return len += 2;
            }
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of CDATA."));
            }
            sb.append((char)cc);
        }
    }

    private int readXMLComment() throws IOException, BufferError, ScannerError {
        int cc;
        int len = 0;
        do {
            cc = this.reader.getChar();
            ++len;
            if (cc != 45 || 45 != this.reader.peekChar() || 62 != this.reader.peekChar(1)) continue;
            this.reader.getChar();
            this.reader.getChar();
            return len += 2;
        } while (cc != -1);
        throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of XML comment."));
    }

    private int readXMLDeclaration() throws IOException, BufferError, ScannerError {
        int cc;
        int len = 0;
        do {
            cc = this.reader.getChar();
            ++len;
            if (cc != 63 || 62 != this.reader.peekChar()) continue;
            this.reader.getChar();
            return ++len;
        } while (cc != -1);
        throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of XML declaration element."));
    }

    private boolean isIdentifierStart(int cc) {
        return cc == 95 || cc == 36 || Character.isLetter((char)cc);
    }

    private boolean isIdentifierPart(int cc) {
        return cc == 95 || cc == 36 || Character.isLetter((char)cc) || Character.isDigit((char)cc);
    }

    private int readIdentifier(StringBuilder sb) throws IOException, BufferError {
        int cc;
        int len = 0;
        while (this.isIdentifierPart(cc = this.reader.getChar())) {
            ++len;
            sb.append((char)cc);
        }
        this.reader.putCharBack();
        return len;
    }

    private int calculateLength(int rindex, int currentStartLine, int currentStartColumn) {
        int lastLen;
        AsToken token = this.tc.peekPrev(rindex);
        int lastLine = token.getStartLine();
        int lastColumn = token.getStartColumn();
        int len = lastLen = token.getLength();
        --rindex;
        while (rindex >= 0) {
            token = this.tc.peekPrev(rindex);
            --rindex;
            int line = token.getStartLine();
            int column = token.getStartColumn();
            len = line == lastLine ? (len += column - lastColumn - lastLen + token.getLength()) : (len += column + token.getLength());
            lastLine = line;
            lastColumn = column;
            lastLen = token.getLength();
        }
        len = lastLine == currentStartLine ? (len += currentStartColumn - lastColumn - lastLen) : (len += currentStartColumn);
        return len;
    }

    private int processMetadataTags(int rindex) {
        ++rindex;
        int level = 0;
        while (true) {
            AsToken token;
            if ((token = this.tc.peekPrev(rindex)).isRightBracket()) {
                ++level;
            }
            if (token.isLeftBracket()) {
                if (level == 0) break;
                --level;
            }
            if (token.isEmtpyToken()) break;
            ++rindex;
        }
        return rindex;
    }

    private void resolveFunctionAttributes() {
        int rindex = 0;
        boolean haveNamespaceIdentifier = false;
        boolean haveNative = false;
        boolean haveFinal = false;
        boolean haveOverride = false;
        boolean haveStatic = false;
        boolean haveAccessAttr = false;
        while (true) {
            Keyword keyword;
            AsToken token;
            if ((token = this.tc.peekPrev(rindex)).isNewLine()) {
                ++rindex;
                continue;
            }
            if (token.isComment()) {
                ++rindex;
                continue;
            }
            if (token.isIdentifier()) {
                String name = ((IdentifierToken)token).getName();
                if (name.equals(Keyword.INTERNAL.getName()) && !haveAccessAttr) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.INTERNAL));
                    haveAccessAttr = true;
                    ++rindex;
                    continue;
                }
                if (name.equals(Keyword.STATIC.getName()) && !haveStatic) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.STATIC));
                    haveStatic = true;
                    ++rindex;
                    continue;
                }
                if (name.equals(Keyword.FINAL.getName()) && !haveFinal) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.FINAL));
                    haveFinal = true;
                    ++rindex;
                    continue;
                }
                if (name.equals(Keyword.NATIVE.getName()) && !haveNative) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.NATIVE));
                    haveNative = true;
                    ++rindex;
                    continue;
                }
                if (name.equals(Keyword.OVERRIDE.getName()) && !haveOverride) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.OVERRIDE));
                    haveOverride = true;
                    ++rindex;
                    continue;
                }
                if (!haveNamespaceIdentifier) {
                    haveNamespaceIdentifier = true;
                    ++rindex;
                    continue;
                }
            }
            if (token.isKeyword() && !haveAccessAttr && ((keyword = ((KeywordToken)token).getKeyword()) == Keyword.PRIVATE || keyword == Keyword.PROTECTED || keyword == Keyword.PUBLIC)) {
                haveAccessAttr = true;
                ++rindex;
                continue;
            }
            if (!token.isRightBracket()) break;
            int endIndex = rindex;
            rindex = this.processMetadataTags(rindex);
            AsToken startToken = this.tc.peekPrev(rindex);
            this.tc.setLast(rindex, new MetadataStartToken(startToken.getStartLine(), startToken.getStartColumn()));
            this.tc.setLast(endIndex, new MetadataEndToken(token.getStartLine(), token.getStartColumn()));
            haveStatic = true;
            haveFinal = true;
            haveNative = true;
            haveOverride = true;
            haveAccessAttr = true;
            haveNamespaceIdentifier = true;
            ++rindex;
        }
    }

    private void resolveVarAttributes() {
        int rindex = 0;
        boolean haveAccessAttr = false;
        boolean haveStatic = false;
        boolean haveNamespaceIdentifier = false;
        while (true) {
            Keyword keyword;
            AsToken token;
            if ((token = this.tc.peekPrev(rindex)).isNewLine() || token.isComment()) {
                ++rindex;
                continue;
            }
            if (token.isIdentifier()) {
                String name = ((IdentifierToken)token).getName();
                if (name.equals(Keyword.INTERNAL.getName()) && !haveAccessAttr) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.INTERNAL));
                    haveAccessAttr = true;
                    ++rindex;
                    continue;
                }
                if (name.equals(Keyword.STATIC.getName()) && !haveStatic) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.STATIC));
                    haveStatic = true;
                    ++rindex;
                    continue;
                }
                if (!haveNamespaceIdentifier) {
                    haveNamespaceIdentifier = true;
                    ++rindex;
                    continue;
                }
            }
            if (token.isKeyword() && !haveAccessAttr && ((keyword = ((KeywordToken)token).getKeyword()) == Keyword.PRIVATE || keyword == Keyword.PROTECTED || keyword == Keyword.PUBLIC)) {
                haveAccessAttr = true;
                ++rindex;
                continue;
            }
            if (!token.isRightBracket()) break;
            int endIndex = rindex;
            rindex = this.processMetadataTags(rindex);
            AsToken startToken = this.tc.peekPrev(rindex);
            this.tc.setLast(rindex, new MetadataStartToken(startToken.getStartLine(), startToken.getStartColumn()));
            this.tc.setLast(endIndex, new MetadataEndToken(token.getStartLine(), token.getStartColumn()));
            haveStatic = true;
            haveAccessAttr = true;
            haveNamespaceIdentifier = true;
            ++rindex;
        }
    }

    private void resolveClassAttributes() {
        int rindex = 0;
        boolean haveAccessAttr = false;
        boolean haveNamespaceIdentifier = false;
        while (true) {
            Keyword keyword;
            AsToken token;
            if ((token = this.tc.peekPrev(rindex)).isNewLine() || token.isComment()) {
                ++rindex;
                continue;
            }
            if (token.isIdentifier()) {
                String name = ((IdentifierToken)token).getName();
                if (name.equals(Keyword.INTERNAL.getName()) && !haveAccessAttr) {
                    this.tc.setLast(rindex, new KeywordToken(token.getStartLine(), token.getStartColumn(), Keyword.INTERNAL));
                    haveAccessAttr = true;
                    ++rindex;
                    continue;
                }
                if (!haveNamespaceIdentifier) {
                    haveNamespaceIdentifier = true;
                    ++rindex;
                    continue;
                }
            }
            if (token.isKeyword() && !haveAccessAttr && (keyword = ((KeywordToken)token).getKeyword()) == Keyword.PUBLIC) {
                haveAccessAttr = true;
                ++rindex;
                continue;
            }
            if (!token.isRightBracket()) break;
            int endIndex = rindex;
            rindex = this.processMetadataTags(rindex);
            AsToken startToken = this.tc.peekPrev(rindex);
            this.tc.setLast(rindex, new MetadataStartToken(startToken.getStartLine(), startToken.getStartColumn()));
            this.tc.setLast(endIndex, new MetadataEndToken(token.getStartLine(), token.getStartColumn()));
            haveAccessAttr = true;
            haveNamespaceIdentifier = true;
            ++rindex;
        }
    }

    private void resolvePackageAttributes() {
        int rindex = 0;
        while (true) {
            AsToken token;
            if ((token = this.tc.peekPrev(rindex)).isNewLine() || token.isComment()) {
                ++rindex;
                continue;
            }
            if (!token.isRightBracket()) break;
            int endIndex = rindex;
            rindex = this.processMetadataTags(rindex);
            AsToken startToken = this.tc.peekPrev(rindex);
            this.tc.setLast(rindex, new MetadataStartToken(startToken.getStartLine(), startToken.getStartColumn()));
            this.tc.setLast(endIndex, new MetadataEndToken(token.getStartLine(), token.getStartColumn()));
            ++rindex;
        }
    }

    private KeywordToken processKeyword(String name, int line, int column) {
        if (Keyword.isStrongKeyword(name)) {
            KeywordToken token = new KeywordToken(line, column, name.length(), Keyword.getKeyword(name));
            switch (token.getKeyword()) {
                case FUNCTION: {
                    this.resolveFunctionAttributes();
                    break;
                }
                case CONST: 
                case VAR: {
                    this.resolveVarAttributes();
                    break;
                }
                case CLASS: {
                    this.resolveClassAttributes();
                    break;
                }
                case PACKAGE: {
                    this.resolvePackageAttributes();
                }
            }
            return token;
        }
        if (Keyword.isCombinationKeyword(name)) {
            AsToken token;
            boolean hasXml = false;
            int rindex = 0;
            while (true) {
                if ((token = this.tc.peekPrev(rindex)).isNewLine()) {
                    ++rindex;
                    continue;
                }
                if (!token.isIdentifier() || !((IdentifierToken)token).getName().equals("xml") || hasXml) break;
                hasXml = true;
                ++rindex;
            }
            if (token.isKeyword()) {
                StringBuilder sb = new StringBuilder();
                sb.append(((KeywordToken)token).getKeyword().getName()).append(' ');
                if (hasXml) {
                    sb.append(" xml");
                }
                sb.append(name);
                if (Keyword.isKeyword(sb.toString())) {
                    int len = this.calculateLength(rindex, line, column);
                    this.tc.removeLast(rindex);
                    return new KeywordToken(token.getStartLine(), token.getStartColumn(), len += name.length(), this.reader.getLine(), this.reader.getColumn(), Keyword.getKeyword(sb.toString()));
                }
            }
            return null;
        }
        return null;
    }

    private boolean isAsTagNameStart(int cc) {
        if (Character.isLetter((char)cc) || cc == 95 || cc == 58) {
            return true;
        }
        if (cc == 36) {
            return true;
        }
        return cc == 123;
    }

    private boolean isAsTagNamePart(int cc) {
        if (Character.isLetter((char)cc) || Character.isDigit((char)cc) || cc == 95 || cc == 58 || cc == 45 || cc == 46) {
            return true;
        }
        return cc == 36 || cc == 123 || cc == 125;
    }

    private boolean isTagNamePart(int cc) {
        return Character.isLetter((char)cc) || Character.isDigit((char)cc) || cc == 95 || cc == 58 || cc == 45 || cc == 46;
    }

    private int scanAsXmlTagNamePart(int index) throws IOException, BufferError {
        int cc;
        while (this.isAsTagNamePart(cc = this.reader.peekChar(index))) {
            ++index;
        }
        return index;
    }

    private int scanString(int surroundChar, int index) throws IOException, BufferError, ScannerError {
        while (true) {
            int cc = this.reader.peekChar(index);
            ++index;
            if (cc == 92) {
                cc = this.reader.peekChar(index);
                ++index;
                if (cc != -1) continue;
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of string literal."));
            }
            if (cc == 10) {
                throw new ScannerError("Unexpected EOL.");
            }
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of string literal."));
            }
            if (cc == surroundChar) break;
        }
        return index;
    }

    private int scanAsXmlTagName(int startChar, int index) throws IOException, BufferError, ScannerError {
        int level = 0;
        if (startChar == 123) {
            ++level;
        }
        while (true) {
            int cc = this.reader.peekChar(index);
            if (level > 0) {
                if (this.isSpace(cc)) {
                    ++index;
                    continue;
                }
                if (cc == 34 || cc == 39) {
                    int nextIndex;
                    ++index;
                    index = nextIndex = this.scanString(cc, index);
                    continue;
                }
                if (cc != 125) break;
                --level;
                ++index;
                continue;
            }
            if (this.isTagNamePart(cc) || cc == 36) {
                ++index;
                continue;
            }
            if (cc != 123) break;
            ++level;
            ++index;
        }
        return index;
    }

    private boolean checkXmlTag() throws IOException, BufferError, ScannerError {
        int cc;
        int index = 0;
        boolean haveTagName = false;
        boolean afterAttr = false;
        boolean afterAttrEqual = false;
        while (true) {
            int nextIndex;
            cc = this.reader.peekChar(index);
            ++index;
            if (this.isSpace(cc)) continue;
            if (this.isAsTagNameStart(cc)) {
                if (haveTagName) {
                    if (cc == 36) {
                        return true;
                    }
                    index = nextIndex = this.scanAsXmlTagName(cc, index);
                    afterAttr = true;
                    continue;
                }
                if (cc == 123 || cc == 58 || cc == 36) {
                    return true;
                }
                nextIndex = this.scanAsXmlTagNamePart(index);
                haveTagName = true;
                index = nextIndex;
                continue;
            }
            if (cc == 61 && afterAttr) {
                afterAttr = false;
                afterAttrEqual = true;
                continue;
            }
            if ((cc == 34 || cc == 39) && (afterAttrEqual || afterAttr)) {
                index = nextIndex = this.scanString(cc, index);
                afterAttrEqual = false;
                continue;
            }
            if (cc != 123 || !afterAttrEqual && !afterAttr) break;
            afterAttrEqual = false;
            afterAttr = false;
        }
        if (cc == 62) {
            return true;
        }
        return cc == 47 && this.reader.peekChar(index) == 62;
    }

    private int readStringLiteral(int startChar, StringBuilder sb) throws IOException, BufferError, ScannerError {
        int len = 0;
        while (true) {
            int cc = this.reader.getChar();
            ++len;
            if (cc == 92) {
                sb.append((char)cc);
                cc = this.reader.getChar();
                ++len;
                if (cc == -1) {
                    throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of string literal."));
                }
                sb.append((char)cc);
                continue;
            }
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of string literal."));
            }
            if (cc == 10) {
                throw new ScannerError("Unexpected EOL.");
            }
            if (cc == startChar) break;
            sb.append((char)cc);
        }
        return len;
    }

    private int readXmlDeclaration(StringBuilder sb) throws IOException, BufferError, ScannerError {
        int len = 0;
        while (true) {
            int cc = this.reader.getChar();
            ++len;
            if (cc == 63 && this.reader.peekChar() == 62) {
                this.reader.getChar();
                return len + 1;
            }
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of XML declaration element."));
            }
            sb.append((char)cc);
        }
    }

    private int readXmlCdata(StringBuilder sb) throws IOException, BufferError, ScannerError {
        int len = 0;
        char[] badChar = new char[1];
        if (this.compareChars(CDATA_START, badChar)) {
            len += CDATA_START.length;
            while (true) {
                int cc = this.reader.getChar();
                ++len;
                if (cc == 93 && this.reader.peekChar(0) == 93 && this.reader.peekChar(1) == 62) {
                    this.reader.getChar();
                    this.reader.getChar();
                    return len + 2;
                }
                if (cc == 34 || cc == 39) {
                    len += this.readStringLiteral(cc, sb);
                }
                if (cc == -1) {
                    throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of CDATA."));
                }
                sb.append((char)cc);
            }
        }
        throw new ScannerError(String.format(UNEXPECTED_CHAR, badChar, " in beginning of CDATA."));
    }

    private int readXmlComment(StringBuilder sb) throws IOException, BufferError, ScannerError {
        int len = 0;
        while (true) {
            int cc = this.reader.getChar();
            ++len;
            if (cc == 45 && this.reader.peekChar(0) == 45 && this.reader.peekChar(1) == 62) {
                this.reader.getChar();
                this.reader.getChar();
                return len + 2;
            }
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of XML comment."));
            }
            sb.append((char)cc);
        }
    }

    private int readXmlEndTag(StringBuilder sb) throws IOException, BufferError, ScannerError {
        int len = 0;
        while (true) {
            int cc = this.reader.getChar();
            ++len;
            if (cc == 62) break;
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of XML closing tag."));
            }
            sb.append((char)cc);
        }
        return len;
    }

    private int readXmlStartTag(StringBuilder sb) throws IOException, BufferError, ScannerError {
        int len = 0;
        while (true) {
            int cc = this.reader.getChar();
            ++len;
            if (cc == 62) break;
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, "No end of XML start tag."));
            }
            sb.append((char)cc);
        }
        return len;
    }

    private XmlElement getXmlElement() throws IOException, BufferError, ScannerError {
        int line = this.reader.getLine();
        int column = this.reader.getColumn();
        int cc = this.reader.getChar();
        if (cc == 60) {
            int n = this.reader.peekChar();
            if (n == 63) {
                this.reader.getChar();
                StringBuilder sb = new StringBuilder();
                int len = 2;
                return new XmlElement(line, column, len += this.readXmlDeclaration(sb), this.reader.getLine(), this.reader.getColumn(), sb.toString(), XmlTokenType.DECLARATION);
            }
            if (n == 33) {
                this.reader.getChar();
                n = this.reader.peekChar();
                if (n == 91) {
                    this.reader.getChar();
                    StringBuilder sb = new StringBuilder();
                    int len = 3;
                    return new XmlElement(line, column, len += this.readXmlCdata(sb), this.reader.getLine(), this.reader.getColumn(), sb.toString(), XmlTokenType.CDATA_TAG);
                }
                if (n == 45 && this.reader.peekChar(1) == 45) {
                    this.reader.getChar();
                    this.reader.getChar();
                    StringBuilder sb = new StringBuilder();
                    int len = 4;
                    return new XmlElement(line, column, len += this.readXmlComment(sb), this.reader.getLine(), this.reader.getColumn(), sb.toString(), XmlTokenType.COMMENT);
                }
                throw new ScannerError(String.format(UNEXPECTED_CHAR, Character.valueOf((char)n), " after <!."));
            }
            if (n == 47) {
                this.reader.getChar();
                int len = 2;
                StringBuilder sb = new StringBuilder();
                return new XmlElement(line, column, len += this.readXmlEndTag(sb), this.reader.getLine(), this.reader.getColumn(), sb.toString(), XmlTokenType.END_TAG);
            }
            int len = 1;
            StringBuilder sb = new StringBuilder();
            len += this.readXmlStartTag(sb);
            if (sb.charAt(sb.length() - 1) == '/') {
                return new XmlElement(line, column, len, this.reader.getLine(), this.reader.getColumn(), sb.substring(0, sb.length() - 1), XmlTokenType.EMPTY_ELEMENT_TAG);
            }
            return new XmlElement(line, column, len, this.reader.getLine(), this.reader.getColumn(), sb.toString(), XmlTokenType.START_TAG);
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        int len = 1;
        while ((cc = this.reader.peekChar()) != 60) {
            if (cc == -1) {
                throw new ScannerError(String.format(UNEXPECTED_EOF, ""));
            }
            this.reader.getChar();
            ++len;
            sb.append((char)cc);
        }
        return new XmlElement(line, column, len, this.reader.getLine(), this.reader.getColumn(), sb.toString(), XmlTokenType.CONTENTS);
    }

    private int readXMLLiteral(List<XmlElement> xmlElements) throws IOException, BufferError, ScannerError {
        int len = 0;
        int level = 0;
        while (true) {
            XmlElement element = this.getXmlElement();
            xmlElements.add(element);
            len += element.getLength();
            if (element.type == XmlTokenType.START_TAG) {
                ++level;
                continue;
            }
            if (element.type == XmlTokenType.END_TAG ? --level == 0 : (element.type == XmlTokenType.EMPTY_ELEMENT_TAG ? level == 0 : element.type == XmlTokenType.DECLARATION && level == 0)) break;
        }
        return len;
    }

    private void handleScannerError(ScannerError e) {
        e.printStackTrace();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsToken getNext() throws IOException, BufferError {
        int column = 0;
        int line = 0;
        try {
            while (true) {
                column = this.reader.getColumn();
                line = this.reader.getLine();
                int cc = this.reader.getChar();
                if (this.isSpace(cc)) {
                    if (cc != 10) continue;
                    return new NewLineToken(line, column);
                }
                if (cc == 47 && this.reader.peekChar() == 42) {
                    int len = this.readBlockComment();
                    return new BlockCommentToken(line, column, len, this.reader.getLine(), this.reader.getColumn());
                }
                if (cc == 47 && this.reader.peekChar() == 47) {
                    int len = this.readSlashSlashComment();
                    return new SlashSlashCommentToken(line, column, len);
                }
                if (cc == 47 && this.isPartOfNumericalExp(this.tc.peekPrev())) {
                    if (this.reader.peekChar() != 61) return new SlashToken(line, column);
                    this.reader.getChar();
                    return new SlashEqualToken(line, column);
                }
                if (cc == 47) {
                    int len = this.readRegularExpressionLiteral();
                    return new RegularExpressionLiteralToken(line, column, len, this.reader.getLine(), this.reader.getColumn());
                }
                if (cc == 34 || cc == 39) {
                    int len = 1;
                    StringBuilder sb = new StringBuilder();
                    return new StringLiteralToken(line, column, len += this.readStringLiteral(cc, sb), this.reader.getLine(), this.reader.getColumn(), sb.toString());
                }
                if (cc >= 48 && cc <= 57) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)cc);
                    int len = this.readNumericalLiteral(cc, sb);
                    return new NumberLiteralToken(line, column, len, sb.toString());
                }
                if (cc == 91) {
                    return new LeftBracketToken(line, column);
                }
                if (cc == 93) {
                    return new RightBracketToken(line, column);
                }
                if (cc == 123) {
                    return new LeftBraceToken(line, column);
                }
                if (cc == 125) {
                    return new RightBraceToken(line, column);
                }
                if (cc == 40) {
                    return new LeftParenthesis(line, column);
                }
                if (cc == 41) {
                    return new RightParenthesis(line, column);
                }
                if (cc == 58) {
                    if (this.reader.peekChar() != 58) return new ColonToken(line, column);
                    this.reader.getChar();
                    return new DoubleColonToken(line, column);
                }
                if (cc == 46) {
                    int n = this.reader.peekChar();
                    if (n >= 48 && n <= 57) {
                        StringBuilder sb = new StringBuilder();
                        int len = 1;
                        sb.append((char)cc);
                        return new NumberLiteralToken(line, column, len += this.readAfterDecimalPoint(sb), sb.toString());
                    }
                    if (n != 46) return new DotToken(line, column);
                    this.reader.getChar();
                    if (this.reader.peekChar() != 46) return new DoubleDotToken(line, column);
                    this.reader.getChar();
                    return new TripleDotToken(line, column);
                }
                if (cc == 60) {
                    int n = this.reader.peekChar();
                    if (n == 60) {
                        this.reader.getChar();
                        if (this.reader.peekChar() != 61) return new DoubleLeftAngleToken(line, column);
                        this.reader.getChar();
                        return new DoubleLeftAngleEqualToken(line, column);
                    }
                    if (n == 61) {
                        this.reader.getChar();
                        return new LeftAngleEqualToken(line, column);
                    }
                    if (n == 33) {
                        this.reader.getChar();
                        n = this.reader.peekChar();
                        if (n == 91) {
                            this.reader.getChar();
                            int len = 3;
                            StringBuilder sb = new StringBuilder();
                            return new XmlCdataToken(line, column, len += this.readXMLCdata(sb), this.reader.getLine(), this.reader.getColumn(), sb.toString());
                        }
                        if (n != 45) throw new ScannerError(String.format(UNEXPECTED_CHAR, Character.valueOf((char)n), " after <!."));
                        this.reader.getChar();
                        if (this.reader.peekChar() != 45) throw new ScannerError(String.format(UNEXPECTED_CHAR, Character.valueOf((char)n), " after <!."));
                        this.reader.getChar();
                        return new XmlCommentToken(line, column, len += this.readXMLComment(), this.reader.getLine(), this.reader.getColumn());
                    }
                    if (n == 63) {
                        this.reader.getChar();
                        return new XmlDeclarationToken(line, column, len += this.readXMLDeclaration(), this.reader.getLine(), this.reader.getColumn());
                    }
                    AsToken token = this.tc.peekPrev();
                    if (token.isDot()) {
                        return new LeftAngleToken(line, column);
                    }
                    if (token instanceof KeywordToken && ((KeywordToken)token).getKeyword() == Keyword.NEW) {
                        return new LeftAngleToken(line, column);
                    }
                    if (!this.checkXmlTag()) return new LeftAngleToken(line, column);
                    int len = 0;
                    this.reader.putCharBack();
                    ArrayList<XmlElement> elements = new ArrayList<XmlElement>();
                    return new XmlLiteralToken(line, column, len += this.readXMLLiteral(elements), this.reader.getLine(), this.reader.getColumn(), elements);
                }
                if (cc == 62) {
                    int n = this.reader.peekChar();
                    if (n == 62) {
                        this.reader.getChar();
                        n = this.reader.peekChar();
                        if (n == 62) {
                            this.reader.getChar();
                            if (this.reader.peekChar() != 61) return new TripleRightAngleToken(line, column);
                            this.reader.getChar();
                            return new TripleRightAngleEqualToken(line, column);
                        }
                        if (n != 61) return new DoubleRightAngleToken(line, column);
                        this.reader.getChar();
                        return new DoubleRightAngleEqualToken(line, column);
                    }
                    if (n != 61) return new RightAngleToken(line, column);
                    this.reader.getChar();
                    return new RightAngleEqualToken(line, column);
                }
                if (cc == 64) {
                    return new AtToken(line, column);
                }
                if (cc == 43) {
                    int n = this.reader.peekChar();
                    if (n == 43) {
                        this.reader.getChar();
                        return new PlusPlusToken(line, column);
                    }
                    if (n != 61) return new PlusToken(line, column);
                    this.reader.getChar();
                    return new PlusEqualToken(line, column);
                }
                if (cc == 45) {
                    int n = this.reader.peekChar();
                    if (n == 45) {
                        this.reader.getChar();
                        return new MinusMinusToken(line, column);
                    }
                    if (n != 61) return new MinusToken(line, column);
                    this.reader.getChar();
                    return new MinusEqualToken(line, column);
                }
                if (cc == 33) {
                    if (this.reader.peekChar() != 61) return new ExclamationToken(line, column);
                    this.reader.getChar();
                    if (this.reader.peekChar() != 61) return new ExclamationEqualToken(line, column);
                    this.reader.getChar();
                    return new ExclamationEqualEqualToken(line, column);
                }
                if (cc == 126) {
                    return new TildeToken(line, column);
                }
                if (cc == 42) {
                    if (this.reader.peekChar() != 61) return new AsteriskToken(line, column);
                    this.reader.getChar();
                    return new AsteriskEqualToken(line, column);
                }
                if (cc == 37) {
                    if (this.reader.peekChar() != 61) return new PercentToken(line, column);
                    this.reader.getChar();
                    return new PercentEqualToken(line, column);
                }
                if (cc == 61) {
                    if (this.reader.peekChar() != 61) return new EqualToken(line, column);
                    this.reader.getChar();
                    if (this.reader.peekChar() != 61) return new DoubleEqualToken(line, column);
                    this.reader.getChar();
                    return new TripleEqualToken(line, column);
                }
                if (cc == 38) {
                    int n = this.reader.peekChar();
                    if (n == 38) {
                        this.reader.getChar();
                        if (this.reader.peekChar() != 61) return new AmpersandAmpersand(line, column);
                        this.reader.getChar();
                        return new AmpersandAmpersandEqual(line, column);
                    }
                    if (n != 61) return new AmpersandToken(line, column);
                    this.reader.getChar();
                    return new AmpersandEqual(line, column);
                }
                if (cc == 94) {
                    if (this.reader.peekChar() != 61) return new HatToken(line, column);
                    this.reader.getChar();
                    return new HatEqualToken(line, column);
                }
                if (cc == 124) {
                    int n = this.reader.peekChar();
                    if (n == 124) {
                        this.reader.getChar();
                        if (this.reader.peekChar() != 61) return new PipePipeToken(line, column);
                        this.reader.getChar();
                        return new PipePipeEqualToken(line, column);
                    }
                    if (n != 61) return new PipeToken(line, column);
                    return new PipeEqualToken(line, column);
                }
                if (cc == 63) {
                    return new QuestionToken(line, column);
                }
                if (cc == 44) {
                    return new CommaToken(line, column);
                }
                if (cc == 59) {
                    return new SemicolonToken(line, column);
                }
                if (this.isIdentifierStart(cc)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)cc);
                    this.readIdentifier(sb);
                    String name = sb.toString();
                    KeywordToken token = this.processKeyword(name, line, column);
                    if (token == null) return new IdentifierToken(line, column, name);
                    return token;
                }
                if (cc == -1) return new EofAsToken(line, column);
                if (cc != 65279) throw new ScannerError(String.format(UNEXPECTED_CHAR, Character.valueOf((char)cc), "."));
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (BufferError e) {
            throw e;
        }
        catch (ScannerError e) {
            this.handleScannerError(e);
        }
        return new EofAsToken(line, column);
    }

    void setTokenContext(TokenContext tokenContext) {
        this.tc = tokenContext;
    }

    void close() throws IOException {
        this.reader.close();
    }
}

