/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.managers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.CheckRule;
import com.vmware.vide.vwcsdktools.managers.CheckRuleFileLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public enum CheckRuleManager {
    ANNOTATION_INSTANCE("/resources/check.rule"),
    METADATA_TAG_INSTANCE("/resources/metadata-tag-check.rule");

    private String checkRuleFilePath;
    private String checkRuleFileName;
    private List<CheckRule> rules;
    private Set<String> supportedAnnotations;

    private CheckRuleManager(String checkRuleFilePath) {
        this.checkRuleFilePath = checkRuleFilePath;
        this.checkRuleFileName = new Path(checkRuleFilePath).lastSegment();
        this.init();
    }

    private void init() {
        String ruleFile = this.getRuleFile();
        if (ruleFile != null) {
            try {
                this.rules = this.load(ruleFile);
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.load();
    }

    private void load() {
        InputStream is = Activator.getDefault().getResourceAsStream(this.checkRuleFilePath);
        CheckRuleFileLoader loader = new CheckRuleFileLoader(this.checkRuleFilePath, is);
        this.rules = loader.parse();
    }

    public List<CheckRule> load(String fileName) throws FileNotFoundException {
        CheckRuleFileLoader loader = new CheckRuleFileLoader(fileName);
        return loader.parse();
    }

    public List<CheckRule> getRules() {
        return this.rules;
    }

    private String getRuleFile() {
        String ruleFile = this.getRuleFileFromWorkspace();
        if (ruleFile == null) {
            ruleFile = this.getRuleFileFromInstallation();
        }
        return ruleFile;
    }

    private String getRuleFileFromWorkspace() {
        String ruleFile = null;
        File file = Activator.getDefault().getStateLocation().append(this.checkRuleFileName).toFile();
        if (file.exists()) {
            ruleFile = file.getAbsolutePath();
        }
        return ruleFile;
    }

    private String getRuleFileFromInstallation() {
        File file;
        URL url;
        String ruleFile = null;
        Location location = Platform.getConfigurationLocation();
        if (location != null && (url = location.getURL()).getProtocol().startsWith("file") && !(file = new File(ruleFile = String.valueOf(url.getFile()) + File.separator + "com.vmware.vide.vwcsdktools" + File.separator + this.checkRuleFileName)).exists()) {
            try {
                Activator.getDefault().copyFileFromPluginRegistry(file, this.checkRuleFilePath);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return ruleFile;
    }

    public Set<String> getSupportedAnnotationTypes() {
        if (this.supportedAnnotations == null) {
            List<CheckRule> rules = this.getRules();
            this.supportedAnnotations = new HashSet<String>();
            for (CheckRule rule : rules) {
                this.supportedAnnotations.add(rule.name);
            }
        }
        return this.supportedAnnotations;
    }
}

