/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.whitelist;

import com.vmware.vide.vwcsdktools.whitelist.WhiteListItem;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Operator {
    None(new ReplaceOp()),
    Plus(new PlusOp()),
    Minus(new MinusOp());

    private Op<WhiteListItem> op;

    private Operator(Op<WhiteListItem> op) {
        this.op = op;
    }

    public void operate(WhiteListItem item, Map<String, Set<String>> table) {
        this.op.operate(item, table);
    }

    static class MinusOp
    implements Op<WhiteListItem> {
        MinusOp() {
        }

        @Override
        public void operate(WhiteListItem item, Map<String, Set<String>> table) {
            Set<String> list = table.get(item.getName());
            for (String s : item.getList()) {
                list.remove(s);
            }
        }
    }

    static interface Op<T> {
        public void operate(T var1, Map<String, Set<String>> var2);
    }

    static class PlusOp
    implements Op<WhiteListItem> {
        PlusOp() {
        }

        @Override
        public void operate(WhiteListItem item, Map<String, Set<String>> table) {
            table.get(item.getName()).addAll(new HashSet<String>(item.getList()));
        }
    }

    static class ReplaceOp
    implements Op<WhiteListItem> {
        ReplaceOp() {
        }

        @Override
        public void operate(WhiteListItem item, Map<String, Set<String>> table) {
            table.remove(item.getName());
            table.put(item.getName(), new HashSet<String>(item.getList()));
        }
    }
}

