/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.whitelist;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.exceptions.ParseFileException;
import com.vmware.vide.vwcsdktools.whitelist.Operator;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListItem;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ILog;

public class WhiteListFileLoader {
    private static final String ERR_FROM_NO_PREVIOUS_LIST = "Previous list [%s] was not defined.";
    private static final String ERR_FORM_FAIL_PARSING = "Failed to parse the white list file [%s].";
    private static ILog logger = Activator.getDefault().getLog();
    private final File file;
    private InputStream is;
    private List<String> fileList;
    private int lineCount;
    private boolean inItems;
    private ArrayList<WhiteListFileLoader> loaders;

    public WhiteListFileLoader(File file) throws ParseFileException {
        this(file, null);
        this.fileList = new ArrayList<String>();
        this.loaders = new ArrayList();
        this.fileList.add(file.getAbsolutePath());
        this.loaders.add(this);
    }

    public WhiteListFileLoader(String file, InputStream is) throws ParseFileException {
        this(new File(file), null);
        this.fileList = new ArrayList<String>();
        this.loaders = new ArrayList();
        this.fileList.add(new File(file).getAbsolutePath());
        this.loaders.add(this);
        this.is = is;
    }

    private WhiteListFileLoader(File file, WhiteListFileLoader loader) throws ParseFileException {
        this.file = file;
        this.lineCount = 1;
        if (loader != null) {
            if (loader.fileList.contains(file.getAbsolutePath())) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("File [%s] is included recursively.\n", file.getAbsolutePath()));
                for (WhiteListFileLoader l : this.loaders) {
                    sb.append("    ");
                    sb.append(l.file.getAbsolutePath());
                    sb.append(":");
                    sb.append(l.lineCount);
                    sb.append('\n');
                }
                throw new ParseFileException(sb.toString(), loader.file, loader.lineCount);
            }
            this.fileList = loader.fileList;
            this.loaders = loader.loaders;
            this.fileList.add(file.getAbsolutePath());
            this.loaders.add(this);
        }
    }

    /*
     * Exception decompiling
     */
    List<WhiteListItem> parse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private WhiteListItem createWhiteListItem(String listName, Operator operator, List<String> listItems) {
        WhiteListItem listItem = new WhiteListItem();
        listItem.name = listName;
        listItem.operator = operator;
        listItem.list = listItems;
        return listItem;
    }

    private String processListName(String name) throws ParseFileException {
        if (name.isEmpty()) {
            throw new ParseFileException("No list name.", this.file, this.lineCount);
        }
        return name;
    }

    private String processItem(String itemLine) {
        char surrounder;
        if (itemLine.length() > 1 && ((surrounder = itemLine.charAt(0)) == '\"' || surrounder == '\'') && itemLine.charAt(itemLine.length() - 1) == surrounder) {
            return itemLine.substring(1, itemLine.length() - 1);
        }
        return itemLine;
    }

    private void startItems() {
        this.inItems = true;
    }

    private void endItems() {
        this.inItems = false;
    }

    private boolean isItems() {
        return this.inItems;
    }
}

