/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.appliance.recovery;

import com.vmware.appliance.recovery.BackupDefinitions;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.client.exception.BindingsException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public interface BackupTypes {

    public static final class BackupRequest
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private List<String> parts;
        private char[] backupPassword;
        private LocationType locationType;
        private String location;
        private String locationUser;
        private char[] locationPassword;
        private String comment;
        protected final StructValue __dynamicStructureFields;

        public BackupRequest() {
            this(BackupRequest.createEmptyStructValue());
        }

        protected BackupRequest(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public void setParts(List<String> list) {
            this.parts = list;
        }

        public char[] getBackupPassword() {
            return this.backupPassword;
        }

        public void setBackupPassword(char[] cArray) {
            this.backupPassword = cArray;
        }

        public LocationType getLocationType() {
            return this.locationType;
        }

        public void setLocationType(LocationType locationType) {
            this.locationType = locationType;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String string) {
            this.location = string;
        }

        public String getLocationUser() {
            return this.locationUser;
        }

        public void setLocationUser(String string) {
            this.locationUser = string;
        }

        public char[] getLocationPassword() {
            return this.locationPassword;
        }

        public void setLocationPassword(char[] cArray) {
            this.locationPassword = cArray;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string;
        }

        public StructType _getType() {
            return BackupDefinitions.backupRequest;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("parts", BindingsUtil.toDataValue(this.parts, (Type)this._getType().getField("parts")));
            structValue.setField("backup_password", BindingsUtil.toDataValue((Object)this.backupPassword, (Type)this._getType().getField("backup_password")));
            structValue.setField("location_type", BindingsUtil.toDataValue((Object)((Object)this.locationType), (Type)this._getType().getField("location_type")));
            structValue.setField("location", BindingsUtil.toDataValue((Object)this.location, (Type)this._getType().getField("location")));
            structValue.setField("location_user", BindingsUtil.toDataValue((Object)this.locationUser, (Type)this._getType().getField("location_user")));
            structValue.setField("location_password", BindingsUtil.toDataValue((Object)this.locationPassword, (Type)this._getType().getField("location_password")));
            structValue.setField("comment", BindingsUtil.toDataValue((Object)this.comment, (Type)this._getType().getField("comment")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return BackupDefinitions.backupRequest;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return BackupRequest._getClassType().getName();
        }

        public static BackupRequest _newInstance(StructValue structValue) {
            return new BackupRequest(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(BackupDefinitions.backupRequest.getName());
        }

        public static final class Builder {
            private List<String> parts;
            private char[] backupPassword;
            private LocationType locationType;
            private String location;
            private String locationUser;
            private char[] locationPassword;
            private String comment;

            public Builder(List<String> list, LocationType locationType, String string) {
                this.parts = list;
                this.locationType = locationType;
                this.location = string;
            }

            public Builder setBackupPassword(char[] cArray) {
                this.backupPassword = cArray;
                return this;
            }

            public Builder setLocationUser(String string) {
                this.locationUser = string;
                return this;
            }

            public Builder setLocationPassword(char[] cArray) {
                this.locationPassword = cArray;
                return this;
            }

            public Builder setComment(String string) {
                this.comment = string;
                return this;
            }

            public BackupRequest build() {
                BackupRequest backupRequest = new BackupRequest();
                backupRequest.setParts(this.parts);
                backupRequest.setBackupPassword(this.backupPassword);
                backupRequest.setLocationType(this.locationType);
                backupRequest.setLocation(this.location);
                backupRequest.setLocationUser(this.locationUser);
                backupRequest.setLocationPassword(this.locationPassword);
                backupRequest.setComment(this.comment);
                return backupRequest;
            }
        }
    }

    public static final class ReturnResult
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private ReturnStatus status;
        private List<LocalizableMessage> messages;
        protected final StructValue __dynamicStructureFields;

        public ReturnResult() {
            this(ReturnResult.createEmptyStructValue());
        }

        protected ReturnResult(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public ReturnStatus getStatus() {
            return this.status;
        }

        public void setStatus(ReturnStatus returnStatus) {
            this.status = returnStatus;
        }

        public List<LocalizableMessage> getMessages() {
            return this.messages;
        }

        public void setMessages(List<LocalizableMessage> list) {
            this.messages = list;
        }

        public StructType _getType() {
            return BackupDefinitions.returnResult;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("status", BindingsUtil.toDataValue((Object)((Object)this.status), (Type)this._getType().getField("status")));
            structValue.setField("messages", BindingsUtil.toDataValue(this.messages, (Type)this._getType().getField("messages")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return BackupDefinitions.returnResult;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return ReturnResult._getClassType().getName();
        }

        public static ReturnResult _newInstance(StructValue structValue) {
            return new ReturnResult(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(BackupDefinitions.returnResult.getName());
        }

        public static final class Builder {
            private ReturnStatus status;
            private List<LocalizableMessage> messages;

            public Builder(ReturnStatus returnStatus, List<LocalizableMessage> list) {
                this.status = returnStatus;
                this.messages = list;
            }

            public ReturnResult build() {
                ReturnResult returnResult = new ReturnResult();
                returnResult.setStatus(this.status);
                returnResult.setMessages(this.messages);
                return returnResult;
            }
        }
    }

    public static final class LocalizableMessage
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String id;
        private String defaultMessage;
        private List<String> args;
        protected final StructValue __dynamicStructureFields;

        public LocalizableMessage() {
            this(LocalizableMessage.createEmptyStructValue());
        }

        protected LocalizableMessage(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getDefaultMessage() {
            return this.defaultMessage;
        }

        public void setDefaultMessage(String string) {
            this.defaultMessage = string;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> list) {
            this.args = list;
        }

        public StructType _getType() {
            return BackupDefinitions.localizableMessage;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("id", BindingsUtil.toDataValue((Object)this.id, (Type)this._getType().getField("id")));
            structValue.setField("default_message", BindingsUtil.toDataValue((Object)this.defaultMessage, (Type)this._getType().getField("default_message")));
            structValue.setField("args", BindingsUtil.toDataValue(this.args, (Type)this._getType().getField("args")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return BackupDefinitions.localizableMessage;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return LocalizableMessage._getClassType().getName();
        }

        public static LocalizableMessage _newInstance(StructValue structValue) {
            return new LocalizableMessage(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(BackupDefinitions.localizableMessage.getName());
        }

        public static final class Builder {
            private String id;
            private String defaultMessage;
            private List<String> args;

            public Builder(String string, String string2, List<String> list) {
                this.id = string;
                this.defaultMessage = string2;
                this.args = list;
            }

            public LocalizableMessage build() {
                LocalizableMessage localizableMessage = new LocalizableMessage();
                localizableMessage.setId(this.id);
                localizableMessage.setDefaultMessage(this.defaultMessage);
                localizableMessage.setArgs(this.args);
                return localizableMessage;
            }
        }
    }

    public static final class LocationType
    extends ApiEnumeration<LocationType> {
        public static final LocationType FTP = new LocationType("FTP");
        public static final LocationType HTTP = new LocationType("HTTP");
        public static final LocationType FTPS = new LocationType("FTPS");
        public static final LocationType HTTPS = new LocationType("HTTPS");
        public static final LocationType SCP = new LocationType("SCP");
        private static final long serialVersionUID = 1L;
        private static final LocationType[] $VALUES = new LocationType[]{FTP, HTTP, FTPS, HTTPS, SCP};
        private static final Map<String, LocationType> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

        private LocationType() {
            super(Values._UNKNOWN.name());
        }

        private LocationType(String string) {
            super(string);
        }

        public static LocationType[] values() {
            return (LocationType[])$VALUES.clone();
        }

        public static LocationType valueOf(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            LocationType locationType = $NAME_TO_VALUE_MAP.get(string);
            if (locationType != null) {
                return locationType;
            }
            return new LocationType(string);
        }

        public boolean isUnknown() {
            return this.getEnumValue() == Values._UNKNOWN;
        }

        public Values getEnumValue() {
            try {
                return Values.valueOf(this.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Values._UNKNOWN;
            }
        }

        private Object readResolve() {
            return LocationType.valueOf(this.name());
        }

        public static enum Values {
            FTP,
            HTTP,
            FTPS,
            HTTPS,
            SCP,
            _UNKNOWN;

        }
    }

    public static final class ReturnStatus
    extends ApiEnumeration<ReturnStatus> {
        public static final ReturnStatus FAIL = new ReturnStatus("FAIL");
        public static final ReturnStatus WARNING = new ReturnStatus("WARNING");
        public static final ReturnStatus OK = new ReturnStatus("OK");
        private static final long serialVersionUID = 1L;
        private static final ReturnStatus[] $VALUES = new ReturnStatus[]{FAIL, WARNING, OK};
        private static final Map<String, ReturnStatus> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

        private ReturnStatus() {
            super(Values._UNKNOWN.name());
        }

        private ReturnStatus(String string) {
            super(string);
        }

        public static ReturnStatus[] values() {
            return (ReturnStatus[])$VALUES.clone();
        }

        public static ReturnStatus valueOf(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            ReturnStatus returnStatus = $NAME_TO_VALUE_MAP.get(string);
            if (returnStatus != null) {
                return returnStatus;
            }
            return new ReturnStatus(string);
        }

        public boolean isUnknown() {
            return this.getEnumValue() == Values._UNKNOWN;
        }

        public Values getEnumValue() {
            try {
                return Values.valueOf(this.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Values._UNKNOWN;
            }
        }

        private Object readResolve() {
            return ReturnStatus.valueOf(this.name());
        }

        public static enum Values {
            FAIL,
            WARNING,
            OK,
            _UNKNOWN;

        }
    }
}

