/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.util;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vcenter.DeploymentDefinitions;
import com.vmware.vcenter.deployment.ImportHistoryDefinitions;
import com.vmware.vcenter.deployment.InstallDefinitions;
import com.vmware.vcenter.deployment.MigrateDefinitions;
import com.vmware.vcenter.deployment.QuestionDefinitions;
import com.vmware.vcenter.deployment.StructDefinitions;
import com.vmware.vcenter.deployment.UpgradeDefinitions;
import com.vmware.vcenter.deployment.install.initial_config.remote_psc.ThumbprintDefinitions;
import com.vmware.vcenter.services.ServiceDefinitions;
import com.vmware.vcenter.system_config.DeploymentTypeDefinitions;
import com.vmware.vcenter.system_config.PscRegistrationDefinitions;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> map) {
        Validate.notNull(map);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.task", DeploymentDefinitions.task);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.info", DeploymentDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.install.initial_config.remote_psc.thumbprint.remote_spec", ThumbprintDefinitions.remoteSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.notification", StructDefinitions.notification);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.notifications", StructDefinitions.notifications);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.standalone_spec", StructDefinitions.standaloneSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.standalone_psc_spec", StructDefinitions.standalonePscSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.replicated_spec", StructDefinitions.replicatedSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.replicated_psc_spec", StructDefinitions.replicatedPscSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.remote_psc_spec", StructDefinitions.remotePscSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.check_info", StructDefinitions.checkInfo);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.history_migration_spec", StructDefinitions.historyMigrationSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.location_spec", StructDefinitions.locationSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.install.vcsa_embedded_spec", InstallDefinitions.vcsaEmbeddedSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.install.psc_spec", InstallDefinitions.pscSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.install.install_spec", InstallDefinitions.installSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.upgrade.vcsa_embedded_spec", UpgradeDefinitions.vcsaEmbeddedSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.upgrade.psc_spec", UpgradeDefinitions.pscSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.upgrade.source_appliance_spec", UpgradeDefinitions.sourceApplianceSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.upgrade.upgrade_spec", UpgradeDefinitions.upgradeSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.migrate.migration_assistant_spec", MigrateDefinitions.migrationAssistantSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.migrate.migrate_spec", MigrateDefinitions.migrateSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.question.question", QuestionDefinitions.question);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.question.info", QuestionDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.question.answer_spec", QuestionDefinitions.answerSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.import_history.info", ImportHistoryDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.vcenter.deployment.import_history.create_spec", ImportHistoryDefinitions.createSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.services.service.info", ServiceDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.vcenter.services.service.update_spec", ServiceDefinitions.updateSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.system_config.deployment_type.info", DeploymentTypeDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.vcenter.system_config.deployment_type.reconfigure_spec", DeploymentTypeDefinitions.reconfigureSpec);
        StructTypeUtil.add(map, "com.vmware.vcenter.system_config.psc_registration.info", PscRegistrationDefinitions.info);
    }

    private static void add(Map<String, StructType> map, String string, StructType structType) {
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + string + ". Unable to populate the map.");
        }
        map.put(string, structType);
    }
}

