/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.util;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OvfUtil {
    private static final String OVF_STYLESHEET = "/ovfXmlStyle.xsl";
    private static final Log _logger = LogFactory.getLog(OvfUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String styleOvfSection(String string) throws TransformerException, RuntimeException {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        InputStream inputStream = OvfUtil.class.getResourceAsStream(OVF_STYLESHEET);
        if (inputStream == null) {
            throw new RuntimeException("Unable to load stylesheet");
        }
        String string2 = null;
        try {
            string2 = XMLUtil.xslTransform((String)string, (InputStream)inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                _logger.debug((Object)"Exception trying to close XSL stream", (Throwable)iOException);
            }
        }
        return string2;
    }
}

