/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.remoting;

import com.vmware.vise.messaging.internal.Config;
import com.vmware.vise.security.SessionManagementFilter;
import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import flex.messaging.FlexContext;
import flex.messaging.messages.Message;
import flex.messaging.messages.RemotingMessage;
import flex.messaging.services.remoting.adapters.JavaAdapter;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaAdapterEx
extends JavaAdapter {
    private static final Log _logger = LogFactory.getLog(JavaAdapterEx.class);
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    private static final Set<String> _whiteListedAmfCalls = new HashSet<String>();

    public Object invoke(Message message) {
        HttpServletRequest httpServletRequest = FlexContext.getHttpRequest();
        JavaAdapterEx.associateSessionWithClientId(httpServletRequest, message);
        String string = JavaAdapterEx.storeOpIdInFlexRequest(httpServletRequest, message);
        RuntimeException runtimeException = null;
        String string2 = null;
        long l = 0L;
        try {
            Object object;
            if (_opIdLogger.isDebugEnabled()) {
                string2 = JavaAdapterEx.getMessageDebugInfo(message);
                _opIdLogger.debug((Object)("Processing AMF message with opId '" + string + "': " + string2 + "  (" + JavaAdapterEx.class.getName() + ")"));
            }
            l = System.nanoTime();
            Object object2 = object = super.invoke(message);
            return object2;
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            throw runtimeException2;
        }
        finally {
            long l2 = System.nanoTime() - l;
            SessionManagementFilter.logWarningIfNecessary((HttpServletRequest)httpServletRequest, (long)l2, (long)Config.AMF_INVOKE_LOG_TIMEOUT_IN_NANOS, (Exception)runtimeException);
        }
    }

    private static void associateSessionWithClientId(HttpServletRequest httpServletRequest, Message message) {
        if (httpServletRequest == null) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return;
        }
        if (SessionUtil.isLogoutInitiated((HttpSession)httpSession)) {
            _logger.error((Object)String.format("An attempt was made to access a logged-out session, (%s), %s", SessionUtil.getSessionInfo(), JavaAdapterEx.getMessageDebugInfo(message)));
            throw new NotAuthenticatedError();
        }
        String string = (String)message.getHeader("webClientSessionId");
        if (StringUtil.isNullOrEmpty((String)string)) {
            if (JavaAdapterEx.isAmfCallWhitelisted(message)) {
                return;
            }
            throw new IllegalArgumentException("Invalid AMF request.");
        }
        String string2 = SessionUtil.getClientId((HttpSession)httpSession);
        if (!string.equals(string2)) {
            try {
                SessionUtil.associateSessionWithClientId((HttpSession)httpSession, (String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (JavaAdapterEx.isAmfCallToBackendLogService(message)) {
                    return;
                }
                _logger.error((Object)String.format("The clientId is invalid. This is probably because a different session associated with the clientId has expired or logged out. %s", JavaAdapterEx.getMessageDebugInfo(message)));
                throw new NotAuthenticatedError();
            }
        } else if (SessionUtil.isAssociatedWithInvalidClientId((HttpSession)httpSession)) {
            if (JavaAdapterEx.isAmfCallToBackendLogService(message)) {
                return;
            }
            String string3 = httpServletRequest.getContextPath();
            _logger.error((Object)String.format("An attempt was made to access a session associated with an invalid clientId. (%s, context path = %s), %s", SessionUtil.getSessionInfo(), string3, JavaAdapterEx.getMessageDebugInfo(message)));
            throw new NotAuthenticatedError();
        }
    }

    private static boolean isAmfCallWhitelisted(Message message) {
        if (!(message instanceof RemotingMessage)) {
            return false;
        }
        String string = JavaAdapterEx.getMessageDescriptor((RemotingMessage)message);
        return string != null && _whiteListedAmfCalls.contains(string);
    }

    private static String getMessageDescriptor(RemotingMessage remotingMessage) {
        if (remotingMessage == null) {
            return null;
        }
        String string = remotingMessage.getDestination() + "::" + remotingMessage.getOperation();
        return string;
    }

    private static boolean isAmfCallToBackendLogService(Message message) {
        if (!(message instanceof RemotingMessage)) {
            return false;
        }
        RemotingMessage remotingMessage = (RemotingMessage)message;
        return "backendLogService".equals(remotingMessage.getDestination());
    }

    private static String getMessageDebugInfo(Message message) {
        StringBuffer stringBuffer = new StringBuffer("destination = " + message.getDestination());
        if (message instanceof RemotingMessage) {
            stringBuffer.append(", operation = ").append(((RemotingMessage)message).getOperation());
        }
        stringBuffer.append(", messageId = ").append(message.getMessageId());
        return stringBuffer.toString();
    }

    private static String storeOpIdInFlexRequest(HttpServletRequest httpServletRequest, Message message) {
        if (httpServletRequest == null) {
            return null;
        }
        Object v = message.getHeaders().get("opId");
        String string = v == null ? OpIdUtil.generateOpIdPrefixForRequest() : v.toString();
        OpIdUtil.setOpIdPrefixIntoRequest((HttpServletRequest)httpServletRequest, (String)string);
        return string;
    }

    static {
        _whiteListedAmfCalls.add("userSessionServiceInternal::getUserSession");
        _whiteListedAmfCalls.add("userSessionServiceInternal::initSession");
        _whiteListedAmfCalls.add("userSessionServiceInternal::sessionPing");
        _whiteListedAmfCalls.add("configurationService::getProperty");
        _whiteListedAmfCalls.add("configurationService::getConfiguration");
        _whiteListedAmfCalls.add("backendLogService::error");
        _whiteListedAmfCalls.add("backendLogService::warn");
        _whiteListedAmfCalls.add("backendLogService::info");
        _whiteListedAmfCalls.add("backendLogService::debug");
        _whiteListedAmfCalls.add("backendLogService::trace");
    }
}

