/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core;

import java.net.URI;
import java.util.Collections;
import java.util.Set;

public class RoleData {
    private final long _roleId;
    private final Set<String> _privilegeIds;
    private final String _roleName;
    private final long _version;
    private final String _description;
    private final URI _tenant;

    public RoleData(String roleName, long roleId, String description, Set<String> privilegeIds, URI tenant, long version) {
        this._roleId = roleId;
        this._privilegeIds = Collections.unmodifiableSet(privilegeIds);
        this._roleName = roleName;
        this._version = version;
        this._description = description;
        this._tenant = tenant;
    }

    public long getId() {
        return this._roleId;
    }

    public long getVersion() {
        return this._version;
    }

    public String getName() {
        return this._roleName;
    }

    public Set<String> getPrivilegeIds() {
        return this._privilegeIds;
    }

    public String getDesciption() {
        return this._description;
    }

    public URI getTenant() {
        return this._tenant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._description == null ? 0 : this._description.hashCode());
        result = 31 * result + (this._privilegeIds == null ? 0 : this._privilegeIds.hashCode());
        result = 31 * result + (int)(this._roleId ^ this._roleId >>> 32);
        result = 31 * result + (this._roleName == null ? 0 : this._roleName.hashCode());
        result = 31 * result + (this._tenant == null ? 0 : this._tenant.hashCode());
        result = 31 * result + (int)(this._version ^ this._version >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoleData other = (RoleData)obj;
        if (this._description == null ? other._description != null : !this._description.equals(other._description)) {
            return false;
        }
        if (this._privilegeIds == null ? other._privilegeIds != null : !this._privilegeIds.equals(other._privilegeIds)) {
            return false;
        }
        if (this._roleId != other._roleId) {
            return false;
        }
        if (this._roleName == null ? other._roleName != null : !this._roleName.equals(other._roleName)) {
            return false;
        }
        if (this._tenant == null ? other._tenant != null : !this._tenant.equals(other._tenant)) {
            return false;
        }
        return this._version == other._version;
    }
}

