/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.vmware.cis.core.util.ImmutableUtils;
import com.vmware.cis.core.util.MonitorReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerationalCache<K, V> {
    private static final int CLEANUP_DELAY = 300000;
    private static final long DELETE_EXPIRY = 300000L;
    private final ConcurrentHashMap<K, ValueHolder<V>> _map = new ConcurrentHashMap();
    private final String _id = UUID.randomUUID().toString();
    private final AtomicLong _currentGeneration = new AtomicLong();
    private final Log _log;
    private final Predicate<Map.Entry<K, V>> _nullValueFilter = new Predicate<Map.Entry<K, V>>(){

        public boolean apply(Map.Entry<K, V> entry) {
            if (entry == null || entry.getKey() == null) {
                return false;
            }
            return entry.getValue() != null;
        }
    };
    private final ImmutableUtils.TransformMapValueFunc<ValueHolder<V>, V> _transformEntryFunc = new ImmutableUtils.TransformMapValueFunc<ValueHolder<V>, V>(){

        @Override
        public V to(Object key, ValueHolder<V> from) {
            return from._value;
        }

        @Override
        public ValueHolder<V> from(Object key, V to) {
            return new ValueHolder(0L, to, 0L, 0L);
        }
    };
    private final Map<K, V> _completeMap;
    private final ScheduledExecutorService _executor;
    private final Object _cleanUp = new Object(){

        protected void finalize() throws Throwable {
            GenerationalCache.this._executor.shutdown();
        }
    };
    private final long _deleteExpiry;
    private final Set<Long> _inflightTimestamps = new HashSet<Long>();
    private final AtomicLong _deleteCount = new AtomicLong(0L);

    public GenerationalCache(String name) {
        this(300000L, name);
    }

    public GenerationalCache(long deleteExpiry, String name) {
        this(deleteExpiry, name, 300000L);
    }

    public GenerationalCache(long deleteExpiry, final String name, long cleanupDelay) {
        this._log = LogFactory.getLog((String)(GenerationalCache.class.getName() + "." + name));
        this._deleteExpiry = deleteExpiry;
        this._executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setDaemon(true);
                th.setName("GenerationalCache-Cleanup-" + name);
                return th;
            }
        });
        Map<K, V> completeMap = ImmutableUtils.transformValueMap(this._map, this._transformEntryFunc);
        this._completeMap = ImmutableUtils.filteredMap(completeMap, this._nullValueFilter);
        this._executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    GenerationalCache.this.cleanup();
                }
                catch (Throwable t) {
                    GenerationalCache.this._log.warn((Object)"Could not cleanup delete entries.", t);
                }
            }
        }, cleanupDelay, cleanupDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long smallestInflightGen;
        if (this._deleteCount.get() == 0L) {
            return;
        }
        Set<Long> set = this._inflightTimestamps;
        synchronized (set) {
            smallestInflightGen = System.currentTimeMillis();
            if (!this._inflightTimestamps.isEmpty()) {
                smallestInflightGen = Collections.min(this._inflightTimestamps);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Inflight operation with following timetsmap " + this._inflightTimestamps + ". Selected timestamp " + smallestInflightGen + " for cleanup."));
                }
            }
        }
        Iterator<Map.Entry<K, ValueHolder<V>>> iter = this._map.entrySet().iterator();
        long entriesEnpiredTimestamp = smallestInflightGen - this._deleteExpiry;
        while (iter.hasNext()) {
            Map.Entry<K, ValueHolder<V>> e = iter.next();
            if (e.getValue()._value != null || e.getValue()._timestamp >= entriesEnpiredTimestamp) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Removing key=" + e.getKey() + " updates at " + e.getValue()._timestamp));
            }
            iter.remove();
            this._deleteCount.decrementAndGet();
        }
    }

    public boolean putIfLatest(K key, V value, long version) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        return this.internalPut(key, value, version);
    }

    private boolean internalPut(K key, V value, long version) {
        long currentTime;
        ValueHolder<V> oldValue;
        long newGeneration;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("inernalPut called for version= " + version + ",key=" + key + ",value=" + value));
        }
        while (true) {
            ValueHolder<V> newValue;
            long expectedGeneration = this._currentGeneration.get();
            newGeneration = expectedGeneration + 1L;
            oldValue = this._map.get(key);
            currentTime = System.currentTimeMillis();
            if (oldValue == null) {
                newValue = new ValueHolder<V>(newGeneration, value, version, currentTime);
                if (this._map.putIfAbsent(key, newValue) != null || !this._currentGeneration.compareAndSet(expectedGeneration, newGeneration)) continue;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Inserted key=" + key + " value=" + value + " at generation=" + newGeneration + " timestamp=" + currentTime));
                }
                return true;
            }
            if (oldValue._version > version) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("putIfLatest returned false because of old version for version= " + version + ",key=" + key + ",value=" + value));
                }
                return false;
            }
            if (oldValue._version == version && oldValue._value == null && value == null) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("putIfLatest returned false because of version and null value for version= " + version + ",key=" + key + ",value=" + value));
                }
                return false;
            }
            newValue = new ValueHolder<V>(newGeneration, value, version, currentTime);
            if (this._map.replace(key, oldValue, newValue) && this._currentGeneration.compareAndSet(expectedGeneration, newGeneration)) break;
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("Updated key=" + key + " value=" + value + " oldValue=" + oldValue._value + " at generation=" + newGeneration + " timestamp=" + currentTime));
        }
        return true;
    }

    public V get(K key) {
        ValueHolder<V> value = this._map.get(key);
        return value == null ? null : (V)value._value;
    }

    public boolean removeIfLatest(K key, long version) {
        Preconditions.checkNotNull(key);
        if (!this._map.containsKey(key)) {
            return false;
        }
        boolean result = this.internalPut(key, null, version);
        if (result) {
            this._deleteCount.incrementAndGet();
        }
        return result;
    }

    public Map<K, V> getMap() {
        return this._completeMap;
    }

    public Update<K, V> getUpdates(String version) {
        Update<K, V> result = this.getUpdatesInternal(version);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("getUpdates from version " + version));
            if (!result.isDelta()) {
                this._log.trace((Object)("Sending complete map with generation=" + result.getVersion() + " entries=" + result.getMap()));
            } else {
                this._log.trace((Object)("Sending delta with generation=" + result.getVersion() + " entries=" + result.getMap()));
            }
        } else if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("gotVersion=" + version + ", newVersion=" + result.getVersion() + ", isDelta=" + result.isDelta() + ", size=" + result.getMap().size()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(String version) {
        VersionInfo versionInfo = this.getVersionInfo(version);
        if (versionInfo == null) {
            return;
        }
        Set<Long> set = this._inflightTimestamps;
        synchronized (set) {
            this._inflightTimestamps.remove(versionInfo._timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Update<K, V> getUpdatesInternal(String version) {
        final VersionInfo newVersion = new VersionInfo(System.currentTimeMillis(), this._currentGeneration.get());
        final VersionInfo from = this.getVersionInfo(version);
        String newVersionStr = this._id + ":" + newVersion._timestamp + ":" + newVersion._generation;
        if (from == null || from._generation > newVersion._generation) {
            return new Update<K, V>(this._completeMap, newVersionStr, false);
        }
        if (from._generation == newVersion._generation) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("fromGeneration=newGeneration=" + from._generation));
            }
            return new Update(Collections.emptyMap(), newVersionStr, true);
        }
        Set<Long> set = this._inflightTimestamps;
        synchronized (set) {
            long timediff = newVersion._timestamp - from._timestamp;
            if (timediff >= this._deleteExpiry) {
                return new Update<K, V>(this._completeMap, newVersionStr, false);
            }
            Predicate filterPredicate = new Predicate<Map.Entry<K, ValueHolder<V>>>(){

                public boolean apply(Map.Entry<K, ValueHolder<V>> entry) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null) {
                        return false;
                    }
                    ValueHolder holder = entry.getValue();
                    return holder._generation > from._generation;
                }
            };
            Map<K, ValueHolder<V>> filteredMap = ImmutableUtils.filteredMap(this._map, filterPredicate);
            Map<K, V> transformedMap = ImmutableUtils.transformValueMap(filteredMap, this._transformEntryFunc);
            this._inflightTimestamps.add(newVersion._timestamp);
            try {
                Update<K, V> deltaResult = new Update<K, V>(transformedMap, newVersionStr, true);
                MonitorReference.watch(deltaResult, new MonitorReference.CleanupFunc(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void cleanup() {
                        if (GenerationalCache.this._log.isDebugEnabled()) {
                            GenerationalCache.this._log.debug((Object)("Removing update with timestamp " + newVersion._timestamp + " from in flight operations set."));
                        }
                        Set set = GenerationalCache.this._inflightTimestamps;
                        synchronized (set) {
                            GenerationalCache.this._inflightTimestamps.remove(newVersion._timestamp);
                        }
                    }
                });
                return deltaResult;
            }
            catch (Throwable t) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)("Error occured creating delta with version " + version + " timestamp " + newVersion._timestamp + ". Returning the complete map"));
                }
                this._inflightTimestamps.remove(newVersion._timestamp);
                return new Update<K, V>(this._completeMap, newVersionStr, false);
            }
        }
    }

    private VersionInfo getVersionInfo(String version) {
        if (version == null) {
            return null;
        }
        String[] strs = version.split(":");
        if (strs.length != 3) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)(" Got invalid version " + version));
            }
            return null;
        }
        if (!this._id.equals(strs[0])) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)(" Got invalid id " + strs[0]));
            }
            return null;
        }
        try {
            return new VersionInfo(Long.parseLong(strs[1]), Long.parseLong(strs[2]));
        }
        catch (NumberFormatException e) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)(" Could not parse version " + version));
            }
            return null;
        }
    }

    public static class Update<K, V> {
        private final Map<K, V> _map;
        private final String _version;
        private final boolean _isDelta;

        public Update(Map<K, V> map, String version, boolean isDelta) {
            this._map = map;
            this._version = version;
            this._isDelta = isDelta;
        }

        public Map<K, V> getMap() {
            return this._map;
        }

        public String getVersion() {
            return this._version;
        }

        public boolean isDelta() {
            return this._isDelta;
        }

        public String toString() {
            return "Update [_isDelta=" + this._isDelta + ", _version=" + this._version + ", _map=" + this._map + "]";
        }
    }

    private static final class VersionInfo {
        long _timestamp;
        long _generation;

        public VersionInfo(long timestamp, long generation) {
            this._timestamp = timestamp;
            this._generation = generation;
        }
    }

    public static class ValueHolder<V> {
        final long _generation;
        final V _value;
        final long _version;
        final long _timestamp;

        public ValueHolder(long generation, V value, long version, long timestamp) {
            this._generation = generation;
            this._value = value;
            this._version = version;
            this._timestamp = timestamp;
        }
    }
}

