/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vmware.cis.core.util.CollectionsUtil;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class ImmutableUtils {
    private ImmutableUtils() {
        throw new AssertionError();
    }

    public static <F, T> Collection<T> tranformCollection(final Collection<F> col, TransformFunc<? super F, T> func) {
        final TranformedIterable<? super F, T> tranformedIterable = new TranformedIterable<F, T>(func, col);
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return tranformedIterable.iterator();
            }

            @Override
            public int size() {
                return col.size();
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }
        };
    }

    public static <K, V> Map<K, V> filteredMap(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        return new FilteredMap<K, V>(map, predicate);
    }

    public static <K, V> Map<K, V> concatMap(Map<K, V> map1, Map<K, V> map2) {
        return new ImmutableConcatedMap<K, V>(map1, map2);
    }

    public static <K, V> NavigableMap<K, V> mergeNavigableMap(NavigableMap<K, V> map1, NavigableMap<K, V> map2, Comparator<? super K> comparator) {
        return new MergedNavigableMap<K, V>(map1, map2, comparator);
    }

    public static <E> Set<E> concatSet(Set<E> set1, Set<E> set2) {
        return new ConcatSets<E>(set1, set2);
    }

    public static <K, V, E> Map<K, Collection<V>> buildMap(Collection<E> col, KeyValueFunc<K, V, E> func) {
        return new BuildMap<K, V, E>(func, col);
    }

    public static <FK, FV, K, V> Map<K, V> transformMap(Map<FK, FV> map, TransformEntryFunc<FK, FV, K, V> func) {
        return new TransformedMap<FK, K, FV, V>(func, map);
    }

    public static <K, FV, V> Map<K, V> transformValueMap(Map<K, FV> map, TransformMapValueFunc<FV, V> func) {
        return new TransformedValueMap<K, FV, V>(func, map);
    }

    public static <K, FV, V> NavigableMap<K, V> transformNavigableMap(NavigableMap<K, FV> map, TransformMapValueFunc<FV, V> func) {
        return new TransformedNavigableMap<K, FV, V>(func, map);
    }

    public static <K, V> Iterator<Map.Entry<K, V>> safeNonNullContentsIterator(final Iterator<? extends Map.Entry<K, V>> iter) {
        return new Iterator<Map.Entry<K, V>>(){
            Map.Entry<K, V> _next;
            {
                this.moveToNext();
            }

            @Override
            public boolean hasNext() {
                return this._next != null;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry result = this._next;
                this.moveToNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void moveToNext() {
                this._next = null;
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Object key = null;
                    Object value = null;
                    try {
                        key = entry.getKey();
                        value = entry.getValue();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (key == null || value == null) continue;
                    this._next = new ImmutableMapKey<Object, Object>(key, value);
                    break;
                }
            }
        };
    }

    public static <F, T> Iterator<T> transform(final Iterator<? extends F> delIter, final TransformFunc<? super F, T> fun) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return delIter.hasNext();
            }

            @Override
            public T next() {
                Object next = delIter.next();
                if (next == null) {
                    return null;
                }
                return fun.apply(next);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<T> iter, final Predicate<? super T> predicate) {
        return new Iterator<T>(){
            T _next;
            {
                this.moveToNext();
            }

            @Override
            public boolean hasNext() {
                return this._next != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this._next;
                this.moveToNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void moveToNext() {
                this._next = null;
                while (iter.hasNext()) {
                    Object temp = iter.next();
                    if (!predicate.apply(temp)) continue;
                    this._next = temp;
                    break;
                }
            }
        };
    }

    static class MergedNavigableMap<K, V>
    extends MergedSortedMap<K, V>
    implements NavigableMap<K, V> {
        private final NavigableMap<K, V> _map1;
        private final NavigableMap<K, V> _map2;
        private final Comparator<? super K> _descendingComparator;

        public MergedNavigableMap(NavigableMap<K, V> map1, NavigableMap<K, V> map2, Comparator<? super K> comparator) {
            super(map1, map2, comparator);
            this._map1 = map1;
            this._map2 = map2;
            this._descendingComparator = comparator != null ? new Comparator<K>(){

                @Override
                public int compare(K o1, K o2) {
                    return -1 * MergedNavigableMap.this._comparator.compare(o1, o2);
                }
            } : null;
        }

        protected Map.Entry<K, V> mergedEntry(Map.Entry<K, V> e1, Map.Entry<K, V> e2, boolean lower) {
            Map.Entry<K, V> result = this.selectFromFirst(e1 == null ? null : (Object)e1.getKey(), e2 == null ? null : (Object)e2.getKey(), lower) ? e1 : e2;
            return new ImmutableMapKey<K, V>(result.getKey(), result.getValue());
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return this.mergedEntry(this._map1.lowerEntry(key), this._map2.lowerEntry(key), false);
        }

        @Override
        public K lowerKey(K key) {
            return this.mergedKey(this._map1.lowerKey(key), this._map2.lowerKey(key), false);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return this.mergedEntry(this._map1.floorEntry(key), this._map2.floorEntry(key), false);
        }

        @Override
        public K floorKey(K key) {
            return this.mergedKey(this._map1.floorKey(key), this._map2.floorKey(key), false);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.mergedEntry(this._map1.ceilingEntry(key), this._map2.ceilingEntry(key), true);
        }

        @Override
        public K ceilingKey(K key) {
            return this.mergedKey(this._map1.ceilingKey(key), this._map2.ceilingKey(key), true);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return this.mergedEntry(this._map1.higherEntry(key), this._map2.higherEntry(key), true);
        }

        @Override
        public K higherKey(K key) {
            return this.mergedKey(this._map1.higherKey(key), this._map2.higherKey(key), true);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.mergedEntry(this._map1.firstEntry(), this._map2.firstEntry(), true);
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.mergedEntry(this._map1.lastEntry(), this._map2.lastEntry(), false);
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return new MergedNavigableMap<K, V>(this._map1.descendingMap(), this._map2.descendingMap(), this._descendingComparator);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new MergedNavigableSet<K>(this._map1.navigableKeySet(), this._map2.navigableKeySet(), this._comparator);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new MergedNavigableSet<K>(this._map1.descendingKeySet(), this._map2.descendingKeySet(), this._descendingComparator);
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return new MergedNavigableMap<K, V>(this._map1.subMap(fromKey, fromInclusive, toKey, toInclusive), this._map2.subMap(fromKey, fromInclusive, toKey, toInclusive), this._comparator);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            return new MergedNavigableMap<K, V>(this._map1.headMap(toKey, inclusive), this._map2.headMap(toKey, inclusive), this._comparator);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            return new MergedNavigableMap<K, V>(this._map1.tailMap(fromKey, inclusive), this._map2.tailMap(fromKey, inclusive), this._comparator);
        }
    }

    static class MergedSortedMap<K, V>
    extends AbstractMap<K, V>
    implements SortedMap<K, V> {
        private final SortedMap<K, V> _map1;
        private final SortedMap<K, V> _map2;
        protected final Comparator<? super K> _comparator;
        protected final Comparator<Map.Entry<K, V>> _entryComparator;
        private final Set<Map.Entry<K, V>> _entrySet;

        public MergedSortedMap(SortedMap<K, V> map1, SortedMap<K, V> map2, Comparator<? super K> comparator) {
            Preconditions.checkNotNull(map1);
            Preconditions.checkNotNull(map2);
            this._map1 = map1;
            this._map2 = map2;
            this._comparator = comparator;
            this._entryComparator = new Comparator<Map.Entry<K, V>>(){

                @Override
                public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                    int i;
                    if (MergedSortedMap.this._comparator == null) {
                        Comparable comparable = (Comparable)o1.getKey();
                        i = comparable.compareTo(o2.getKey());
                    } else {
                        i = MergedSortedMap.this._comparator.compare(o1.getKey(), o2.getKey());
                    }
                    return i;
                }
            };
            this._entrySet = new AbstractSet<Map.Entry<K, V>>(){
                Set<Map.Entry<K, V>> _set1;
                Set<Map.Entry<K, V>> _set2;
                {
                    this._set1 = MergedSortedMap.this._map1.entrySet();
                    this._set2 = MergedSortedMap.this._map2.entrySet();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final MergedIterator iter = new MergedIterator(this._set1.iterator(), this._set2.iterator(), MergedSortedMap.this._entryComparator);
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            final Map.Entry next = (Map.Entry)iter.next();
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return next.getKey();
                                }

                                @Override
                                public V getValue() {
                                    return next.getValue();
                                }

                                @Override
                                public V setValue(V value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    int i = 0;
                    for (Map.Entry o : this) {
                        ++i;
                    }
                    return i;
                }

                @Override
                public boolean isEmpty() {
                    return !this.iterator().hasNext();
                }

                @Override
                public boolean contains(Object o) {
                    return this._set1.contains(o) || this._set2.contains(o);
                }
            };
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this._entrySet;
        }

        @Override
        public boolean containsKey(Object key) {
            return this._map1.containsKey(key) || this._map2.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (this._map1.containsKey(key)) {
                return this._map1.get(key);
            }
            return this._map2.get(key);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this._comparator;
        }

        @Override
        public K firstKey() {
            return this.mergedKey(this._map1.firstKey(), this._map2.firstKey(), true);
        }

        @Override
        public K lastKey() {
            return this.mergedKey(this._map1.lastKey(), this._map2.lastKey(), false);
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new MergedSortedMap<K, V>(this._map1.subMap(fromKey, toKey), this._map2.subMap(fromKey, toKey), this._comparator);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new MergedSortedMap<K, V>(this._map1.headMap(toKey), this._map2.headMap(toKey), this._comparator);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new MergedSortedMap<K, V>(this._map1.tailMap(fromKey), this._map2.tailMap(fromKey), this._comparator);
        }

        protected K mergedKey(K e1, K e2, boolean lower) {
            if (this.selectFromFirst(e1, e2, lower)) {
                return e1;
            }
            return e2;
        }

        protected boolean selectFromFirst(K e1, K e2, boolean lower) {
            int i;
            if (e1 == null ^ e2 == null) {
                return e1 != null;
            }
            if (e1 == null) {
                return true;
            }
            if (this._comparator == null) {
                Comparable comparable = (Comparable)e1;
                i = comparable.compareTo(e2);
            } else {
                i = this._comparator.compare(e1, e2);
            }
            if (i == 0) {
                return true;
            }
            if (i < 0) {
                return lower;
            }
            return !lower;
        }

        @Override
        public boolean isEmpty() {
            return !this.entrySet().iterator().hasNext();
        }
    }

    static class MergedIterator<E>
    implements Iterator<E> {
        private final Iterator<E> _iter_1;
        private final Iterator<E> _iter_2;
        private E _next;
        private E _next1;
        private E _next2;
        private final Comparator<? super E> _comparator;

        MergedIterator(Iterator<E> iter1, Iterator<E> iter2) {
            this(iter1, iter2, null);
        }

        MergedIterator(Iterator<E> iter1, Iterator<E> iter2, Comparator<? super E> comparator) {
            Preconditions.checkNotNull(iter1);
            Preconditions.checkNotNull(iter2);
            this._iter_1 = iter1;
            this._iter_2 = iter2;
            this._comparator = comparator;
            if (this._iter_1.hasNext()) {
                this._next1 = iter1.next();
            }
            if (this._iter_2.hasNext()) {
                this._next2 = iter2.next();
            }
            this.setNext();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E result = this._next;
            this.setNext();
            return result;
        }

        private void setNext() {
            int i;
            if (this._next1 == null ^ this._next2 == null) {
                if (this._next1 != null) {
                    this.move_iter_1_and_set();
                } else {
                    this.move_iter_2_and_set();
                }
                return;
            }
            if (this._next1 == null) {
                this._next = null;
                return;
            }
            if (this._comparator == null) {
                Comparable comparable = (Comparable)this._next1;
                i = comparable.compareTo(this._next2);
            } else {
                i = this._comparator.compare(this._next1, this._next2);
            }
            if (i < 0) {
                this.move_iter_1_and_set();
                return;
            }
            if (i > 0) {
                this.move_iter_2_and_set();
                return;
            }
            this.move_iter_2_and_set();
            this.move_iter_1_and_set();
        }

        private void move_iter_1_and_set() {
            this._next = this._next1;
            this._next1 = this._iter_1.hasNext() ? this._iter_1.next() : null;
        }

        private void move_iter_2_and_set() {
            this._next = this._next2;
            this._next2 = this._iter_2.hasNext() ? this._iter_2.next() : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class MergedNavigableSet<E>
    extends MergedSortedSet<E>
    implements NavigableSet<E> {
        private final NavigableSet<E> _set_1;
        private final NavigableSet<E> _set_2;

        public MergedNavigableSet(NavigableSet<E> set_1, NavigableSet<E> set_2, Comparator<? super E> comparator) {
            super(set_1, set_2, comparator);
            this._set_1 = set_1;
            this._set_2 = set_2;
        }

        @Override
        public E lower(E e) {
            return this.mergedResult(this._set_1.lower(e), this._set_2.lower(e), false);
        }

        @Override
        public E floor(E e) {
            return this.mergedResult(this._set_1.floor(e), this._set_2.floor(e), false);
        }

        @Override
        public E ceiling(E e) {
            return this.mergedResult(this._set_1.ceiling(e), this._set_2.ceiling(e), true);
        }

        @Override
        public E higher(E e) {
            return this.mergedResult(this._set_1.ceiling(e), this._set_2.ceiling(e), true);
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new MergedNavigableSet<E>(this._set_1.descendingSet(), this._set_2.descendingSet(), this._descendingComparator);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new MergedNavigableSet<E>(this._set_1.subSet(fromElement, fromInclusive, toElement, toInclusive), this._set_2.subSet(fromElement, fromInclusive, toElement, toInclusive), this._comparator);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new MergedNavigableSet<E>(this._set_1.headSet(toElement, inclusive), this._set_2.headSet(toElement, inclusive), this._comparator);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new MergedNavigableSet<E>(this._set_1.tailSet(fromElement, inclusive), this._set_2.tailSet(fromElement, inclusive), this._comparator);
        }
    }

    static class MergedSortedSet<E>
    extends AbstractSet<E>
    implements SortedSet<E> {
        private final SortedSet<E> _set_1;
        private final SortedSet<E> _set_2;
        protected final Comparator<? super E> _comparator;
        protected final Comparator<? super E> _descendingComparator;

        public MergedSortedSet(SortedSet<E> set_1, SortedSet<E> set_2, Comparator<? super E> comparator) {
            this._set_1 = set_1;
            this._set_2 = set_2;
            this._comparator = comparator;
            this._descendingComparator = comparator == null ? null : new Comparator<E>(){

                @Override
                public int compare(E o1, E o2) {
                    return -1 * MergedSortedSet.this._comparator.compare(o1, o2);
                }
            };
        }

        protected E mergedResult(E e1, E e2, boolean lower) {
            int i;
            if (e1 == null ^ e2 == null) {
                if (e1 != null) {
                    return e1;
                }
                return e2;
            }
            if (e1 == null) {
                return null;
            }
            if (this._comparator == null) {
                Comparable comparable = (Comparable)e1;
                i = comparable.compareTo(e2);
            } else {
                i = this._comparator.compare(e1, e2);
            }
            if (i == 0) {
                return e1;
            }
            if (i < 0) {
                if (lower) {
                    return e1;
                }
                return e2;
            }
            if (lower) {
                return e2;
            }
            return e1;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this._comparator;
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new MergedSortedSet<E>(this._set_1.subSet(fromElement, toElement), this._set_2.subSet(fromElement, toElement), this._comparator);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new MergedSortedSet<E>(this._set_1.headSet(toElement), this._set_2.headSet(toElement), this._comparator);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new MergedSortedSet<E>(this._set_1.tailSet(fromElement), this._set_2.tailSet(fromElement), this._comparator);
        }

        @Override
        public E first() {
            return this.mergedResult(this._set_1.first(), this._set_2.first(), true);
        }

        @Override
        public E last() {
            return this.mergedResult(this._set_1.last(), this._set_2.last(), false);
        }

        @Override
        public Iterator<E> iterator() {
            return new MergedIterator<E>(this._set_1.iterator(), this._set_2.iterator(), this._comparator);
        }

        @Override
        public int size() {
            int i = 0;
            for (E e : this) {
                ++i;
            }
            return i;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }
    }

    static class TransformedNavigableMap<K, FV, V>
    extends TransformedSortedMap<K, FV, V>
    implements NavigableMap<K, V> {
        private final NavigableMap<K, FV> _map;

        public TransformedNavigableMap(TransformMapValueFunc<FV, V> transFunc, NavigableMap<K, FV> map) {
            super(transFunc, map);
            this._map = map;
        }

        protected Map.Entry<K, V> transformEntry(Map.Entry<K, FV> entry) {
            if (entry == null) {
                return null;
            }
            return Maps.immutableEntry(entry.getKey(), this._transFunc.to(entry.getKey(), entry.getValue()));
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return this.transformEntry(this._map.lowerEntry(key));
        }

        @Override
        public K lowerKey(K key) {
            return this._map.lowerKey(key);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return this.transformEntry(this._map.floorEntry(key));
        }

        @Override
        public K floorKey(K key) {
            return this._map.floorKey(key);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.transformEntry(this._map.ceilingEntry(key));
        }

        @Override
        public K ceilingKey(K key) {
            return this._map.ceilingKey(key);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return this.transformEntry(this._map.higherEntry(key));
        }

        @Override
        public K higherKey(K key) {
            return this._map.higherKey(key);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.transformEntry(this._map.firstEntry());
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.transformEntry(this._map.lastEntry());
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return new TransformedNavigableMap<K, FV, V>(this._transFunc, this._map.descendingMap());
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this._map.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this._map.descendingKeySet();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return new TransformedNavigableMap<K, FV, V>(this._transFunc, this._map.subMap(fromKey, fromInclusive, toKey, toInclusive));
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            return new TransformedNavigableMap<K, FV, V>(this._transFunc, this._map.headMap(toKey, inclusive));
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            return new TransformedNavigableMap<K, FV, V>(this._transFunc, this._map.tailMap(fromKey, inclusive));
        }
    }

    static class TransformedSortedMap<K, FV, V>
    extends TransformedValueMap<K, FV, V>
    implements SortedMap<K, V> {
        private final SortedMap<K, FV> _map;
        protected final TransformMapValueFunc<FV, V> _transFunc;

        public TransformedSortedMap(TransformMapValueFunc<FV, V> transFunc, SortedMap<K, FV> map) {
            super(transFunc, map);
            this._transFunc = transFunc;
            this._map = map;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this._map.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new TransformedSortedMap<K, FV, V>(this._transFunc, this._map.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new TransformedSortedMap<K, FV, V>(this._transFunc, this._map.headMap(toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new TransformedSortedMap<K, FV, V>(this._transFunc, this._map.tailMap(fromKey));
        }

        @Override
        public K firstKey() {
            return this._map.firstKey();
        }

        @Override
        public K lastKey() {
            return this._map.lastKey();
        }
    }

    static class TransformedValueMap<K, FV, V>
    extends TransformedMap<K, K, FV, V> {
        public TransformedValueMap(final TransformMapValueFunc<FV, V> transFunc, Map<K, FV> map) {
            super(new TransformEntryFunc<K, FV, K, V>(){

                @Override
                public Map.Entry<K, V> to(Object key, Object value) {
                    Object tranformedKey = this.getKey(key);
                    Object transformedValue = null;
                    if (value != null) {
                        try {
                            Object fv = value;
                            transformedValue = transFunc.to(tranformedKey, fv);
                        }
                        catch (ClassCastException ex) {
                            // empty catch block
                        }
                    }
                    return new ImmutableMapKey(tranformedKey, transformedValue);
                }

                @Override
                public Map.Entry<K, FV> from(Object key, Object value) {
                    Object tranformedKey = this.getKey(key);
                    Object transformedValue = null;
                    if (value != null) {
                        try {
                            Object v = value;
                            transformedValue = transFunc.from(tranformedKey, v);
                        }
                        catch (ClassCastException ex) {
                            // empty catch block
                        }
                    }
                    return new ImmutableMapKey(tranformedKey, transformedValue);
                }

                private K getKey(Object key) {
                    if (key == null) {
                        return null;
                    }
                    try {
                        return key;
                    }
                    catch (ClassCastException classCastException) {
                        return null;
                    }
                }
            }, map);
        }
    }

    static class BuildMap<K, V, E>
    extends AbstractMap<K, Collection<V>> {
        private final KeyValueFunc<K, V, E> _func;
        private final Collection<E> _col;

        public BuildMap(KeyValueFunc<K, V, E> func, Collection<E> col) {
            Preconditions.checkNotNull(func);
            Preconditions.checkNotNull(col);
            CollectionsUtil.checkForContentsNotNull(col);
            this._func = func;
            this._col = col;
        }

        @Override
        public boolean containsKey(Object o) {
            for (E e : this._col) {
                if (!this._func.getKey(e).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<V> get(Object o) {
            ArrayList<V> result = new ArrayList<V>();
            for (E e : this._col) {
                if (!this._func.getKey(e).equals(o)) continue;
                result.add(this._func.getValue(e));
            }
            return result.isEmpty() ? null : result;
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            HashMap<K, ArrayList<V>> map = new HashMap<K, ArrayList<V>>();
            for (E e : this._col) {
                K key = this._func.getKey(e);
                V value = this._func.getValue(e);
                ArrayList<V> l = (ArrayList<V>)map.get(key);
                if (l == null) {
                    l = new ArrayList<V>();
                    map.put(key, l);
                }
                l.add(value);
            }
            return Collections.unmodifiableMap(map).entrySet();
        }
    }

    static class TransformedMap<FK, K, FV, V>
    extends AbstractMap<K, V> {
        private final TransformEntryFunc<FK, FV, K, V> _transFunc;
        private final Set<Map.Entry<K, V>> _entrySet;
        private final Map<FK, FV> _map;

        public TransformedMap(TransformEntryFunc<FK, FV, K, V> transFunc, Map<FK, FV> map) {
            Preconditions.checkNotNull(transFunc);
            Preconditions.checkNotNull(map);
            this._transFunc = transFunc;
            this._map = map;
            this._entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        Iterator<Map.Entry<FK, FV>> _iter;
                        Map.Entry<K, V> _next;
                        {
                            this._iter = TransformedMap.this._map.entrySet().iterator();
                            this.setNext();
                        }

                        @Override
                        public boolean hasNext() {
                            return this._next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this._next == null) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry result = this._next;
                            this.setNext();
                            return result;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private void setNext() {
                            block0: {
                                this._next = null;
                                if (!this._iter.hasNext()) break block0;
                                Map.Entry next = this._iter.next();
                                this._next = TransformedMap.this.transformedToEntry(next.getKey(), next.getValue());
                            }
                        }
                    };
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Map.Entry entry = TransformedMap.this.transformedFromEntry(e.getKey(), e.getValue());
                    Object value = TransformedMap.this._map.get(entry.getKey());
                    if (value == null) {
                        return entry.getValue() == null;
                    }
                    return value.equals(entry.getValue());
                }

                @Override
                public int size() {
                    return TransformedMap.this._map.size();
                }
            };
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this._entrySet;
        }

        @Override
        public boolean containsKey(Object o) {
            Map.Entry<FK, FV> e = this.transformedFromEntry(o, null);
            return this._map.containsKey(e.getKey());
        }

        @Override
        public V get(Object o) {
            Map.Entry<FK, FV> e = this.transformedFromEntry(o, null);
            FV value = this._map.get(e.getKey());
            if (value == null) {
                return null;
            }
            Map.Entry<K, V> result = this.transformedToEntry(e.getKey(), value);
            return result.getValue();
        }

        private Map.Entry<K, V> transformedToEntry(Object key, Object value) {
            return this._transFunc.to(key, value);
        }

        private Map.Entry<FK, FV> transformedFromEntry(Object key, Object value) {
            return this._transFunc.from(key, value);
        }
    }

    public static interface KeyValueFunc<K, V, E> {
        public K getKey(E var1);

        public V getValue(E var1);
    }

    public static interface TransformMapValueFunc<F, T> {
        public T to(Object var1, F var2);

        public F from(Object var1, T var2);
    }

    public static interface TransformEntryFunc<FK, FV, K, V> {
        public Map.Entry<K, V> to(Object var1, Object var2);

        public Map.Entry<FK, FV> from(Object var1, Object var2);
    }

    public static interface TransformFunc<F, T> {
        public T apply(F var1);
    }

    static class ImmutableConcatedMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> _map1;
        private final Map<K, V> _map2;
        private final Set<Map.Entry<K, V>> _entrySet;

        public ImmutableConcatedMap(final Map<K, V> map1, Map<K, V> map2) {
            if (map1 == null || map2 == null) {
                throw new NullPointerException();
            }
            Predicate<Object> notInMap1 = new Predicate<Object>(){

                public boolean apply(Object element) {
                    if (!(element instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)element;
                    return !map1.containsKey(e.getKey());
                }
            };
            this._entrySet = new ConcatSets<Map.Entry<K, V>>(map1.entrySet(), map2.entrySet(), notInMap1);
            this._map1 = map1;
            this._map2 = map2;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this._entrySet;
        }

        @Override
        public boolean containsKey(Object key) {
            return this._map1.containsKey(key) || this._map2.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (this._map1.containsKey(key)) {
                return this._map1.get(key);
            }
            return this._map2.get(key);
        }

        @Override
        public boolean isEmpty() {
            return !this.entrySet().iterator().hasNext();
        }
    }

    static class ConcatSets<T>
    extends AbstractSet<T> {
        final Set<T> _set1;
        final Set<T> _set2;

        ConcatSets(final Set<T> set1, Set<T> set2) {
            this(set1, set2, new Predicate<Object>(){

                public boolean apply(Object element) {
                    return !set1.contains(element);
                }
            });
        }

        ConcatSets(Set<T> set1, Set<T> set2, Predicate<Object> predicate) {
            this._set1 = set1;
            this._set2 = Sets.filter(set2, predicate);
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator iterator = Iterators.concat(this._set1.iterator(), this._set2.iterator());
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public T next() {
                    return iterator.next();
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this._set1.size() + this._set2.size() - Sets.intersection(this._set1, this._set2).size();
        }

        @Override
        public boolean contains(Object o) {
            return this._set1.contains(o) || this._set2.contains(o);
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }
    }

    public static class ImmutableMapKey<K, V>
    implements Map.Entry<K, V> {
        private final K _key;
        private final V _value;

        public ImmutableMapKey(K key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    static class FilteredMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> _del;
        private final Set<Map.Entry<K, V>> _entrySet;
        private final Predicate<Map.Entry<?, ?>> _predicate;

        public FilteredMap(Map<K, V> del, final Predicate<Map.Entry<K, V>> predicate) {
            this._del = del;
            this._predicate = new Predicate<Map.Entry<?, ?>>(){

                public boolean apply(Map.Entry<?, ?> e) {
                    if (e == null) {
                        return false;
                    }
                    try {
                        Object key = e.getKey();
                        Object value = e.getValue();
                        return predicate.apply(new ImmutableMapKey(key, value));
                    }
                    catch (ClassCastException classCastException) {
                        return false;
                    }
                }
            };
            this._entrySet = Collections.unmodifiableSet(Sets.filter(this._del.entrySet(), this._predicate));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this._entrySet;
        }

        @Override
        public V get(Object key) {
            V value = this._del.get(key);
            return (V)(this._predicate.apply(new ImmutableMapKey<Object, V>(key, value)) ? value : null);
        }

        @Override
        public boolean containsKey(Object key) {
            V value = this._del.get(key);
            return this._predicate.apply(new ImmutableMapKey<Object, V>(key, value));
        }
    }

    static class TranformedIterable<F, T>
    implements Iterable<T> {
        private final Iterable<F> _del;
        private final TransformFunc<? super F, T> _fun;

        TranformedIterable(TransformFunc<? super F, T> fun, Iterable<F> del) {
            this._fun = fun;
            this._del = del;
        }

        @Override
        public Iterator<T> iterator() {
            Iterator<F> delIter = this._del.iterator();
            return ImmutableUtils.transform(delIter, this._fun);
        }
    }
}

