/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import java.util.concurrent.Callable;

public final class TaskWrapper {
    private TaskWrapper() {
        throw new AssertionError();
    }

    public static <T> T retryOnce(Callable<T> cmd, RecoverFunction function) throws Exception {
        return TaskWrapper.retry(cmd, function, 1);
    }

    public static <T> T retry(Callable<T> cmd, RecoverFunction function, int retries) throws Exception {
        int retrtCount = 0;
        while (true) {
            try {
                return cmd.call();
            }
            catch (Exception e) {
                if (retrtCount++ != retries) continue;
                throw e;
                if (function.recover(e)) continue;
                throw e;
            }
            break;
        }
    }

    public static interface RecoverFunction {
        public boolean recover(Exception var1);
    }
}

