/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core;

import com.vmware.vim.query.core.Principal;
import com.vmware.vim.query.core.util.NormalizedPrincipalHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPrincipal
implements Principal {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected String _name;
    protected boolean _isGroup;
    protected int _hash;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isGroup() {
        return this._isGroup;
    }

    public AbstractPrincipal(String name, boolean isGroup) {
        this._name = NormalizedPrincipalHelper.getNormalizedPrincipal(name);
        this._isGroup = isGroup;
        this._hash = (this._isGroup ? 1 : 0) + this._name.toLowerCase().hashCode();
    }

    public int hashCode() {
        return this._hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractPrincipal)) {
            return false;
        }
        AbstractPrincipal other = (AbstractPrincipal)obj;
        if (this._isGroup != other._isGroup) {
            return false;
        }
        return this._name.equalsIgnoreCase(other._name);
    }

    @Override
    public boolean matches(Principal other) {
        if (this.equals(other)) {
            return true;
        }
        if (other.isGroup()) {
            return this.isMemberOfGroup(other);
        }
        return false;
    }

    protected abstract boolean isMemberOfGroup(Principal var1);
}

