/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MonitorReference {
    private static final Log _log = LogFactory.getLog(MonitorReference.class);
    private static final ReferenceQueue<Object> _queue = new ReferenceQueue();
    private static final Set<RefExt> _set = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    private MonitorReference() {
    }

    public static void watch(Object t, CleanupFunc function) {
        if (t == null) {
            throw new NullPointerException();
        }
        _set.add(new RefExt(t, _queue, function));
    }

    static {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    Reference ref;
                    try {
                        ref = _queue.remove();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    if (!(ref instanceof RefExt)) {
                        _log.warn((Object)("This should never happen. Serious error not a valid ref " + ref));
                        continue;
                    }
                    try {
                        ((RefExt)ref)._cleanupFunc.cleanup();
                    }
                    catch (Throwable t) {
                        _log.warn((Object)("Cleanup call failed for reference " + ref), t);
                    }
                    _set.remove(ref);
                }
            }
        }, "MonitorReference-Cleanup-Thread");
        th.setDaemon(true);
        th.start();
    }

    private static class RefExt
    extends PhantomReference<Object> {
        private final CleanupFunc _cleanupFunc;

        public RefExt(Object referent, ReferenceQueue<? super Object> queue, CleanupFunc cleanupFunc) {
            super(referent, queue);
            this._cleanupFunc = cleanupFunc;
        }
    }

    public static interface CleanupFunc {
        public void cleanup();
    }
}

