/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import com.google.common.base.Preconditions;

public class NormalizedPrincipalHelper {
    public static String getNormalizedPrincipal(String principalName) {
        Preconditions.checkArgument((principalName != null ? 1 : 0) != 0, (Object)"null value not allowed");
        Preconditions.checkArgument((!principalName.trim().isEmpty() ? 1 : 0) != 0, (Object)"Empty principal name not allowed");
        Preconditions.checkArgument((boolean)NormalizedPrincipalHelper.isValidPrincipalName(principalName), (String)"Invalid principal name %s", (Object[])new Object[]{principalName});
        String[] split = principalName.split("\\\\");
        if (split.length == 2) {
            return split[0].trim().toUpperCase() + "\\" + split[1].trim();
        }
        split = principalName.split("@");
        if (split.length == 2) {
            return split[1].trim().toUpperCase() + "\\" + split[0].trim();
        }
        return principalName.trim();
    }

    private static boolean isValidPrincipalName(String name) {
        String[] split = name.split("\\\\");
        if (split.length > 2) {
            return false;
        }
        if (split.length == 2) {
            return true;
        }
        split = name.split("@");
        return split.length <= 2;
    }
}

