/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal;

import com.vmware.cis.license.common.misc.GZipUtil;
import com.vmware.license.myvmware.client.sync.internal.impl.MyVMwareSyncManagerImpl;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.LicenseInventoryReportParseException;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.management.InactiveLicensesReport;
import com.vmware.vim.binding.cis.license.management.MyVMwareLicenseReport;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareLicenseReportImpl;
import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.vmodl.Binary;
import java.io.IOException;
import java.util.Map;

public class LicenseReportUtil {
    private static final boolean DEFAULT_SHOULD_COMPRESS_REPORT = true;
    private static final boolean DEFAULT_SHOULD_DECOMPRESS_INACTIVE_REPORT = true;

    public static MyVMwareLicenseReport buildMyVMwareLicenseReport(byte[] reportByteArray) throws IOException {
        return LicenseReportUtil.buildMyVMwareLicenseReport(reportByteArray, true);
    }

    public static MyVMwareLicenseReport buildMyVMwareLicenseReport(byte[] reportByteArray, boolean shouldCompressReport) throws IOException {
        if (shouldCompressReport) {
            reportByteArray = GZipUtil.compressData((byte[])reportByteArray);
        }
        return new MyVMwareLicenseReportImpl((Binary)new BinaryImpl(reportByteArray));
    }

    public static byte[] getInactiveLicensesReportContent(InactiveLicensesReport inactiveLicensesReport) throws IOException {
        return LicenseReportUtil.getInactiveLicensesReportContent(inactiveLicensesReport, true);
    }

    public static byte[] getInactiveLicensesReportContent(InactiveLicensesReport inactiveLicensesReport, boolean shouldDecompress) throws IOException {
        byte[] result = inactiveLicensesReport.getData().asArray();
        if (shouldDecompress) {
            result = GZipUtil.decompressData((byte[])result);
        }
        return result;
    }

    public static Map<String, License> findInactiveInventoryLicenses(byte[] myVMwareLicenseReportData, License[] inventoryLicenses) throws LicenseInventoryReportParseException {
        MyVMwareSyncManagerImpl myVMwareSyncManager = new MyVMwareSyncManagerImpl(false, false);
        return myVMwareSyncManager.findInactiveInventoryLicenses(myVMwareLicenseReportData, inventoryLicenses);
    }
}

