/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.inventoryreport.impl;

import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.ReportReader;
import com.vmware.license.myvmware.client.sync.internal.ReportReaderFactory;
import com.vmware.license.myvmware.client.sync.internal.impl.LicenseKeyDetailsBuilderImpl;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.LicenseInventoryReportParseException;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.LicenseInventoryReportParseResult;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.LicenseInventoryReportParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.zip.GZIPInputStream;

public class LicenseInventoryReportParserImpl
implements LicenseInventoryReportParser {
    private final ReportReaderFactory _reportReaderFactory;

    public LicenseInventoryReportParserImpl(ReportReaderFactory reportReaderFactory) {
        this._reportReaderFactory = reportReaderFactory;
    }

    @Override
    public LicenseInventoryReportParseResult parseCsvReport(byte[] csvReportByteArray, boolean isCompressed) throws LicenseInventoryReportParseException {
        ReportReader reportReader = null;
        String parseCsvErrorMessage = "An error occurred during the report parsing";
        try {
            InputStream inputStream = new ByteArrayInputStream(csvReportByteArray);
            if (isCompressed) {
                inputStream = new GZIPInputStream(inputStream);
            }
            reportReader = this._reportReaderFactory.getReportReader(inputStream);
            String reportVersion = reportReader.getReportVersion();
            LicenseInventoryReportParseResult licenseInventoryReportParseResult = this.parseReportInt(reportReader, reportVersion);
            return licenseInventoryReportParseResult;
        }
        catch (IOException e) {
            throw new LicenseInventoryReportParseException("An error occurred during the report parsing", e);
        }
        catch (RuntimeException e) {
            throw new LicenseInventoryReportParseException("An error occurred during the report parsing", e);
        }
        finally {
            if (reportReader != null) {
                reportReader.close();
            }
        }
    }

    private LicenseInventoryReportParseResult parseReportInt(ReportReader reportReader, String reportVersion) {
        LicenseKeyDetailsBuilderImpl builder = new LicenseKeyDetailsBuilderImpl(reportVersion);
        while (reportReader.hasNext()) {
            String[] items = reportReader.next();
            builder.build(items);
        }
        Collection<LicenseKeyDetails> licenseKeysDetails = builder.getResult();
        LicenseInventoryReportParseResult licenseInventoryReportParseResult = new LicenseInventoryReportParseResult(licenseKeysDetails.toArray(new LicenseKeyDetails[licenseKeysDetails.size()]), builder.getResultCode());
        return licenseInventoryReportParseResult;
    }
}

