/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.common.impl;

import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.server.common.BindingInfo;
import com.vmware.vim.vmomi.server.common.Request;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestImpl
implements Request {
    protected static AtomicInteger sNextCorrelationId = new AtomicInteger();
    protected String _correlator;
    private String _contentType;
    private String _soapAction;
    private String _requestUri;
    private String _sessionCookie;
    private String _sessionCookiePath;
    private CharSequence _requestBody;
    private BindingInfo _bindingInfo;
    private RequestContext _requestContext;
    private Map<String, Object> _objectMap = new HashMap<String, Object>();

    public RequestImpl() {
        this._correlator = Integer.toString(sNextCorrelationId.getAndIncrement());
    }

    public RequestImpl(String correlator) {
        this._correlator = correlator;
    }

    @Override
    public BindingInfo getBindingInfo() {
        return this._bindingInfo;
    }

    @Override
    public String getCorrelator() {
        return this._correlator;
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public String getSoapAction() {
        return this._soapAction;
    }

    @Override
    public String getRequestUri() {
        return this._requestUri;
    }

    @Override
    public String getSessionCookie() {
        return this._sessionCookie;
    }

    @Override
    public String getSessionCookiePath() {
        return this._sessionCookiePath;
    }

    @Override
    public CharSequence getRequestBody() {
        return this._requestBody;
    }

    @Override
    public void setCorrelator(String correlator) {
        this._correlator = correlator;
    }

    @Override
    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    @Override
    public void setSoapAction(String soapAction) {
        this._soapAction = soapAction;
    }

    @Override
    public void setRequestUri(String requestUri) {
        this._requestUri = requestUri;
    }

    @Override
    public void setSessionCookie(String sessionCookie) {
        this._sessionCookie = sessionCookie;
    }

    @Override
    public void setSessionCookiePath(String sessionCookiePath) {
        this._sessionCookiePath = sessionCookiePath;
    }

    @Override
    public void setRequestBody(CharSequence requestBody) {
        this._requestBody = requestBody;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this._bindingInfo = bindingInfo;
    }

    @Override
    public RequestContext getRequestContext() {
        return this._requestContext;
    }

    @Override
    public void setRequestContext(RequestContext context) {
        if (null != this._requestContext) {
            throw new IllegalStateException("Request context already initialized");
        }
        this._requestContext = context;
    }

    @Override
    public synchronized Object getRequestObject(String key) {
        return this._objectMap.get(key);
    }

    @Override
    public synchronized void putRequestObject(String key, Object object) {
        this._objectMap.put(key, object);
    }
}

