/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.server.http.Endpoint;

public class HttpEndpoint
implements Endpoint {
    protected String _host;
    protected int _port;
    protected Endpoint.Protocol _protocol;
    protected int _numAcceptors;
    protected int _acceptQueueSize;
    protected int _maxIdleTime;
    protected int _maxKeepAliveRequests;
    protected int _maxHttpHeaderSize;
    protected Endpoint.EndpointType _type = Endpoint.EndpointType.BLOCKING;

    public HttpEndpoint(String host, int port, Endpoint.Protocol protocol) {
        this._host = host;
        this._port = port;
        this._protocol = protocol;
        this._numAcceptors = 2;
        this._acceptQueueSize = 200;
        this._maxIdleTime = 200000;
        this._maxKeepAliveRequests = 100;
    }

    public HttpEndpoint(int port) {
        this("0.0.0.0", port, Endpoint.Protocol.HTTP);
    }

    public HttpEndpoint(String host, int port) {
        this(host, port, Endpoint.Protocol.HTTP);
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public Endpoint.Protocol getProtocol() {
        return this._protocol;
    }

    public String toString() {
        return String.format("%s:%s:%d, maxIdleTime: %d ms, maxKeepAliveRequests: %d", this._protocol != null ? this._protocol.toString() : null, this._host, this._port, this._maxIdleTime, this._maxKeepAliveRequests);
    }

    @Override
    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    @Override
    public int getNumAcceptors() {
        return this._numAcceptors;
    }

    @Override
    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    @Override
    public void setNumAcceptors(int acceptors) {
        this._numAcceptors = acceptors;
    }

    @Override
    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    @Override
    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    @Override
    public int getMaxKeepAliveRequests() {
        return this._maxKeepAliveRequests;
    }

    @Override
    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this._maxKeepAliveRequests = maxKeepAliveRequests;
    }

    @Override
    public int getMaxHttpHeaderSize() {
        return this._maxHttpHeaderSize;
    }

    @Override
    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this._maxHttpHeaderSize = maxHttpHeaderSize;
    }

    @Override
    public Endpoint.EndpointType getEndpointType() {
        return this._type;
    }

    @Override
    public void setEndpointType(Endpoint.EndpointType type) {
        this._type = type;
    }
}

