/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ServerFuture;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.util.DataObjectLoggerUtil;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ActivationQueueCompletion
implements ServerFuture {
    private static final Log _logger = LogFactory.getLog(ActivationQueueCompletion.class);
    private Activation _activation;
    private ProcessingStep<Activation> _nextStep;
    private boolean _done;

    ActivationQueueCompletion(Activation activation, ProcessingStep<Activation> nextStep) {
        this._activation = activation;
        this._nextStep = nextStep;
        this._done = false;
    }

    public synchronized void set(Object ret) {
        this.assertNotCompleted();
        if (_logger.isTraceEnabled()) {
            Method method = this._activation.getMethod().getMethod();
            StringBuilder buffer = new StringBuilder();
            DataObjectLoggerUtil.formatField(buffer, this._activation.getMethod().getResult(), ret);
            _logger.trace((Object)String.format("(%4$s) Setting result for %1$s.%2$s [MORef %5$s] with return value:\n%3$s", method.getDeclaringClass().getName(), method.getName(), buffer, this._activation.getRequest().getCorrelator(), this._activation.getTarget()._getRef().getValue()));
        } else if (_logger.isDebugEnabled()) {
            Method method = this._activation.getMethod().getMethod();
            _logger.debug((Object)String.format("Result for %1$s.%2$s is success", method.getDeclaringClass().getName(), method.getName()));
        }
        this._activation.setReturnValue(ret);
        this._done = true;
        this._nextStep.process(this._activation);
    }

    public synchronized void set() {
        this.set(null);
    }

    public synchronized void setException(Exception fault) {
        this.assertNotCompleted();
        if (_logger.isTraceEnabled()) {
            Method method = this._activation.getMethod().getMethod();
            _logger.trace((Object)String.format("(%4$s) Setting result for %1$s.%2$s [MORef %5$s] with fault %3$s", method.getDeclaringClass().getName(), method.getName(), fault, this._activation.getRequest().getCorrelator(), this._activation.getTarget()._getRef().getValue()));
        } else if (_logger.isDebugEnabled()) {
            Method method = this._activation.getMethod().getMethod();
            _logger.debug((Object)String.format("Result for %1$s.%2$s is %3$s", method.getDeclaringClass().getName(), method.getName(), fault.getClass().getName()));
        }
        this._activation.setFault(fault);
        this._done = true;
        this._nextStep.process(this._activation);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public Object get() {
        throw new UnsupportedOperationException();
    }

    public Object get(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public boolean isCancelled() {
        return false;
    }

    public synchronized boolean isDone() {
        return this._done;
    }

    @Override
    public Activation getActivation() {
        return this._activation;
    }

    private void assertNotCompleted() {
        if (this._done) {
            throw new IllegalStateException("Future result already set!");
        }
    }
}

