/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.impl.XMLFactories;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.util.CharSequenceReader;
import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.BodyHandler;
import com.vmware.vim.vmomi.server.DeserializedRequest;
import com.vmware.vim.vmomi.server.Dispatcher;
import com.vmware.vim.vmomi.server.common.ChainedProcessingStep;
import com.vmware.vim.vmomi.server.common.Request;
import com.vmware.vim.vmomi.server.common.Response;
import com.vmware.vim.vmomi.server.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.server.exception.ServiceUnavailableException;
import com.vmware.vim.vmomi.server.exception.UnsupportedVersionException;
import com.vmware.vim.vmomi.server.impl.DispatchErrorActivationImpl;
import com.vmware.vim.vmomi.server.impl.unmarshaller.EnvelopeStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.RequestUnmarshaller;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionManager;
import com.vmware.vim.vmomi.server.util.DiagnosticContextUtils;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DispatcherImpl
implements Dispatcher {
    private final Log _logger = LogFactory.getLog(this.getClass());
    private final HashMap<String, BodyHandler> _versionUriHandlers = new HashMap();
    private final HashMap<String, BodyHandler> _defaultVersionUriHandlers = new HashMap();
    private final HashMap<String, BodyHandler> _namespaceHandlers = new HashMap();
    private final SessionManager _sessionManager;

    public DispatcherImpl(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    @Override
    public void addVersionUriHandler(String versionUri, BodyHandler handler) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)String.format("Adding handler for version URI %1$s", versionUri));
        }
        this._versionUriHandlers.put(versionUri, handler);
    }

    @Override
    public void addDefaultVersionUriHandler(String versionUri, BodyHandler handler) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)String.format("Adding default handler for version URI %1$s", versionUri));
        }
        this._defaultVersionUriHandlers.put(versionUri, handler);
    }

    @Override
    public void addNamespaceHandler(String namespace, BodyHandler handler) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)String.format("Adding handler for namespace %1$s", namespace));
        }
        this._namespaceHandlers.put(namespace, handler);
    }

    @Override
    public void addBodyHandler(BodyHandler handler) {
        if (handler.getSupportedVersionUri() != null) {
            this.addVersionUriHandler(handler.getSupportedVersionUri(), handler);
        } else {
            this.addNamespaceHandler(handler.getSupportedNamespace(), handler);
        }
    }

    public void setVersionUriHandlers(List<BodyHandler> handlers) {
        for (BodyHandler handler : handlers) {
            this.addVersionUriHandler(handler.getSupportedVersionUri(), handler);
        }
    }

    public void setDefaultVersionUriHandlers(List<BodyHandler> handlers) {
        for (BodyHandler handler : handlers) {
            this.addDefaultVersionUriHandler(handler.getSupportedNamespace(), handler);
        }
    }

    public void setNamespaceHandlers(List<BodyHandler> handlers) {
        for (BodyHandler handler : handlers) {
            this.addNamespaceHandler(handler.getSupportedNamespace(), handler);
        }
    }

    @Override
    public BodyHandler findBodyHandler(String envelopeVersion, String soapAction, String methodNamespace) throws UnsupportedVersionException {
        BodyHandler handler = null;
        if (envelopeVersion != null) {
            handler = this._versionUriHandlers.get(envelopeVersion);
            if (null == handler) {
                throw new UnsupportedVersionException(String.format("Request envelope version '%1$s' is not supported", envelopeVersion));
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)String.format("Found handler for envelope version '%1$s'", envelopeVersion));
            }
        } else if (soapAction != null && soapAction.length() > 0) {
            handler = this._versionUriHandlers.get(soapAction);
            if (handler == null) {
                handler = this._defaultVersionUriHandlers.get(methodNamespace);
                if (handler == null) {
                    throw new UnsupportedVersionException(String.format("Request version '%1$s' and namespace '%2$s' are not supported", soapAction, methodNamespace));
                }
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)String.format("Unrecognized request version '%1$s', using default handler for '%2$s'", soapAction, handler.getSupportedVersionUri()));
                }
            } else if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)String.format("Found handler for SOAPAction version '%1$s'", soapAction));
            }
        }
        if (handler == null) {
            handler = this._namespaceHandlers.get(methodNamespace);
            if (handler == null) {
                throw new UnsupportedVersionException(String.format("Request method namespace '%1$s' is not supported", methodNamespace));
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)String.format("Found handler for namespace '%1$s'", methodNamespace));
            }
        }
        return handler;
    }

    @Override
    public void dispatch(Request request, ChainedProcessingStep<Activation, Activation> nextStep, ChainedProcessingStep<Activation, Activation> completionStep) {
        SingleRequestDispatcher srd = new SingleRequestDispatcher(request, nextStep, completionStep);
        srd.dispatch();
    }

    private class SingleRequestDispatcher {
        private final Request _request;
        private final ChainedProcessingStep<Activation, Activation> _nextStep;
        private final ChainedProcessingStep<Activation, Activation> _completionStep;
        private Session _session;
        private Response _response;
        private EnvelopeStackContext _envelopeStackContext;
        private DeserializedRequest _deserializedRequest;

        public SingleRequestDispatcher(Request request, ChainedProcessingStep<Activation, Activation> nextStep, ChainedProcessingStep<Activation, Activation> completionStep) {
            this._request = request;
            this._nextStep = nextStep;
            this._completionStep = completionStep;
        }

        public void dispatch() {
            try {
                this.logRequestBodyIfNeeded();
                this.createResponse();
                this.resolveSessionFromRequest();
                this.putSessionIntoResponse();
                try {
                    this.parseRequest();
                    this.extractDeserializedRequest();
                }
                catch (XMLStreamException e) {
                    this.translateToInvalidRequest(e);
                }
                catch (UnmarshallException e) {
                    this.translateToInvalidRequest(e);
                }
                this.populateRequestContext();
                this.handleBody();
            }
            catch (ServiceUnavailableException e) {
                this.dispatchInternalServerError(e);
            }
            catch (RuntimeException e) {
                this.dispatchInternalServerError(e);
            }
        }

        private void logRequestBodyIfNeeded() {
            if (DispatcherImpl.this._logger.isDebugEnabled() && Boolean.getBoolean("vlsi.debug.server.logRequests")) {
                DispatcherImpl.this._logger.debug((Object)String.format("Request body:\n%1$s", this._request.getRequestBody()));
            }
        }

        private void createResponse() {
            this._response = new ResponseImpl(this._request.getCorrelator());
        }

        private void resolveSessionFromRequest() throws ServiceUnavailableException {
            String sessionId = this._request.getSessionCookie();
            if (DispatcherImpl.this._logger.isDebugEnabled()) {
                DispatcherImpl.this._logger.debug((Object)("Request session cookie is " + SHA1HashGenerator.generateTruncated((String)sessionId)));
            }
            this._session = DispatcherImpl.this._sessionManager.getSession(sessionId);
            if (this._session == null) {
                this._session = DispatcherImpl.this._sessionManager.createSession(sessionId);
                if (this._session == null) {
                    throw new ServiceUnavailableException("Failed to create session");
                }
                this._session.setBindingInfo(this._request.getBindingInfo());
            }
        }

        private void putSessionIntoResponse() {
            this._response.setSessionCookie(this._session.getId());
            this._response.setSessionCookiePath(this._request.getSessionCookiePath());
        }

        private void parseRequest() throws XMLStreamException, UnmarshallException {
            XMLInputFactory xmlInputFactory = XMLFactories.getInputFactory();
            XMLStreamReader input = xmlInputFactory.createXMLStreamReader((Reader)new CharSequenceReader(this._request.getRequestBody()));
            RequestUnmarshaller unmarshaller = new RequestUnmarshaller(DispatcherImpl.this, this._request.getSoapAction(), input);
            this._envelopeStackContext = unmarshaller.parseRequest();
        }

        private void extractDeserializedRequest() throws UnmarshallException {
            this._deserializedRequest = this._envelopeStackContext.getDeserializedRequest();
        }

        private void populateRequestContext() {
            RequestContext requestContext = this._deserializedRequest.getRequestContext();
            if (DiagnosticContextUtils.getDiagnosticContext(requestContext) == null) {
                if (requestContext == null) {
                    requestContext = new RequestContextImpl();
                }
                DiagnosticContextUtils.generateDiagnosticContext(requestContext);
            }
            this._request.setRequestContext(requestContext);
        }

        private void handleBody() {
            try {
                this.getBodyHandler().handleBody(this._deserializedRequest, this._request, this._response, this._session, this._nextStep, this._completionStep);
            }
            catch (ManagedObjectNotFound e) {
                DispatcherImpl.this._logger.warn((Object)"Managed object doesn't exist", (Throwable)e);
                this.completeErrorActivation((Exception)((Object)e));
            }
        }

        private BodyHandler getBodyHandler() {
            if (this._deserializedRequest != null) {
                return this._deserializedRequest.getBodyHandler();
            }
            if (this._envelopeStackContext == null || this._envelopeStackContext.getBody() == null || this._envelopeStackContext.getBody().getMethod() == null) {
                return null;
            }
            return this._envelopeStackContext.getBody().getMethod().getBodyHandler();
        }

        private void completeErrorActivation(Exception e) {
            VmodlVersion version = null;
            BodyHandler bodyHandler = this.attemptBodyHandlerRetrieval();
            if (bodyHandler != null) {
                version = bodyHandler.getSoapBinding().getVersion();
            }
            DispatchErrorActivationImpl errorActivation = new DispatchErrorActivationImpl(e, this._response, this._session, version);
            this._completionStep.getNextStep().process(errorActivation);
        }

        private BodyHandler attemptBodyHandlerRetrieval() {
            BodyHandler bodyHandler;
            block6: {
                bodyHandler = this.getBodyHandler();
                if (bodyHandler == null) {
                    try {
                        this.parseRequest();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    bodyHandler = this.getBodyHandler();
                }
                if (bodyHandler == null) {
                    try {
                        bodyHandler = DispatcherImpl.this.findBodyHandler(null, this._request.getSoapAction(), null);
                    }
                    catch (UnsupportedVersionException ex) {
                        if (!DispatcherImpl.this._logger.isDebugEnabled()) break block6;
                        DispatcherImpl.this._logger.debug((Object)String.format("Error getting body handler for request with soap-action %s: %s. Using default non-internal namespace to marshal the response now.", this._request.getSoapAction(), ex.getMessage()));
                    }
                }
            }
            return bodyHandler;
        }

        private void dispatchInternalServerError(Exception e) {
            if (!(e instanceof InvalidRequest)) {
                DispatcherImpl.this._logger.error((Object)"Internal server error during dispatch", (Throwable)e);
            }
            this.completeErrorActivation(e);
        }

        private void translateToInvalidRequest(Throwable e) {
            DispatcherImpl.this._logger.debug((Object)"Invalid request", e);
            InvalidRequest fault = new InvalidRequest();
            fault.setMessage(e.getMessage());
            throw fault;
        }
    }
}

