/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationResponseFilter;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterFutureImpl
implements ActivationResponseFilter.Future {
    private static final Log _logger = LogFactory.getLog(FilterFutureImpl.class);
    private ProcessingStep<Activation> _nextStep;
    private Activation _activation;
    private int _numFilters;
    private AtomicInteger _filterCount;
    private boolean _isDone;
    private volatile boolean _isCanceled;

    public FilterFutureImpl(Activation activation, int numFilters, AtomicInteger filterCount, ProcessingStep<Activation> nextStep) {
        this._activation = activation;
        this._numFilters = numFilters;
        this._filterCount = filterCount;
        this._nextStep = nextStep;
        this._isDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeIfAllDone() {
        block8: {
            AtomicInteger atomicInteger = this._filterCount;
            synchronized (atomicInteger) {
                if (this._isCanceled) {
                    return;
                }
            }
            String id = this._activation.getRequest().getCorrelator();
            int count = this._filterCount.incrementAndGet();
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)String.format("Future %1$d/%2$d is set for for %3$s", count, this._numFilters, id));
            }
            if (count == this._numFilters) {
                try {
                    this._nextStep.process(this._activation);
                }
                catch (RuntimeException e) {
                    if (!_logger.isErrorEnabled()) break block8;
                    _logger.error((Object)"Failed to complete filtering", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setDone() {
        if (this._isDone) {
            throw new IllegalArgumentException("Future is already set");
        }
        this._isDone = true;
        this.completeIfAllDone();
    }

    public Activation getActivation() {
        return this._activation;
    }

    protected void cancel() {
        this._isCanceled = true;
    }
}

