/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.ResponseContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.common.ChainedProcessingStep;
import com.vmware.vim.vmomi.server.common.impl.RequestImpl;
import com.vmware.vim.vmomi.server.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.server.impl.ActivationImpl;
import com.vmware.vim.vmomi.server.impl.Correlator;
import com.vmware.vim.vmomi.server.session.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MethodInvocationHandlerImpl
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Method SET_REQ_CTX;
    private static final Method GET_RESP_CTX;
    private static final Method GET_MO_CLASS;
    private static final Method GET_REF;
    private static final Method TO_STRING;
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private final ManagedObject _mo;
    private final ManagedObjectType _moType;
    private final VmodlVersion _version;
    private final Session _session;
    private final AdapterServer _adapterServer;
    private final Correlator _correlator;
    private final ChainedProcessingStep<Activation, Activation> _validationStep;
    private final ChainedProcessingStep<Activation, Activation> _filterStep;
    private RequestContext _requestContext;
    private volatile ThreadLocal<ResponseContext> _responseContext;
    private final ReentrantReadWriteLock _stateLock;

    public MethodInvocationHandlerImpl(ManagedObject mo, ManagedObjectType moType, VmodlVersion version, Session session, AdapterServer adapterServer, Correlator correlator, ChainedProcessingStep<Activation, Activation> validationStep, ChainedProcessingStep<Activation, Activation> filterStep) {
        this._mo = mo;
        this._moType = moType;
        this._version = version;
        this._session = session;
        this._adapterServer = adapterServer;
        this._correlator = correlator;
        this._validationStep = validationStep;
        this._filterStep = filterStep;
        this._stateLock = new ReentrantReadWriteLock();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this._stateLock.readLock().lock();
        try {
            ManagedProperty moProp = this._moType.getManagedProperty(method);
            if (moProp != null) {
                Object object = this.doInvoke(moProp.getAccessor(), args);
                return object;
            }
            ManagedMethod moMethod = this._moType.getMethod(method);
            if (moMethod != null) {
                Object object = this.doInvoke(moMethod, args);
                return object;
            }
            if (SET_REQ_CTX.equals(method)) {
                this.upgradeToWriteLock();
                this.setRequestContext((RequestContext)args[0]);
                Object var6_9 = null;
                return var6_9;
            }
            if (GET_RESP_CTX.equals(method)) {
                ResponseContext responseContext = this.getResponseContext();
                return responseContext;
            }
            if (GET_MO_CLASS.equals(method)) {
                Class<? extends ManagedObject> clazz = this.getManagedObjectClass();
                return clazz;
            }
            if (GET_REF.equals(method)) {
                ManagedObjectReference managedObjectReference = this._mo._getRef();
                return managedObjectReference;
            }
            if (TO_STRING.equals(method)) {
                String string = "LocalStub: moRef = (" + this._mo._getRef() + ")";
                return string;
            }
            if (EQUALS.equals(method)) {
                Boolean bl = proxy == args[0];
                return bl;
            }
            if (HASH_CODE.equals(method)) {
                Integer n = this.hashCode();
                return n;
            }
            try {
                throw new IllegalArgumentException(String.format("Cannot invoke method '%1$s' on Managed Object '%2$s'", method.getName(), this._moType));
            }
            catch (Exception e) {
                Class<?>[] declaredExceptions;
                if (RuntimeException.class.isInstance(e)) {
                    throw e;
                }
                for (Class<?> ex : declaredExceptions = method.getExceptionTypes()) {
                    if (!ex.isInstance(e)) continue;
                    throw e;
                }
                throw new InternalException(String.format("Managed Object '%1$s' thrown unexpected exception '%2$s' when invoking method '%3$s'", this._moType.getTypeName(), e.getClass().getName(), method.getName()), (Throwable)e);
            }
        }
        finally {
            if (this._stateLock.isWriteLockedByCurrentThread()) {
                this._stateLock.writeLock().unlock();
            } else {
                this._stateLock.readLock().unlock();
            }
        }
    }

    private void upgradeToWriteLock() {
        this._stateLock.readLock().unlock();
        this._stateLock.writeLock().lock();
    }

    private Object doInvoke(ManagedMethod method, Object[] args) throws Throwable {
        boolean async = MethodInvocationHandlerImpl.resolveAsyncMode(args);
        Future<Object> future = MethodInvocationHandlerImpl.resolveFuture(args, async);
        args = MethodInvocationHandlerImpl.resolveArgs(args, async);
        this.setResponseContext(null);
        RequestImpl request = new RequestImpl();
        request.setRequestContext(this._requestContext);
        ResponseImpl response = new ResponseImpl(request.getCorrelator());
        ActivationImpl activation = new ActivationImpl(this._version, this._mo, method, args, this._session, request, response, null, null);
        this._correlator.put(activation.getRequest().getCorrelator(), future);
        this._adapterServer.invoke(activation, this._validationStep, this._filterStep);
        if (async) {
            return null;
        }
        try {
            Object ret = future.get();
            this.setResponseContext(response.getResponseContext());
            return ret;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private void setRequestContext(RequestContext context) {
        this._requestContext = context;
    }

    private ResponseContext getResponseContext() {
        this.initResponseContextProp();
        return this._responseContext.get();
    }

    private Class<? extends ManagedObject> getManagedObjectClass() {
        return this._moType.getTypeClass();
    }

    private void setResponseContext(ResponseContext context) {
        this.initResponseContextProp();
        this._responseContext.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResponseContextProp() {
        if (null == this._responseContext) {
            MethodInvocationHandlerImpl methodInvocationHandlerImpl = this;
            synchronized (methodInvocationHandlerImpl) {
                if (null == this._responseContext) {
                    this._responseContext = new ThreadLocal();
                }
            }
        }
    }

    private static boolean resolveAsyncMode(Object[] args) {
        return args != null && args.length > 0 && args[args.length - 1] instanceof Future;
    }

    private static Future<Object> resolveFuture(Object[] args, boolean async) {
        return async ? (Future)args[args.length - 1] : new BlockingFuture();
    }

    private static Object[] resolveArgs(Object[] args, boolean async) {
        if (async) {
            Object[] noFuture = new Object[args.length - 1];
            System.arraycopy(args, 0, noFuture, 0, noFuture.length);
            return noFuture;
        }
        if (args == null) {
            return NO_ARGS;
        }
        return args;
    }

    static {
        try {
            SET_REQ_CTX = Stub.class.getMethod("_setRequestContext", RequestContext.class);
            GET_RESP_CTX = Stub.class.getMethod("_getResponseContext", new Class[0]);
            GET_MO_CLASS = Stub.class.getMethod("_getManagedObjectClass", new Class[0]);
            GET_REF = ManagedObject.class.getMethod("_getRef", new Class[0]);
            TO_STRING = Object.class.getMethod("toString", new Class[0]);
            EQUALS = Object.class.getMethod("equals", Object.class);
            HASH_CODE = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

