/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationValidator;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.exception.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorFutureImpl
implements ActivationValidator.Future {
    private static final Log _logger = LogFactory.getLog(ValidatorFutureImpl.class);
    private ProcessingStep<Activation> _nextStep;
    private Activation _activation;
    private int _numValidators;
    private AtomicInteger _validationCount;
    private boolean _isSet;
    private boolean _isValid;
    private volatile boolean _isCanceled;
    private Exception _fault;

    public ValidatorFutureImpl(Activation activation, int numValidators, AtomicInteger validationCount, ProcessingStep<Activation> nextStep) {
        this._activation = activation;
        this._numValidators = numValidators;
        this._validationCount = validationCount;
        this._nextStep = nextStep;
        this._isSet = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeIfDone() {
        AtomicInteger atomicInteger = this._validationCount;
        synchronized (atomicInteger) {
            if (this._isCanceled) {
                return;
            }
        }
        String id = this._activation.getRequest().getCorrelator();
        int count = this._validationCount.incrementAndGet();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Future %1$d/%2$d is set for for %3$s (valid: %4$b)", count, this._numValidators, id, this._isValid));
        }
        if (count == this._numValidators) {
            try {
                Exception fault = this._activation.getFault();
                if (fault != null) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)String.format("Validation failed for %1$s: %2$s", this._activation.getRequest().getCorrelator(), fault.getMessage()));
                    }
                    this._activation.getFutureArg().setException(fault);
                } else {
                    this._nextStep.process(this._activation);
                }
            }
            catch (RuntimeException e) {
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)"Failed to complete validation", (Throwable)e);
                }
                this._activation.getFutureArg().setException((Exception)ExceptionUtil.buildFaultForInternalException(e));
            }
        }
    }

    @Override
    public void setValid() {
        if (this._isSet) {
            throw new IllegalArgumentException("Future is already set");
        }
        this._isValid = true;
        this._isSet = true;
        this.completeIfDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFault(Exception fault) {
        if (fault == null) {
            throw new IllegalArgumentException("Fault must not be null");
        }
        if (this._isSet) {
            throw new IllegalArgumentException("Future is already set");
        }
        this._fault = fault;
        AtomicInteger atomicInteger = this._validationCount;
        synchronized (atomicInteger) {
            if (!this._isCanceled) {
                this._activation.setFault(this._fault);
            }
        }
        this._isSet = true;
        this.completeIfDone();
    }

    @Override
    public boolean isValid() {
        return this._isValid;
    }

    @Override
    public Exception getFault() {
        return this._fault;
    }

    public Activation getActivation() {
        return this._activation;
    }

    protected void cancel() {
        this._isCanceled = true;
    }
}

