/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl.unmarshaller;

import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.server.DeserializedRequest;
import com.vmware.vim.vmomi.server.impl.unmarshaller.HeaderParamContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.SkipElementStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.VersionUriStackContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HeaderStackContext
extends StackContext {
    private static final Log LOG = LogFactory.getLog(HeaderStackContext.class);
    private final Map<QName, StackContext> _children = new HashMap<QName, StackContext>();

    @Override
    public StackContext getNestedContext(QName name, Map<QName, String> attrs) throws UnmarshallException {
        if (name.equals(Constants.SECURITY_QNAME)) {
            return new SkipElementStackContext();
        }
        StackContext child = null;
        if ("versionURI".equals(name.getLocalPart())) {
            child = new VersionUriStackContext(name);
        } else {
            String type = null;
            boolean mustUnderstand = false;
            for (QName attr : attrs.keySet()) {
                if (attr.getLocalPart().equals("type") && (type = attrs.get(attr)).contains(":")) {
                    type = type.split(":")[1];
                }
                if (!attr.getLocalPart().equals("mustUnderstand")) continue;
                mustUnderstand = attrs.get(attr).equals("1");
            }
            child = new HeaderParamContext(name, type, mustUnderstand);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Adding child '%1$s'", name));
        }
        this._children.put(name, child);
        return child;
    }

    public StackContext getChild(QName name) {
        return this._children.get(name);
    }

    public Set<QName> getChildrenNames() {
        return this._children.keySet();
    }

    public void updateDeserializedRequest(DeserializedRequest deserializedRequest) throws UnmarshallException {
        Set<QName> names = this._children.keySet();
        RequestContextImpl context = null;
        for (QName name : names) {
            if ("versionURI".equals(name.getLocalPart())) continue;
            if (null == context) {
                context = new RequestContextImpl();
            }
            HeaderParamContext value = (HeaderParamContext)this._children.get(name);
            context.put((Object)name.getLocalPart(), value.getUnmarshalledValue());
        }
        deserializedRequest.setRequestContext((RequestContext)context);
    }
}

