/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.jms.proxy.impl;

import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.common.Response;
import com.vmware.vim.vmomi.server.common.impl.ResponseImpl;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseListener
implements MessageListener {
    private Log _logger = LogFactory.getLog(this.getClass());
    private ProcessingStep<Response> _nextStep;

    public ResponseListener(ProcessingStep<Response> nextStep) {
        this._logger.info((Object)"Created JMS response listener");
        this._nextStep = nextStep;
    }

    public void onMessage(Message message) {
        if (message instanceof MapMessage) {
            try {
                MapMessage map = (MapMessage)message;
                String correlator = map.getString("VMWARE_correlator");
                if (this._logger.isInfoEnabled()) {
                    this._logger.info((Object)("Received response: " + correlator));
                }
                ResponseImpl response = new ResponseImpl(correlator);
                response.setResponseBody(map.getString("body"));
                response.setFault(map.itemExists("SOAPJMS_isFault") ? map.getBoolean("SOAPJMS_isFault") : false);
                response.setSessionCookie(map.getString("VMWARE_sessionCookie"));
                response.setSessionCookiePath(map.getString("VMWARE_sessionCookiePath"));
                this._nextStep.process(response);
            }
            catch (JMSException e) {
                this._logger.error((Object)"Unable to convert incoming JMS response message", (Throwable)e);
            }
        } else {
            this._logger.error((Object)"Incoming JMS response message had invalid type");
        }
    }
}

