/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.mob.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import com.vmware.vim.vmomi.core.util.ServiceObjectUtil;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.LocalClient;
import com.vmware.vim.vmomi.server.mob.Authenticator;
import com.vmware.vim.vmomi.server.mob.Request;
import com.vmware.vim.vmomi.server.mob.Responder;
import com.vmware.vim.vmomi.server.mob.Response;
import com.vmware.vim.vmomi.server.mob.impl.MethodInvocationFuture;
import com.vmware.vim.vmomi.server.mob.impl.MobRenderer;
import com.vmware.vim.vmomi.server.mob.impl.MobServletUtils;
import com.vmware.vim.vmomi.server.mob.impl.ObjectGetter;
import com.vmware.vim.vmomi.server.mob.impl.RequestCredentials;
import com.vmware.vim.vmomi.server.mob.impl.RequestSettings;
import com.vmware.vim.vmomi.server.mob.impl.ResponseImpl;
import com.vmware.vim.vmomi.server.mob.impl.SampleValueGenerator;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionAuthData;
import com.vmware.vim.vmomi.server.session.SessionManager;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MobTask
implements Runnable {
    private static Log _logger = LogFactory.getLog(MobTask.class);
    private final Request _request;
    private final HttpServletRequest _servletRequest;
    private final PrintWriter _responseWriter;
    private final AdapterServer _adapterServer;
    private final LocalClient _localClient;
    private final ManagedObject[] _rootObjects;
    private final VmodlVersion _version;
    private final SampleValueGenerator _generator;
    private Session _session;
    private final VmodlContext _context;
    private final SessionManager _sessionManager;
    private final Authenticator _authenticator;
    private final Responder _responder;
    private final String _urlPath;
    private final String _logoutPath;
    private final String _logoutFinishPath;
    private final Response _response;
    public static final String SESSION_NONCE_NAME = "vmware-session-nonce";
    private static final String AUTH_CHALLENGE_REALM = "VMware vSphere API Browser";
    private static final String LOGOUT_PATH = "logout";
    private static final String LOGOUT_FINISH_PATH = "logout/finish";

    public MobTask(Request request, AdapterServer adapterServer, LocalClient localClient, SessionManager sessionManager, Authenticator authenticator, SampleValueGenerator generator, VmodlVersion version, VmodlContext context, ManagedObject[] rootObjects, Responder responder, String urlPath) {
        this._request = request;
        this._servletRequest = request.getServletRequest();
        this._adapterServer = adapterServer;
        this._localClient = localClient;
        this._sessionManager = sessionManager;
        this._authenticator = authenticator;
        this._generator = generator;
        this._version = version;
        this._context = context;
        this._rootObjects = new ManagedObject[rootObjects.length];
        for (int i = 0; i < rootObjects.length; ++i) {
            this._rootObjects[i] = ServiceObjectUtil.adaptService((ManagedObject)rootObjects[i]);
        }
        this._responder = responder;
        this._response = new ResponseImpl();
        this._urlPath = urlPath;
        this._responseWriter = new PrintWriter(this._response.getWriter(), true);
        this._logoutPath = urlPath + "/" + LOGOUT_PATH;
        this._logoutFinishPath = urlPath + "/" + LOGOUT_FINISH_PATH;
    }

    void returnResponse() {
        this._responder.returnResponse(this._request, this._response);
        if (this._session != null) {
            this._session.returnSession();
        }
    }

    private Session resolveSession() {
        Cookie sessionCookie = MobServletUtils.getSessionCookie(this._servletRequest);
        Session session = null;
        if (sessionCookie != null) {
            String sessionId = sessionCookie.getValue();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Request session cookie is " + SHA1HashGenerator.generateTruncated((String)sessionId)));
            }
            if ((session = this._sessionManager.getSession(sessionId)) == null && _logger.isWarnEnabled()) {
                _logger.warn((Object)("Invalid session cookie is " + SHA1HashGenerator.generateTruncated((String)sessionId)));
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"No session cookie specified");
        }
        if (session == null) {
            session = this._sessionManager.createSession();
            if (session == null) {
                this._response.setServerFault(503);
                return null;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Created session with id " + SHA1HashGenerator.generateTruncated((String)session.getId())));
            }
        }
        this._response.setSessionCookie(session.getId());
        return session;
    }

    private boolean authenticate(RequestCredentials credentials) {
        this._session = this.resolveSession();
        if (this._session == null) {
            return false;
        }
        if (this._session.getAuthData() != null) {
            return true;
        }
        Cookie cookie = MobServletUtils.getSessionCookie(this._servletRequest);
        if (cookie != null && !this._session.getId().equals(cookie.getValue())) {
            this._response.setAuthChallenge(AUTH_CHALLENGE_REALM);
            return false;
        }
        SessionAuthData authData = credentials.authenticate(this._authenticator, this._session);
        if (authData == null) {
            if (this._session.getAuthData() == null) {
                this._response.setAuthChallenge(AUTH_CHALLENGE_REALM);
                return false;
            }
            return true;
        }
        if (this._session.getAuthData() == null) {
            this._session.setAuthData(authData);
        } else {
            _logger.warn((Object)String.format("Ignoring SessionAuthData %s returned by the Authenticator.Using the SessionAuthData %s that the Authenticator has setdirectly to the session", authData, this._session.getAuthData()));
        }
        return true;
    }

    private MobRenderer createRenderer(RequestSettings modeResolver) {
        return new MobRenderer(this._localClient, this._version, this._session, this._generator, this._urlPath, modeResolver, this._context);
    }

    private void handleComplexObjectGet(ManagedObject mObject, ManagedObjectType moType, RequestSettings settings) {
        ObjectGetter objGetter = new ObjectGetter(this._localClient, this._version, this._session, this._context);
        Object obj = objGetter.getObjectAtPath(mObject, settings.getCoPath());
        if (obj == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)String.format("No such object in type %s at property path %s", settings.resolveDisplayName((VmodlType)moType), settings.getCoPath()));
            }
            this._response.setServerFault(404);
            return;
        }
        this._responseWriter.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>  <head>    <title>      Managed Object Browser    </title><style type=\"text/css\"><!--body {  font-family: Verdana, Arial, Helvetica, sans-serif;  font-size: 12px;  color: #000;  background-color: #fff;  margin-left: 2%;  margin-right: 2%;}a         { color: #036; text-decoration: underline; }a:visited { color: #036;  text-decoration: underline; }a:hover   { color: #3366AA; text-decoration: none; }p.table-title {  font-weight: bold;  margin: 10px 0 5px 5px;}table {  border-collapse:collapse;  border-top: 1px solid #999;  border-left: 1px solid #999;  width: 100%}td, th {  font-size: 12px;  padding: 5px 10px 5px 10px;  border-bottom: 1px solid #999;  border-right: 1px solid #999;  vertical-align: top;}th {  background-color: #555555;  color: #fff;  text-transform: uppercase;  font-size: 10px;  text-align: left;  white-space: nowrap;}tr.title td {  background-color: #F0F8FF;}span.object {       font-size: 150%;}span.property {       font-size: 125%;       padding-left: 1em;}td.c1 {        width: 1%;        text-align: right;       }td.c2 {        width: 1%;        text-align: right;       }span.nav-button {  border-top: 1px solid #999;  border-left: 1px solid #999;  border-right: 1px solid #999;       padding-left: 1em;       padding-right: 1em;       margin-right: 5px;       text-decoration: none;       cursor: pointer;  background-color: #FFF0F0;       color: #036;}span.logout-button {  float: right;  margin-right: 0px;}ul.noindent {       margin-bottom: 0;       margin-left: 1em;}h1 {  font-size: 18px;  font-weight: bold;  color: #3366AA;  margin-bottom: 25px;  padding-bottom: 5px;  border-bottom-width: 1px;  border-bottom-style: dashed;  border-bottom-color: #95a8a6;}input {   font-family:verdana;width:100%;font-size: 12px;}textarea {  font-family:verdana;width:100%;font-size: 12px;}--></style>  </head>  <body><script type=\"text/javascript\">/* <![CDATA[ */function openMethodInvocationWindow(svcName, moId, method, renderVmodl) {  var url = svcName + '/?moid=' + escape(moId) + '&method=' + method;  if (renderVmodl) url += '&vmodl=1';  window.open(url, 'methodInvocation','width=600,height=400,scrollbars=yes,toolbar=yes,resizable=yes');}function invokeMethod() {document.method.submit();}/* ]]> */</script>");
        VmodlType type = this._context.getVmodlTypeMap().getDynamicVmodlType(obj);
        if (type == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"Complex object is not a VMODL type");
            }
            this._response.setServerFault(404);
            return;
        }
        this._responseWriter.format("<span class=\"nav-button\" onclick=\"location='%s';\">Home</span><table summary=\"Table of properties for this Data Object\"><tr class=\"title\"><td colspan=\"3\"><span class=\"object\">Data Object Type: <strong>%s</strong></span><br/><span class=\"property\">Parent Managed Object ID: <strong>%s</strong></span><br/><span class=\"property\">Property Path: <strong>%s</strong></span></td></tr></table><p class=\"table-title\">Properties</p><table><tr><th>Name</th><th>Type</th><th>Value</th></tr>", settings.resolveHomeUrl(this._urlPath), settings.resolveDisplayName(type), mObject._getRef().getValue(), settings.getCoPath());
        MobRenderer mobRenderer = this.createRenderer(settings);
        if (type.getKind() == VmodlType.Kind.ARRAY) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(obj, i);
                ComplexType itemType = (ComplexType)this._context.getVmodlTypeMap().getDynamicVmodlType(item);
                this._responseWriter.format("<tr><td class=\"c2\">%s</td><td class=\"c1\">%s</td><td>", Integer.toString(i), itemType.getWsdlName());
                mobRenderer.renderEmbeddedComplexObject(mObject._getRef(), item, itemType, settings.getCoPath(), this._responseWriter);
                this._responseWriter.format("</td></tr>", new Object[0]);
            }
        } else {
            mobRenderer.renderComplexObject(mObject._getRef(), obj, (ComplexType)type, settings.getCoPath(), this._responseWriter);
        }
        this._responseWriter.print("</table>");
        this._responseWriter.print("</body></html>");
    }

    private void handleMethodGet(ManagedObject mObject, ManagedObjectType moType, RequestSettings settings) {
        this._responseWriter.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>  <head>    <title>      Managed Object Browser    </title><style type=\"text/css\"><!--body {  font-family: Verdana, Arial, Helvetica, sans-serif;  font-size: 12px;  color: #000;  background-color: #fff;  margin-left: 2%;  margin-right: 2%;}a         { color: #036; text-decoration: underline; }a:visited { color: #036;  text-decoration: underline; }a:hover   { color: #3366AA; text-decoration: none; }p.table-title {  font-weight: bold;  margin: 10px 0 5px 5px;}table {  border-collapse:collapse;  border-top: 1px solid #999;  border-left: 1px solid #999;  width: 100%}td, th {  font-size: 12px;  padding: 5px 10px 5px 10px;  border-bottom: 1px solid #999;  border-right: 1px solid #999;  vertical-align: top;}th {  background-color: #555555;  color: #fff;  text-transform: uppercase;  font-size: 10px;  text-align: left;  white-space: nowrap;}tr.title td {  background-color: #F0F8FF;}span.object {       font-size: 150%;}span.property {       font-size: 125%;       padding-left: 1em;}td.c1 {        width: 1%;        text-align: right;       }td.c2 {        width: 1%;        text-align: right;       }span.nav-button {  border-top: 1px solid #999;  border-left: 1px solid #999;  border-right: 1px solid #999;       padding-left: 1em;       padding-right: 1em;       margin-right: 5px;       text-decoration: none;       cursor: pointer;  background-color: #FFF0F0;       color: #036;}span.logout-button {  float: right;  margin-right: 0px;}ul.noindent {       margin-bottom: 0;       margin-left: 1em;}h1 {  font-size: 18px;  font-weight: bold;  color: #3366AA;  margin-bottom: 25px;  padding-bottom: 5px;  border-bottom-width: 1px;  border-bottom-style: dashed;  border-bottom-color: #95a8a6;}input {   font-family:verdana;width:100%;font-size: 12px;}textarea {  font-family:verdana;width:100%;font-size: 12px;}--></style>  </head>  <body><script type=\"text/javascript\">/* <![CDATA[ */function openMethodInvocationWindow(svcName, moId, method, renderVmodl) {  var url = svcName + '/?moid=' + escape(moId) + '&method=' + method;  if (renderVmodl) url += '&vmodl=1';  window.open(url, 'methodInvocation','width=600,height=400,scrollbars=yes,toolbar=yes,resizable=yes');}function invokeMethod() {document.method.submit();}/* ]]> */</script>");
        ManagedMethod managedMethod = moType.getWsdlMethod(settings.getMethod());
        if (managedMethod == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)String.format("No such method %s in type %s", settings.getMethod(), settings.resolveDisplayName((VmodlType)moType)));
            }
            this._response.setServerFault(404);
            return;
        }
        MobRenderer mobRenderer = this.createRenderer(settings);
        mobRenderer.renderMethod(mObject, moType, managedMethod, null, null, this._session.getSessionNonce(), this._responseWriter);
        this._responseWriter.print("</body></html>");
    }

    private void handleRootObjectsGet(RequestSettings settings) {
        this._responseWriter.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>  <head>    <title>      Managed Object Browser    </title><style type=\"text/css\"><!--body {  font-family: Verdana, Arial, Helvetica, sans-serif;  font-size: 12px;  color: #000;  background-color: #fff;  margin-left: 2%;  margin-right: 2%;}a         { color: #036; text-decoration: underline; }a:visited { color: #036;  text-decoration: underline; }a:hover   { color: #3366AA; text-decoration: none; }p.table-title {  font-weight: bold;  margin: 10px 0 5px 5px;}table {  border-collapse:collapse;  border-top: 1px solid #999;  border-left: 1px solid #999;  width: 100%}td, th {  font-size: 12px;  padding: 5px 10px 5px 10px;  border-bottom: 1px solid #999;  border-right: 1px solid #999;  vertical-align: top;}th {  background-color: #555555;  color: #fff;  text-transform: uppercase;  font-size: 10px;  text-align: left;  white-space: nowrap;}tr.title td {  background-color: #F0F8FF;}span.object {       font-size: 150%;}span.property {       font-size: 125%;       padding-left: 1em;}td.c1 {        width: 1%;        text-align: right;       }td.c2 {        width: 1%;        text-align: right;       }span.nav-button {  border-top: 1px solid #999;  border-left: 1px solid #999;  border-right: 1px solid #999;       padding-left: 1em;       padding-right: 1em;       margin-right: 5px;       text-decoration: none;       cursor: pointer;  background-color: #FFF0F0;       color: #036;}span.logout-button {  float: right;  margin-right: 0px;}ul.noindent {       margin-bottom: 0;       margin-left: 1em;}h1 {  font-size: 18px;  font-weight: bold;  color: #3366AA;  margin-bottom: 25px;  padding-bottom: 5px;  border-bottom-width: 1px;  border-bottom-style: dashed;  border-bottom-color: #95a8a6;}input {   font-family:verdana;width:100%;font-size: 12px;}textarea {  font-family:verdana;width:100%;font-size: 12px;}--></style>  </head>  <body><script type=\"text/javascript\">/* <![CDATA[ */function openMethodInvocationWindow(svcName, moId, method, renderVmodl) {  var url = svcName + '/?moid=' + escape(moId) + '&method=' + method;  if (renderVmodl) url += '&vmodl=1';  window.open(url, 'methodInvocation','width=600,height=400,scrollbars=yes,toolbar=yes,resizable=yes');}function invokeMethod() {document.method.submit();}/* ]]> */</script>");
        for (ManagedObject mObject : this._rootObjects) {
            ManagedObjectType moType = (ManagedObjectType)this._context.getVmodlTypeMap().getDynamicVmodlType((Object)mObject);
            this._responseWriter.format("<span class=\"nav-button\" onclick=\"location='%s';\">Home</span><span class=\"nav-button logout-button\" onclick=\"location='%s/logout';\">Logout</span><table summary=\"Table of properties for this Managed Object\"><tr class=\"title\"><td colspan=\"3\"><span class=\"object\">Managed Object Type: <strong>%s</strong></span><br /><span class=\"property\">Managed Object ID: <strong>%s</strong></span><br /><span class=\"property\">&nbsp;</span></td></tr></table><p class=\"table-title\">Properties</p><table><tr><th>Name</th><th>Type</th><th>Value</th></tr>", settings.resolveHomeUrl(this._urlPath), settings.resolveHomeUrl(this._urlPath), settings.resolveDisplayName((VmodlType)moType), mObject._getRef().getValue());
            MobRenderer mobRenderer = this.createRenderer(settings);
            mobRenderer.renderManagedObject(mObject, moType, this._responseWriter);
            this._responseWriter.print("</table>");
            this._responseWriter.print("<br/>");
        }
        this._responseWriter.print("</body></html>");
    }

    private void handleManagedObjectGet(ManagedObject mObject, ManagedObjectType moType, RequestSettings settings) {
        this._responseWriter.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>  <head>    <title>      Managed Object Browser    </title><style type=\"text/css\"><!--body {  font-family: Verdana, Arial, Helvetica, sans-serif;  font-size: 12px;  color: #000;  background-color: #fff;  margin-left: 2%;  margin-right: 2%;}a         { color: #036; text-decoration: underline; }a:visited { color: #036;  text-decoration: underline; }a:hover   { color: #3366AA; text-decoration: none; }p.table-title {  font-weight: bold;  margin: 10px 0 5px 5px;}table {  border-collapse:collapse;  border-top: 1px solid #999;  border-left: 1px solid #999;  width: 100%}td, th {  font-size: 12px;  padding: 5px 10px 5px 10px;  border-bottom: 1px solid #999;  border-right: 1px solid #999;  vertical-align: top;}th {  background-color: #555555;  color: #fff;  text-transform: uppercase;  font-size: 10px;  text-align: left;  white-space: nowrap;}tr.title td {  background-color: #F0F8FF;}span.object {       font-size: 150%;}span.property {       font-size: 125%;       padding-left: 1em;}td.c1 {        width: 1%;        text-align: right;       }td.c2 {        width: 1%;        text-align: right;       }span.nav-button {  border-top: 1px solid #999;  border-left: 1px solid #999;  border-right: 1px solid #999;       padding-left: 1em;       padding-right: 1em;       margin-right: 5px;       text-decoration: none;       cursor: pointer;  background-color: #FFF0F0;       color: #036;}span.logout-button {  float: right;  margin-right: 0px;}ul.noindent {       margin-bottom: 0;       margin-left: 1em;}h1 {  font-size: 18px;  font-weight: bold;  color: #3366AA;  margin-bottom: 25px;  padding-bottom: 5px;  border-bottom-width: 1px;  border-bottom-style: dashed;  border-bottom-color: #95a8a6;}input {   font-family:verdana;width:100%;font-size: 12px;}textarea {  font-family:verdana;width:100%;font-size: 12px;}--></style>  </head>  <body><script type=\"text/javascript\">/* <![CDATA[ */function openMethodInvocationWindow(svcName, moId, method, renderVmodl) {  var url = svcName + '/?moid=' + escape(moId) + '&method=' + method;  if (renderVmodl) url += '&vmodl=1';  window.open(url, 'methodInvocation','width=600,height=400,scrollbars=yes,toolbar=yes,resizable=yes');}function invokeMethod() {document.method.submit();}/* ]]> */</script>");
        this._responseWriter.format("<span class=\"nav-button\" onclick=\"location='%s';\">Home</span><span class=\"nav-button logout-button\" onclick=\"location='%s/logout';\">Logout</span><table summary=\"Table of properties for this Managed Object\"><tr class=\"title\"><td colspan=\"3\"><span class=\"object\">Managed Object Type: <strong>%s</strong></span><br /><span class=\"property\">Managed Object ID: <strong>%s</strong></span><br /><span class=\"property\">&nbsp;</span></td></tr></table><p class=\"table-title\">Properties</p><table><tr><th>Name</th><th>Type</th><th>Value</th></tr>", this._urlPath, this._urlPath, settings.resolveDisplayName((VmodlType)moType), mObject._getRef().getValue());
        MobRenderer mobRenderer = this.createRenderer(settings);
        mobRenderer.renderManagedObject(mObject, moType, this._responseWriter);
        this._responseWriter.print("</table>");
        this._responseWriter.print("</body></html>");
    }

    private void handleGet(RequestSettings settings) {
        if (this._servletRequest.getRequestURI().equals(this._logoutPath)) {
            this._response.setRedirect(this._logoutFinishPath);
            this._session.closeSession();
            this._response.setSessionCookie(null);
            return;
        }
        if (!settings.hasMoId()) {
            this.handleRootObjectsGet(settings);
            return;
        }
        ManagedObject mObject = this._adapterServer.lookupManagedObject(settings.getMoId());
        if (mObject == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)String.format("No such object %s", settings.getMoId()));
            }
            this._response.setServerFault(404);
            return;
        }
        ManagedObjectType moType = (ManagedObjectType)this._context.getVmodlTypeMap().getDynamicVmodlType((Object)mObject);
        if (settings.hasMethod()) {
            this.handleMethodGet(mObject, moType, settings);
        } else if (settings.hasCoPath()) {
            this.handleComplexObjectGet(mObject, moType, settings);
        } else {
            this.handleManagedObjectGet(mObject, moType, settings);
        }
    }

    private void handlePost(RequestSettings params) {
        String method;
        ManagedObject mObject;
        block24: {
            String sessionNonce = this._servletRequest.getParameter(SESSION_NONCE_NAME);
            if (sessionNonce == null || !sessionNonce.equals(this._session.getSessionNonce())) {
                try {
                    String action = params.resolveMethodAction(this._urlPath, params.getMoId(), params.getMethod());
                    String body = String.format("<h1>403: Forbidden</h1><h3>Possible XSRF (Cross-Site Request Forgery) detected.</h3>If you believe you have received this in error, follow the link <a href=\"%s\">here</a>, and resubmit your request.  If you continue to receive this error, please be sure you have cookies enabled.", action);
                    this._response.setServerFault(403);
                    this._responseWriter.write(body);
                    this.returnResponse();
                    return;
                }
                catch (UnsupportedEncodingException e) {
                    if (!_logger.isWarnEnabled()) break block24;
                    _logger.warn((Object)"Bad encoding", (Throwable)e);
                }
            }
        }
        if ((mObject = this._adapterServer.lookupManagedObject(params.getMoId())) == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)String.format("No such object %s", params.getMoId()));
            }
            this._response.setServerFault(404);
            this.returnResponse();
            return;
        }
        ManagedObjectType moType = (ManagedObjectType)this._context.getVmodlTypeMap().getDynamicVmodlType((Object)mObject);
        ManagedMethod managedMethod = moType.getWsdlMethod(method = params.getMethod());
        if (managedMethod == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)String.format("No such method %s in type %s", method, moType.getWsdlName()));
            }
            this._response.setServerFault(404);
            this.returnResponse();
            return;
        }
        MobRenderer mobRenderer = this.createRenderer(params);
        ArrayList<Object> args = new ArrayList<Object>();
        RuntimeFault error = null;
        try {
            for (VmodlField param : managedMethod.getParameters()) {
                String paramName = param.getWsdlName();
                VmodlType paramType = param.getType();
                VmodlType.Kind kind = paramType.getKind();
                String value = this._servletRequest.getParameter(paramName);
                if (value == null || value.isEmpty()) {
                    if (!param.isOptional()) {
                        if (_logger.isWarnEnabled()) {
                            _logger.warn((Object)String.format("Unset non-optional parameter %s", paramName));
                        }
                        InvalidArgument e = new InvalidArgument();
                        e.setInvalidProperty(paramName);
                        throw e;
                    }
                    if (kind == VmodlType.Kind.ARRAY) {
                        VmodlArrayType arrayType = (VmodlArrayType)paramType;
                        args.add(arrayType.newInstance(0));
                        continue;
                    }
                    args.add(null);
                    continue;
                }
                if (kind != VmodlType.Kind.ANY && kind != VmodlType.Kind.DATA_OBJECT && kind != VmodlType.Kind.FAULT && kind != VmodlType.Kind.MOREF && kind != VmodlType.Kind.MANAGED_OBJECT && kind != VmodlType.Kind.ARRAY) {
                    value = String.format("<%1$s xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"%2$s\">%3$s</%1$s>", param.getName(), paramType.getWsdlName(), value);
                } else if (kind == VmodlType.Kind.ARRAY) {
                    value = String.format("<_dummy>%1$s</_dummy>", value);
                }
                Unmarshaller unmarshaller = this._context.createRequestUnmarshaller(this._version);
                try {
                    StringReader reader = new StringReader(value);
                    XMLStreamReader input = XMLInputFactory.newInstance().createXMLStreamReader(reader);
                    if (kind == VmodlType.Kind.ARRAY) {
                        input.nextTag();
                        input.nextTag();
                    }
                    Object paramValue = unmarshaller.unmarshal(param, input);
                    args.add(paramValue);
                }
                catch (Exception e) {
                    if (_logger.isWarnEnabled()) {
                        _logger.warn((Object)String.format("Caught exception parsing argument to param %s The xml was:\n%s", paramName, value));
                    }
                    InvalidArgument ia = new InvalidArgument();
                    ia.setInvalidProperty(paramName);
                    throw ia;
                }
            }
            MethodInvocationFuture future = new MethodInvocationFuture(mObject, moType, managedMethod, this._servletRequest.getParameterMap(), this._responseWriter, mobRenderer, this, this._session.getSessionNonce());
            Object[] argArray = new Object[args.size()];
            args.toArray(argArray);
            this._localClient.invoke(mObject, managedMethod, argArray, this._version, this._session, future);
            return;
        }
        catch (RuntimeFault rf) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"Caught runtime fault", (Throwable)rf);
            }
            error = rf;
        }
        catch (Throwable t) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"Caught unexpected throwable", t);
            }
            SystemError systemError = new SystemError();
            systemError.setReason(t.toString());
            error = systemError;
        }
        this._responseWriter.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>  <head>    <title>      Managed Object Browser    </title><style type=\"text/css\"><!--body {  font-family: Verdana, Arial, Helvetica, sans-serif;  font-size: 12px;  color: #000;  background-color: #fff;  margin-left: 2%;  margin-right: 2%;}a         { color: #036; text-decoration: underline; }a:visited { color: #036;  text-decoration: underline; }a:hover   { color: #3366AA; text-decoration: none; }p.table-title {  font-weight: bold;  margin: 10px 0 5px 5px;}table {  border-collapse:collapse;  border-top: 1px solid #999;  border-left: 1px solid #999;  width: 100%}td, th {  font-size: 12px;  padding: 5px 10px 5px 10px;  border-bottom: 1px solid #999;  border-right: 1px solid #999;  vertical-align: top;}th {  background-color: #555555;  color: #fff;  text-transform: uppercase;  font-size: 10px;  text-align: left;  white-space: nowrap;}tr.title td {  background-color: #F0F8FF;}span.object {       font-size: 150%;}span.property {       font-size: 125%;       padding-left: 1em;}td.c1 {        width: 1%;        text-align: right;       }td.c2 {        width: 1%;        text-align: right;       }span.nav-button {  border-top: 1px solid #999;  border-left: 1px solid #999;  border-right: 1px solid #999;       padding-left: 1em;       padding-right: 1em;       margin-right: 5px;       text-decoration: none;       cursor: pointer;  background-color: #FFF0F0;       color: #036;}span.logout-button {  float: right;  margin-right: 0px;}ul.noindent {       margin-bottom: 0;       margin-left: 1em;}h1 {  font-size: 18px;  font-weight: bold;  color: #3366AA;  margin-bottom: 25px;  padding-bottom: 5px;  border-bottom-width: 1px;  border-bottom-style: dashed;  border-bottom-color: #95a8a6;}input {   font-family:verdana;width:100%;font-size: 12px;}textarea {  font-family:verdana;width:100%;font-size: 12px;}--></style>  </head>  <body><script type=\"text/javascript\">/* <![CDATA[ */function openMethodInvocationWindow(svcName, moId, method, renderVmodl) {  var url = svcName + '/?moid=' + escape(moId) + '&method=' + method;  if (renderVmodl) url += '&vmodl=1';  window.open(url, 'methodInvocation','width=600,height=400,scrollbars=yes,toolbar=yes,resizable=yes');}function invokeMethod() {document.method.submit();}/* ]]> */</script>");
        mobRenderer.renderMethod(mObject, moType, managedMethod, this._servletRequest.getParameterMap(), (Object)error, this._session.getSessionNonce(), this._responseWriter);
        this._responseWriter.print("</body></html>");
        this.returnResponse();
    }

    @Override
    public void run() {
        if (this._servletRequest.getMethod().equals("GET") && this._logoutFinishPath.equals(this._servletRequest.getRequestURI())) {
            this._responseWriter.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>  <head>    <title>      Managed Object Browser    </title><style type=\"text/css\"><!--body {  font-family: Verdana, Arial, Helvetica, sans-serif;  font-size: 12px;  color: #000;  background-color: #fff;  margin-left: 2%;  margin-right: 2%;}a         { color: #036; text-decoration: underline; }a:visited { color: #036;  text-decoration: underline; }a:hover   { color: #3366AA; text-decoration: none; }p.table-title {  font-weight: bold;  margin: 10px 0 5px 5px;}table {  border-collapse:collapse;  border-top: 1px solid #999;  border-left: 1px solid #999;  width: 100%}td, th {  font-size: 12px;  padding: 5px 10px 5px 10px;  border-bottom: 1px solid #999;  border-right: 1px solid #999;  vertical-align: top;}th {  background-color: #555555;  color: #fff;  text-transform: uppercase;  font-size: 10px;  text-align: left;  white-space: nowrap;}tr.title td {  background-color: #F0F8FF;}span.object {       font-size: 150%;}span.property {       font-size: 125%;       padding-left: 1em;}td.c1 {        width: 1%;        text-align: right;       }td.c2 {        width: 1%;        text-align: right;       }span.nav-button {  border-top: 1px solid #999;  border-left: 1px solid #999;  border-right: 1px solid #999;       padding-left: 1em;       padding-right: 1em;       margin-right: 5px;       text-decoration: none;       cursor: pointer;  background-color: #FFF0F0;       color: #036;}span.logout-button {  float: right;  margin-right: 0px;}ul.noindent {       margin-bottom: 0;       margin-left: 1em;}h1 {  font-size: 18px;  font-weight: bold;  color: #3366AA;  margin-bottom: 25px;  padding-bottom: 5px;  border-bottom-width: 1px;  border-bottom-style: dashed;  border-bottom-color: #95a8a6;}input {   font-family:verdana;width:100%;font-size: 12px;}textarea {  font-family:verdana;width:100%;font-size: 12px;}--></style>  </head>  <body><script type=\"text/javascript\">/* <![CDATA[ */function openMethodInvocationWindow(svcName, moId, method, renderVmodl) {  var url = svcName + '/?moid=' + escape(moId) + '&method=' + method;  if (renderVmodl) url += '&vmodl=1';  window.open(url, 'methodInvocation','width=600,height=400,scrollbars=yes,toolbar=yes,resizable=yes');}function invokeMethod() {document.method.submit();}/* ]]> */</script>");
            this._responseWriter.print("<h2>Please close your browser's windows to complete the logout process.</h2><br/>This may be necessary to prevent your browser from keeping login data in memory.");
            this._responseWriter.print("</body></html>");
            this.returnResponse();
            return;
        }
        RequestCredentials credentials = new RequestCredentials(this._servletRequest);
        if (this.authenticate(credentials)) {
            RequestSettings settings = new RequestSettings(this._servletRequest);
            if (this._servletRequest.getMethod().equals("GET")) {
                this.handleGet(settings);
                this.returnResponse();
            } else if (this._servletRequest.getMethod().equals("POST")) {
                this.handlePost(settings);
            } else {
                this._response.setServerFault(501);
                this.returnResponse();
            }
        } else {
            this.returnResponse();
        }
    }
}

