/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.n2r.impl;

import com.ctc.wstx.stax.WstxOutputFactory;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.LocalClient;
import com.vmware.vim.vmomi.server.n2r.Responder;
import com.vmware.vim.vmomi.server.n2r.impl.Request;
import com.vmware.vim.vmomi.server.n2r.impl.Response;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class N2RTask
implements Runnable {
    private final Log _logger = LogFactory.getLog(this.getClass());
    private static final String SESSION_ID = "vmware_soap_session";
    private static final String VMOMI_PROP_HEADER = "X-Vmomi-Prop";
    private static final String N2R_PREFIX = "urn:vmomi:";
    private static final String OBJECT_BEGIN_FORMAT = "<?xml version=\"1.0\" encoding=\"utf-8\"?><%s xmlns=\"urn:%s\" xmlns:qs=\"urn:vmware:queryservice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" qs:id=\"%s\">";
    private static final String OBJECT_END_FORMAT = "</%s>";
    private Request _request;
    private HttpServletRequest _servletRequest;
    private HttpServletResponse _servletResponse;
    private SessionManager _sessionManager;
    private AdapterServer _adapterServer;
    private VmodlVersion _version;
    private LocalClient _localClient;
    private String _serverGUID;
    private Responder _responder;
    private Session _session;
    private Response _response;
    private PrintWriter _responseWriter;
    private VmodlTypeMap _typeMap;
    private Marshaller _marshaller;
    private XMLOutputFactory _xmlOutputFactory;

    public N2RTask(Request request, SessionManager sessionManager, AdapterServer adapterServer, LocalClient localClient, VmodlVersion version, Responder responder) {
        this._request = request;
        this._servletRequest = request.getServletRequest();
        this._servletResponse = request.getServletResponse();
        this._sessionManager = sessionManager;
        this._adapterServer = adapterServer;
        this._localClient = localClient;
        this._version = version;
        this._responder = responder;
        this._serverGUID = adapterServer.getServerGuid();
        this._response = new Response(this._servletResponse);
        this._marshaller = adapterServer.getVmodlContext().createQSMarshaller(this._version);
        this._typeMap = adapterServer.getVmodlContext().getVmodlTypeMap();
        this._xmlOutputFactory = new WstxOutputFactory();
        this._xmlOutputFactory.setProperty("com.ctc.wstx.outputValidateStructure", Boolean.FALSE);
    }

    private static String getSessionCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!SESSION_ID.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private boolean resolveSession() {
        String sessionId = N2RTask.getSessionCookie(this._servletRequest);
        if (sessionId != null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Request session cookie is " + SHA1HashGenerator.generateTruncated((String)sessionId)));
            }
            this._session = this._sessionManager.getSession(sessionId);
            if (this._session == null && this._logger.isWarnEnabled()) {
                this._logger.warn((Object)("Invalid session cookie is " + SHA1HashGenerator.generateTruncated((String)sessionId)));
            }
        } else if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)"No session cookie specified");
        }
        if (this._session == null) {
            this._session = this._sessionManager.createSession();
            if (this._session == null) {
                this._response.setResponseCode(503);
                return false;
            }
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("Created session with id " + SHA1HashGenerator.generateTruncated((String)this._session.getId())));
            }
        }
        return true;
    }

    private String createURI(ManagedObjectReference moRef, ManagedObjectType moType) {
        String guid = this._serverGUID;
        if (moRef.getServerGuid() != null) {
            guid = moRef.getServerGuid();
        }
        return String.format("urn:vmomi:%s:%s:%s", moType.getWsdlName(), moRef.getValue(), guid);
    }

    private boolean writeProperty(ManagedObject mo, ManagedProperty prop) {
        XMLStreamWriter writer;
        Object result;
        BlockingFuture f = new BlockingFuture();
        this._localClient.invoke(mo, prop.getAccessor(), new Object[0], this._version, this._session, (Future)f);
        try {
            result = f.get();
        }
        catch (Exception e) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn((Object)String.format("Exception fetching property %s from object %s", prop.getName(), mo._getRef().getValue()), (Throwable)e);
            }
            return true;
        }
        try {
            writer = this._xmlOutputFactory.createXMLStreamWriter(this._responseWriter);
        }
        catch (XMLStreamException e) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Failed to create XMLStreamWriter", (Throwable)e);
            }
            return false;
        }
        try {
            this._marshaller.marshal((VmodlField)prop, result, writer);
        }
        catch (MarshallException e) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)String.format("Exception marshalling property %s from object %s", prop.getName(), mo._getRef().getValue()), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private ObjectRequestParams parseObjectRequest() {
        String query = this._servletRequest.getQueryString();
        if (!query.startsWith(N2R_PREFIX)) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)("Invalid query: " + query));
            }
            return null;
        }
        String morefUrn = query.replace(N2R_PREFIX, "");
        String[] parsed = morefUrn.split(":");
        if (parsed.length != 3) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)("Invalid query: " + query));
            }
            return null;
        }
        String moId = parsed[1];
        ArrayList<QName> props = new ArrayList<QName>();
        String propString = this._servletRequest.getHeader(VMOMI_PROP_HEADER);
        if (propString != null) {
            StringTokenizer st = new StringTokenizer(propString, ",");
            while (st.hasMoreTokens()) {
                props.add(QName.valueOf(st.nextToken()));
            }
        }
        ObjectRequestParams ret = new ObjectRequestParams();
        ret.moId = moId;
        ret.props = props;
        return ret;
    }

    private void handleGetObject() {
        ObjectRequestParams req = this.parseObjectRequest();
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Processing request for object " + req.moId));
        }
        if (req == null) {
            this._response.setResponseCode(400);
            return;
        }
        ManagedObject mo = this._adapterServer.lookupManagedObject(req.moId);
        if (mo == null) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn((Object)("Failed to find object: " + req.moId));
            }
            this._response.setResponseCode(404);
            return;
        }
        ManagedObjectType moType = (ManagedObjectType)this._typeMap.getDynamicVmodlType((Object)mo);
        this._responseWriter.format(OBJECT_BEGIN_FORMAT, moType.getWsdlName(), this._version.getNamespace(), this.createURI(mo._getRef(), moType));
        if (req.props.size() > 0) {
            for (QName propQName : req.props) {
                ManagedProperty prop = moType.getManagedProperty(propQName.getLocalPart());
                if (prop == null) {
                    if (!this._logger.isWarnEnabled()) continue;
                    this._logger.warn((Object)("Invalid property: " + propQName));
                    continue;
                }
                if (this.writeProperty(mo, prop)) continue;
                this._response.setResponseCode(500);
                return;
            }
        } else {
            for (ManagedProperty prop : moType.getManagedProperties()) {
                if (this.writeProperty(mo, prop)) continue;
                this._response.setResponseCode(500);
                return;
            }
        }
        this._responseWriter.format(OBJECT_END_FORMAT, moType.getWsdlName());
        this._response.setResponseCode(200);
    }

    public void returnResponse() {
        if (this._responseWriter != null) {
            this._responseWriter.flush();
        }
        if (this._session != null) {
            Cookie cookie = new Cookie(SESSION_ID, this._session.getId());
            cookie.setPath(this._request.getServletRequest().getContextPath());
            this._response.getServletResponse().addCookie(cookie);
            this._sessionManager.returnSession(this._session);
        }
        this._responder.returnResponse(this._request, this._response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._responseWriter = this._servletResponse.getWriter();
        }
        catch (IOException e) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Failed to get response writer", (Throwable)e);
            }
            return;
        }
        try {
            if (this.resolveSession()) {
                this._servletResponse.setContentType("text/xml;charset=UTF-8");
                this.handleGetObject();
            } else {
                this._response.setResponseCode(500);
            }
            this.returnResponse();
        }
        finally {
            this._responseWriter.close();
        }
    }

    private static class ObjectRequestParams {
        private String moId;
        private List<QName> props;

        private ObjectRequestParams() {
        }
    }
}

