/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.security.impl;

import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.server.exception.InvalidSignatureException;
import com.vmware.vim.vmomi.server.exception.SignatureValidationException;
import com.vmware.vim.vmomi.server.security.impl.QNameUtil;
import com.vmware.vim.vmomi.server.security.impl.WssElementResolver;
import com.vmware.vim.vmomi.server.security.impl.WssElementResolverImpl;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WsSecurityMessage {
    private static final ThreadLocal<DatatypeFactory> _datatypeFactory = new ThreadLocal<DatatypeFactory>(){

        @Override
        protected DatatypeFactory initialValue() {
            try {
                return DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Document _soapMessage;
    private final Element _securityNode;
    private final Element _tokenNode;
    private final WssElementResolver _elementFinder;
    private final List<X509Certificate> _stsCertificates;
    private final long _clockToleranceSeconds;

    public static WsSecurityMessage findWsSecurityMessage(Document soapMessage, List<X509Certificate> stsCertificates, long clockToleranceSeconds) throws InvalidSignatureException {
        Element token;
        Element security;
        Element root = soapMessage.getDocumentElement();
        Element header = WsSecurityMessage.getOptionalSingleChild(root, Constants.HEADER_QNAME);
        WsSecurityMessage wssMessage = header != null && (security = WsSecurityMessage.getOptionalSingleChild(header, Constants.SECURITY_QNAME)) != null && (token = WsSecurityMessage.getOptionalSingleChild(security, Constants.SAML_ASSERTION_QNAME)) != null ? new WsSecurityMessage(soapMessage, security, token, stsCertificates, clockToleranceSeconds) : null;
        return wssMessage;
    }

    private WsSecurityMessage(Document soapMessage, Element securityNode, Element tokenNode, List<X509Certificate> stsCertificates, long clockToleranceSeconds) {
        assert (soapMessage != null);
        assert (securityNode != null);
        assert (tokenNode != null);
        assert (stsCertificates != null && !stsCertificates.isEmpty());
        assert (clockToleranceSeconds >= 0L);
        this._soapMessage = soapMessage;
        this._securityNode = securityNode;
        this._tokenNode = tokenNode;
        this._elementFinder = new WssElementResolverImpl(soapMessage);
        this._stsCertificates = stsCertificates;
        this._clockToleranceSeconds = clockToleranceSeconds;
    }

    public SamlToken findAuthenticationInfo() throws SignatureValidationException, InvalidSignatureException {
        SamlToken authnToken = this.unmarshalAuthnToken();
        if (authnToken != null && authnToken.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY) {
            Element signature = WsSecurityMessage.getRequiredSingleChild(this._securityNode, Constants.SIGNATURE_QNAME);
            Element timestamp = WsSecurityMessage.getRequiredSingleChild(this._securityNode, Constants.TIMESTAMP_QNAME);
            List<Element> requireSignedElements = Arrays.asList(timestamp, WsSecurityMessage.getRequiredSingleChild(this._soapMessage.getDocumentElement(), Constants.BODY_QNAME));
            this.validateTimestamp(timestamp);
            this.validateSignature(signature, authnToken, requireSignedElements);
        }
        return authnToken;
    }

    private SamlToken unmarshalAuthnToken() throws InvalidSignatureException {
        try {
            return DefaultTokenFactory.createTokenFromDom((Element)this._tokenNode, (X509Certificate[])this._stsCertificates.toArray(new X509Certificate[this._stsCertificates.size()]), (long)this._clockToleranceSeconds);
        }
        catch (InvalidTokenException e) {
            throw new InvalidSignatureException(e);
        }
    }

    private DomSignature unmarshalSignature(Element signatureNode) throws InvalidSignatureException {
        try {
            XMLSignature signature = XMLSignatureFactory.getInstance("DOM").unmarshalXMLSignature(new DOMStructure(signatureNode));
            return new DomSignature(signatureNode, signature);
        }
        catch (MarshalException e) {
            throw new InvalidSignatureException(e);
        }
    }

    private void validateSignature(Element signatureNode, SamlToken authnToken, List<Element> requireSignedElements) throws SignatureValidationException, InvalidSignatureException {
        DomSignature signature = this.unmarshalSignature(signatureNode);
        Collection<Element> referencedElements = this.findSignatureReferences(signature);
        this.validateElementsAreSigned(referencedElements, requireSignedElements);
        this.markElementsWsuIds(referencedElements);
        this.validateSignatureValue(signature, authnToken);
        this.validateSignatureReferencedToken(signature, authnToken);
    }

    private Collection<Element> findSignatureReferences(DomSignature signature) throws InvalidSignatureException {
        List<Reference> references = signature.getSignature().getSignedInfo().getReferences();
        ArrayList<Element> referencedElements = new ArrayList<Element>(references.size());
        for (Reference ref : references) {
            try {
                Element element = this._elementFinder.findElementByReference(ref);
                if (element == null) {
                    throw new InvalidSignatureException(String.format("Elemented pointed by Reference URI `%s' cannot be found", ref.getURI()));
                }
                referencedElements.add(element);
            }
            catch (URIReferenceException e) {
                throw new InvalidSignatureException(e);
            }
        }
        return referencedElements;
    }

    private void validateElementsAreSigned(Collection<Element> referencedElements, List<Element> requireSignedElements) throws InvalidSignatureException {
        for (Element requireSigned : requireSignedElements) {
            boolean isReferenced = false;
            for (Element referencedElement : referencedElements) {
                if (!WsSecurityMessage.elementIsDescendantOf(requireSigned, referencedElement)) continue;
                isReferenced = true;
                break;
            }
            if (isReferenced) continue;
            throw new InvalidSignatureException(String.format("Element `%s' must be signed (but it's not)", QNameUtil.getQName(requireSigned)));
        }
    }

    private void markElementsWsuIds(Collection<Element> elements) {
        String wsuIdNs = Constants.WSU_ID_QNAME.getNamespaceURI();
        String wsuIdLocal = Constants.WSU_ID_QNAME.getLocalPart();
        for (Element elemenet : elements) {
            Attr attr = elemenet.getAttributeNodeNS(wsuIdNs, wsuIdLocal);
            if (attr == null) continue;
            elemenet.setIdAttributeNode(attr, true);
        }
    }

    private void validateSignatureValue(DomSignature signature, SamlToken authnToken) throws InvalidSignatureException, SignatureValidationException {
        DOMValidateContext validationCtx = new DOMValidateContext(authnToken.getConfirmationCertificate().getPublicKey(), (Node)signature.getNode());
        try {
            if (!signature.getSignature().validate(validationCtx)) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"Signature failed core validation");
                    XMLSignature xmlSig = signature.getSignature();
                    this._log.debug((Object)String.format("Signature value: %s", xmlSig.getSignatureValue().validate(validationCtx) ? "valid" : "invalid"));
                    List<Reference> signatureReferences = xmlSig.getSignedInfo().getReferences();
                    for (Reference ref : signatureReferences) {
                        this._log.debug((Object)String.format("Reference to \"%s\": %s", ref.getURI(), ref.validate(validationCtx) ? "valid" : "invalid"));
                    }
                }
                throw new InvalidSignatureException("Invalid request signature.");
            }
        }
        catch (XMLSignatureException e) {
            throw new SignatureValidationException(e);
        }
    }

    private void validateSignatureReferencedToken(DomSignature signature, SamlToken authnToken) throws InvalidSignatureException {
        Element referencedToken;
        Element keyInfo = WsSecurityMessage.getRequiredSingleChild(signature.getNode(), Constants.KEY_INFO_QNAME);
        Element securityTokenRef = WsSecurityMessage.getRequiredSingleChild(keyInfo, Constants.SECURITY_TOKEN_REFERENCE_QNAME);
        String tokenType = QNameUtil.getAttributeByQName(securityTokenRef, Constants.TOKEN_TYPE_QNAME);
        if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType)) {
            throw new InvalidSignatureException(String.format("%s/@%s has invalid value: `%s' (expected: `%s'", Constants.SECURITY_TOKEN_REFERENCE_QNAME.toString(), Constants.TOKEN_TYPE_QNAME.toString(), tokenType, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        }
        Element keyIdentifier = WsSecurityMessage.getRequiredSingleChild(securityTokenRef, Constants.KEY_IDENTIFIER_QNAME);
        String keyValueType = keyIdentifier.getAttribute("ValueType");
        if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(keyValueType)) {
            throw new InvalidSignatureException(String.format("%s/@ValueType has invalid value: `%s' (expected: `%s')", Constants.KEY_IDENTIFIER_QNAME.toString(), keyValueType, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID"));
        }
        String tokenId = WsSecurityMessage.getTextContent(keyIdentifier);
        if (tokenId == null || tokenId.isEmpty()) {
            throw new InvalidSignatureException("Error parsing signature: could not find token identifier.");
        }
        try {
            referencedToken = this._elementFinder.findElementById(tokenId);
        }
        catch (URIReferenceException e) {
            throw new InvalidSignatureException(e);
        }
        if (referencedToken == null || !referencedToken.isSameNode(this._tokenNode)) {
            throw new InvalidSignatureException("The WS-Security signature references unknown token");
        }
    }

    private void validateTimestamp(Element timestamp) throws InvalidSignatureException {
        long now = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault()).getTimeInMillis();
        long clockToleranceMilliSeconds = TimeUnit.SECONDS.toMillis(this._clockToleranceSeconds);
        long createdEffective = this.dateFromContent(WsSecurityMessage.getRequiredSingleChild(timestamp, Constants.TIMESTAMP_CREATED_QNAME)).getTime() - clockToleranceMilliSeconds;
        long expiresEffective = this.dateFromContent(WsSecurityMessage.getRequiredSingleChild(timestamp, Constants.TIMESTAMP_EXPIRES_QNAME)).getTime() + clockToleranceMilliSeconds;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)String.format("Validating message timestamp. Effective created `%s' ; effective expires = `%s' ; now = %s", new Date(createdEffective).toString(), new Date(expiresEffective).toString(), new Date(now).toString()));
        }
        if (now < createdEffective) {
            throw new InvalidSignatureException("Invalid message timestamp: created time is in the future.");
        }
        if (now > expiresEffective) {
            throw new InvalidSignatureException("Expired message timestamp.");
        }
    }

    static Date parseTimestampDate(String tsDate) throws UnmarshallException {
        XMLGregorianCalendar xmlGregorianCalendar;
        try {
            xmlGregorianCalendar = _datatypeFactory.get().newXMLGregorianCalendar(tsDate);
        }
        catch (RuntimeException ex) {
            throw new UnmarshallException(String.format("Invalid date/time format '%1$s'", tsDate), (Throwable)ex);
        }
        int timezoneOffset = xmlGregorianCalendar.getTimezone();
        if (Integer.MIN_VALUE == timezoneOffset) {
            throw new UnmarshallException("Timestamp is missing time zone information: '" + tsDate + "'");
        }
        if (timezoneOffset != 0) {
            throw new UnmarshallException("Timestamp must be in UTC time zone: '" + tsDate + "'");
        }
        GregorianCalendar calendar = xmlGregorianCalendar.toGregorianCalendar();
        return calendar.getTime();
    }

    private Date dateFromContent(Element element) throws InvalidSignatureException {
        try {
            return WsSecurityMessage.parseTimestampDate(WsSecurityMessage.getTextContent(element));
        }
        catch (UnmarshallException e) {
            throw new InvalidSignatureException(String.format("Date format is not valid (in element `%s')", QNameUtil.getQName(element)), e);
        }
    }

    private static boolean elementIsDescendantOf(Element testElement, Element testParent) {
        assert (testElement != null);
        assert (testParent != null);
        for (Node testNode = testElement; testNode != null && testNode.getNodeType() != 9; testNode = testNode.getParentNode()) {
            if (!testNode.isSameNode(testParent)) continue;
            return true;
        }
        return false;
    }

    private static Element getOptionalSingleChild(Element parent, QName childName) throws InvalidSignatureException {
        assert (parent != null);
        assert (childName != null);
        List<Element> nodes = WsSecurityMessage.getChildrenByQName(parent, childName);
        if (nodes.size() > 1) {
            throw new InvalidSignatureException(String.format("Multiple elements of type `%s' found, but only one expected.", childName.toString()));
        }
        return nodes.isEmpty() ? null : nodes.get(0);
    }

    private static Element getRequiredSingleChild(Element parent, QName childName) throws InvalidSignatureException {
        assert (parent != null);
        assert (childName != null);
        Element child = WsSecurityMessage.getOptionalSingleChild(parent, childName);
        if (child == null) {
            throw new InvalidSignatureException(String.format("Required element `%s' was not found at its expected location", childName.toString()));
        }
        return child;
    }

    private static List<Element> getChildrenByQName(Element parent, QName name) {
        assert (parent != null);
        assert (name != null);
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1 || !QNameUtil.getQName(children.item(i)).equals(name)) continue;
            result.add((Element)children.item(i));
        }
        return result;
    }

    private static String getTextContent(Node node) throws InvalidSignatureException {
        assert (node != null);
        NodeList children = node.getChildNodes();
        if (children.getLength() != 1 || children.item(0).getNodeType() != 3) {
            throw new InvalidSignatureException(String.format("Element `%s' is expected to have text-only content", QNameUtil.getQName(node).toString()));
        }
        return children.item(0).getNodeValue();
    }

    private static class DomSignature {
        private final Element _node;
        private final XMLSignature _signature;

        public DomSignature(Element node, XMLSignature signature) {
            this._node = node;
            this._signature = signature;
        }

        public Element getNode() {
            return this._node;
        }

        public XMLSignature getSignature() {
            return this._signature;
        }
    }
}

