/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.util;

import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.util.StringUtil;

public class DataObjectLoggerUtil {
    private DataObjectLoggerUtil() {
    }

    public static void formatField(StringBuilder buffer, VmodlField field, Object object) {
        VmodlType type = field.getType();
        if (type == null) {
            buffer.append("(void)");
            return;
        }
        if (type.getKind() != VmodlType.Kind.DATA_OBJECT && type.getKind() != VmodlType.Kind.ANY && type.getKind() != VmodlType.Kind.ARRAY) {
            buffer.append("(").append(type.getTypeName()).append(") ");
        }
        if (!field.isSecret()) {
            if (object != null && type.getKind() == VmodlType.Kind.ARRAY) {
                VmodlArrayType arrayType = (VmodlArrayType)type;
                buffer.append("(").append(arrayType.getComponentType()).append(") [\n");
                if (object instanceof byte[]) {
                    for (byte o : (byte[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, false);
                    }
                } else if (object instanceof short[]) {
                    for (short o : (short[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, false);
                    }
                } else if (object instanceof int[]) {
                    for (int o : (int[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, false);
                    }
                } else if (object instanceof long[]) {
                    for (long o : (long[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, false);
                    }
                } else if (object instanceof float[]) {
                    for (float o : (float[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, Float.valueOf(o), false);
                    }
                } else if (object instanceof double[]) {
                    for (double o : (double[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, false);
                    }
                } else if (object instanceof boolean[]) {
                    for (boolean o : (boolean[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, false);
                    }
                } else if (object instanceof String[]) {
                    for (String o : (String[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, false);
                    }
                } else {
                    for (Object o : (Object[])object) {
                        DataObjectLoggerUtil.formatArrayElement(buffer, arrayType, o, true);
                    }
                }
                buffer.append("]");
            } else {
                buffer.append(object);
            }
        } else {
            buffer.append("(not shown)");
        }
    }

    private static void formatArrayElement(StringBuilder buffer, VmodlArrayType field, Object object, boolean appendType) {
        buffer.append("   ");
        if (!appendType) {
            buffer.append('(').append(field.getComponentType()).append(')');
        }
        buffer.append(StringUtil.indent((String)object.toString(), (boolean)false)).append('\n');
    }
}

