/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.util;

import com.vmware.vim.vmomi.core.common.LifecycleListener;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GcTimerTask
extends TimerTask
implements LifecycleListener {
    private final Map<String, LastCollectionInfo> _lastGc = new HashMap<String, LastCollectionInfo>();
    private final Log _logger = LogFactory.getLog(GcTimerTask.class);
    private final Timer _timer = new Timer("GCTimer");
    private static final String DEFAULT_LOG_FORMAT = "%1$s -> %2$d(%3$d), %4$d ms";
    private final String _logFormat;
    public static final int MIN_PERIOD = 5;

    public GcTimerTask(int period, String logFormat) {
        if (period <= 5) {
            throw new IllegalArgumentException();
        }
        this._logFormat = logFormat != null ? logFormat : DEFAULT_LOG_FORMAT;
        this._timer.schedule((TimerTask)this, 0L, (long)(period * 1000));
    }

    @Override
    public void run() {
        if (!this._logger.isDebugEnabled()) {
            return;
        }
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gc : gcBeans) {
            LastCollectionInfo last = this.getLast(gc);
            if (!last.checkAndSet(gc.getCollectionCount(), gc.getCollectionTime())) continue;
            this._logger.debug((Object)String.format(this._logFormat, gc.getName(), last.getDeltaCount(), last.getCount(), last.getDeltaTime()));
        }
    }

    private LastCollectionInfo getLast(GarbageCollectorMXBean gc) {
        LastCollectionInfo last = this._lastGc.get(gc.getName());
        if (last == null) {
            last = new LastCollectionInfo(gc.getCollectionCount(), gc.getCollectionTime());
            this._lastGc.put(gc.getName(), last);
        }
        return last;
    }

    public void shutdown() {
        this.shutdownNow();
    }

    public void shutdownNow() {
        this._timer.cancel();
    }

    private class LastCollectionInfo {
        private long _count;
        private long _time;
        private long _deltaCount = 0L;
        private long _deltaTime = 0L;

        public LastCollectionInfo(long count, long time) {
            this._count = count;
            this._time = time;
        }

        boolean checkAndSet(long count, long time) {
            if (this._count != count) {
                this._deltaCount = count - this._count;
                this._deltaTime = time - this._time;
                this._count = count;
                this._time = time;
                return true;
            }
            return false;
        }

        public long getCount() {
            return this._count;
        }

        public long getDeltaCount() {
            return this._deltaCount;
        }

        public long getDeltaTime() {
            return this._deltaTime;
        }
    }
}

