/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.util;

import com.vmware.vim.vmomi.server.common.DiagnosticContextProvider;
import com.vmware.vim.vmomi.server.common.ThreadConfigurator;
import java.util.Map;
import org.apache.log4j.NDC;

public class Log4jNDCThreadConfigurator
implements ThreadConfigurator {
    @Override
    public void before(Runnable r) {
        Map<String, Object> diagnosticContext;
        DiagnosticContextProvider dcp = this.getDiagnosticContext(r);
        if (dcp != null && (diagnosticContext = dcp.getDiagnosticContext()) != null) {
            StringBuilder diagnosticMessage = new StringBuilder();
            for (String key : diagnosticContext.keySet()) {
                if (diagnosticMessage.length() > 0) {
                    diagnosticMessage.append(',');
                }
                diagnosticMessage.append(key);
                diagnosticMessage.append('=');
                diagnosticMessage.append(diagnosticContext.get(key));
            }
            NDC.push((String)diagnosticMessage.toString());
        }
    }

    @Override
    public void after(Runnable r) {
        DiagnosticContextProvider dcp = this.getDiagnosticContext(r);
        if (dcp != null) {
            NDC.remove();
        }
    }

    private DiagnosticContextProvider getDiagnosticContext(Runnable r) {
        if (r instanceof DiagnosticContextProvider) {
            return (DiagnosticContextProvider)((Object)r);
        }
        return null;
    }
}

