/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryMonitor {
    private final Collection<Listener> _listeners = new HashSet<Listener>();
    private static final List<MemoryPoolMXBean> _pools = MemoryMonitor.findPools();
    private static MemoryMonitor _monitor;

    public static synchronized MemoryMonitor getMonitor() {
        if (_monitor == null) {
            _monitor = new MemoryMonitor();
        }
        return _monitor;
    }

    private MemoryMonitor() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        if (!(mbean instanceof NotificationEmitter)) {
            throw new RuntimeException("Unsupported JVM - can not cast MemoryMXBean to NotificationsEmitter");
        }
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification n, Object hb) {
                if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                    for (MemoryPoolMXBean pool : _pools) {
                        if (!pool.isUsageThresholdExceeded()) continue;
                        Collection collection = MemoryMonitor.this._listeners;
                        synchronized (collection) {
                            for (Listener listener : MemoryMonitor.this._listeners) {
                                listener.memoryUsageHigh(pool.getName(), pool.getUsage());
                            }
                        }
                    }
                }
            }
        }, null, null);
    }

    public void setThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        for (MemoryPoolMXBean pool : _pools) {
            long maxMemory = pool.getUsage().getMax();
            long warningThreshold = (long)((double)maxMemory * (percentage / 100.0));
            pool.setUsageThreshold(warningThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(Listener listener) {
        Collection<Listener> collection = this._listeners;
        synchronized (collection) {
            return this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Listener listener) {
        Collection<Listener> collection = this._listeners;
        synchronized (collection) {
            return this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeners(Collection<Listener> listeners) {
        Collection<Listener> collection = this._listeners;
        synchronized (collection) {
            this._listeners.clear();
            if (listeners != null) {
                this._listeners.addAll(listeners);
            }
        }
    }

    private static List<MemoryPoolMXBean> findPools() {
        ArrayList<MemoryPoolMXBean> result = new ArrayList<MemoryPoolMXBean>();
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!pool.isUsageThresholdSupported()) continue;
            result.add(pool);
        }
        return result;
    }

    public static interface Listener {
        public void memoryUsageHigh(String var1, MemoryUsage var2);
    }
}

