/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.util;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationValidator;
import java.util.ArrayList;
import java.util.List;

public class SyncActivationValidator
implements ActivationValidator {
    private List<Validator> _validators;

    public SyncActivationValidator(List<Validator> validators) {
        if (validators == null) {
            throw new IllegalArgumentException("validators should not be null");
        }
        this._validators = validators;
    }

    public SyncActivationValidator() {
        this(new ArrayList<Validator>());
    }

    public void addValidator(Validator validator) {
        this._validators.add(validator);
    }

    public void setValidators(List<Validator> validators) {
        if (validators == null) {
            throw new IllegalArgumentException("validators should not be null");
        }
        this._validators = validators;
    }

    public List<Validator> getValidators() {
        return this._validators;
    }

    @Override
    public void validate(Activation activation, ActivationValidator.Future future) {
        for (Validator validator : this._validators) {
            Exception e;
            if (validator == null || (e = validator.validate(activation)) == null) continue;
            future.setFault(e);
            return;
        }
        future.setValid();
    }

    static class BlockingValidatorFuture
    implements ActivationValidator.Future {
        private boolean _isSet;
        private Exception _fault;

        BlockingValidatorFuture() {
        }

        @Override
        public Exception getFault() {
            this.awaitCompletion();
            return this._fault;
        }

        @Override
        public boolean isValid() {
            this.awaitCompletion();
            return this._fault == null;
        }

        @Override
        public void setFault(Exception fault) {
            if (fault == null) {
                throw new IllegalArgumentException("fault must not be null");
            }
            this.doSet(fault);
        }

        @Override
        public void setValid() {
            this.doSet(null);
        }

        private synchronized void doSet(Exception fault) {
            if (this._isSet) {
                throw new IllegalStateException("Future is already set");
            }
            this._isSet = true;
            this._fault = fault;
            this.notify();
        }

        private synchronized void awaitCompletion() {
            while (!this._isSet) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class ActivationValidatorAdapter
    implements Validator {
        ActivationValidator _activationValidator;

        public ActivationValidatorAdapter(ActivationValidator activationValidator) {
            this._activationValidator = activationValidator;
        }

        @Override
        public Exception validate(Activation activation) {
            BlockingValidatorFuture future = new BlockingValidatorFuture();
            this._activationValidator.validate(activation, future);
            return future.getFault();
        }
    }

    public static interface Validator {
        public Exception validate(Activation var1);
    }
}

