/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.common.api.filters.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.QueryFilterRegistry;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.common.api.filters.exceptions.DuplicatedFilterIdException;
import com.vmware.vise.common.api.filters.exceptions.QueryFilterNotFoundException;
import com.vmware.vise.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryFilterRegistryImpl
implements QueryFilterRegistry {
    private static final Log _logger = LogFactory.getLog(QueryFilterRegistryImpl.class);
    private Map<String, Pair<QueryFilterBuilder, Method>> _builderMap = new HashMap<String, Pair<QueryFilterBuilder, Method>>();

    @Override
    public synchronized Filter get(String string, Object ... objectArray) {
        Pair<QueryFilterBuilder, Method> pair = this._builderMap.get(string);
        if (pair == null) {
            throw new QueryFilterNotFoundException(string);
        }
        try {
            return (Filter)((Method)pair.second).invoke(pair.first, objectArray);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            _logger.error((Object)reflectiveOperationException);
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Override
    public synchronized void registerFilterBuilder(QueryFilterBuilder queryFilterBuilder) {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        for (Method method : queryFilterBuilder.getClass().getDeclaredMethods()) {
            QueryFilter queryFilter = method.getAnnotation(QueryFilter.class);
            if (queryFilter == null) continue;
            String string = queryFilter.value();
            if (this._builderMap.containsKey(string) || hashMap.containsKey(string)) {
                hashSet.add(string);
                continue;
            }
            hashMap.put(string, new Pair((Object)queryFilterBuilder, (Object)method));
        }
        if (!hashSet.isEmpty()) {
            _logger.error((Object)String.format("Duplicated filter ids found: %s", hashSet));
            throw new DuplicatedFilterIdException(hashSet);
        }
        this._builderMap.putAll(hashMap);
    }

    @Override
    public synchronized void unregisterFilterBuilder(QueryFilterBuilder queryFilterBuilder) {
        for (Method method : queryFilterBuilder.getClass().getDeclaredMethods()) {
            QueryFilter queryFilter = method.getAnnotation(QueryFilter.class);
            if (queryFilter == null) continue;
            this._builderMap.remove(queryFilter.value());
        }
    }
}

