/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.sso;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public class CertificateGenerator {
    public static final String KEY_ALG = "RSA";
    public static final int KEY_BITS = 2048;
    public static final String SIG_ALG = "SHA256WithRSA";
    private static final Random RANDOM = new Random();
    private static final long signMask = Long.MAX_VALUE;

    public static CertificateAndPrivateKey generateCertificate(String ownerDn, int validDays) throws CertificateGenerationException {
        return CertificateGenerator.generateCertificate(ownerDn, new Date(), validDays);
    }

    public static CertificateAndPrivateKey generateCertificate(String ownerDn, Date startDate, int validDays) throws CertificateGenerationException {
        Builder b = new Builder(ownerDn);
        b.setLifetimeInterval(startDate, validDays);
        return b.generateCertificate();
    }

    public static class Builder {
        private final X509V3CertificateGenerator _certGen;
        private final KeyPair _keyPair;
        private ASN1EncodableVector _subjectAltNames;
        private boolean _addSubjectKeyIdentifier;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder(String ownerDn) throws CertificateGenerationException {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                this._certGen = new X509V3CertificateGenerator();
                KeyPairGenerator kpGen = KeyPairGenerator.getInstance(CertificateGenerator.KEY_ALG, "BC");
                kpGen.initialize(2048);
                this._keyPair = kpGen.generateKeyPair();
                this._subjectAltNames = new ASN1EncodableVector();
                this._addSubjectKeyIdentifier = false;
                X500Principal x500Principal = new X500Principal(ownerDn);
                Random random = RANDOM;
                synchronized (random) {
                    this._certGen.setSerialNumber(BigInteger.valueOf(RANDOM.nextLong() & Long.MAX_VALUE));
                }
                this._certGen.setIssuerDN(x500Principal);
                this._certGen.setSubjectDN(x500Principal);
                this._certGen.setPublicKey(this._keyPair.getPublic());
                this._certGen.setSignatureAlgorithm(CertificateGenerator.SIG_ALG);
                this.setLifetimeIntervalImpl(new Date(), 1);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CertificateGenerationException(e);
            }
        }

        public void setLifetimeInterval(int validDays) {
            this.setLifetimeIntervalImpl(new Date(), validDays);
        }

        public void setLifetimeInterval(Date startDate, int validDays) {
            this.setLifetimeIntervalImpl(startDate, validDays);
        }

        private void setLifetimeIntervalImpl(Date startDate, int validDays) {
            long validSeconds = (long)validDays * 24L * 60L * 60L;
            Date endDate = new Date();
            endDate.setTime(startDate.getTime() + validSeconds * 1000L);
            this._certGen.setNotBefore(new Date(startDate.getTime()));
            this._certGen.setNotAfter(endDate);
        }

        public void addDnsName(String dnsName) {
            this._subjectAltNames.add((DEREncodable)new GeneralName(2, dnsName));
        }

        public void addIpAddress(String ipAddress) {
            try {
                InetAddress address = InetAddress.getByName(ipAddress);
                this._subjectAltNames.add((DEREncodable)new GeneralName(7, (ASN1Encodable)new DEROctetString(address.getAddress())));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public void addSubjectKeyIdentifier() {
            this._addSubjectKeyIdentifier = true;
        }

        public CertificateAndPrivateKey generateCertificate() throws CertificateGenerationException {
            try {
                if (this._subjectAltNames.size() > 0) {
                    GeneralNames sanGeneralNames = new GeneralNames((ASN1Sequence)new DERSequence((DEREncodableVector)this._subjectAltNames));
                    this._certGen.addExtension(X509Extensions.SubjectAlternativeName, false, (DEREncodable)sanGeneralNames);
                }
                if (this._addSubjectKeyIdentifier) {
                    this._certGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(this._keyPair.getPublic()));
                }
                X509Certificate cert = this._certGen.generate(this._keyPair.getPrivate(), "BC");
                return new CertificateAndPrivateKey(cert, this._keyPair.getPrivate());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CertificateGenerationException(e);
            }
        }
    }

    public static class CertificateAndPrivateKey {
        private final X509Certificate _certificate;
        private final PrivateKey _privateKey;

        public X509Certificate getCertificate() {
            return this._certificate;
        }

        public PrivateKey getPrivateKey() {
            return this._privateKey;
        }

        public CertificateAndPrivateKey(X509Certificate cert, PrivateKey key) {
            this._certificate = cert;
            this._privateKey = key;
        }
    }

    public static class CertificateGenerationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CertificateGenerationException(Throwable cause) {
            super(cause);
        }
    }
}

