/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.sso;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStoreHelper {
    private static final String[] KEYSTORE_TYPES = new String[]{"JKS", "PKCS12"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String fileName, char[] password, String type) throws KeyStoreHelperException {
        FileInputStream in = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            in = new FileInputStream(fileName);
            try {
                keyStore.load(in, password);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return keyStore;
        }
        catch (FileNotFoundException e) {
            throw new KeyStoreHelperException(e);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreHelperException(e);
        }
        catch (CertificateException e) {
            throw new KeyStoreHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreHelperException(e);
        }
        catch (IOException e) {
            throw new KeyStoreHelperException(e);
        }
    }

    public static KeyStore loadKeyStore(String fileName, char[] password) throws KeyStoreHelperException {
        Object ret = null;
        KeyStoreHelperException firstException = null;
        for (String type : KEYSTORE_TYPES) {
            try {
                return KeyStoreHelper.loadKeyStore(fileName, password, type);
            }
            catch (KeyStoreHelperException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        throw firstException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeKeyStore(String fileName, char[] password, KeyStore keyStore) throws KeyStoreHelperException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            try {
                keyStore.store(out, password);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new KeyStoreHelperException(e);
        }
    }

    public static class KeyStoreHelperException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private KeyStoreHelperException(Throwable cause) {
            super(cause);
        }

        private KeyStoreHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        private KeyStoreHelperException(String message) {
            super(message);
        }

        private KeyStoreHelperException() {
        }
    }
}

