/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.util.impl;

import com.vmware.cis.common.util.DiskSpaceCheck;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskSpaceCheckImpl
implements DiskSpaceCheck {
    private static final String osName = System.getProperty("os.name");
    private static final Log _log = LogFactory.getLog(DiskSpaceCheckImpl.class);

    @Override
    public List<Float> getUsedPercentage(List<String> files) {
        LinkedList<Float> ll = new LinkedList<Float>();
        for (String file : files) {
            ll.add(Float.valueOf(this.getUsedPercentage(file)));
        }
        return ll;
    }

    @Override
    public float getUsedPercentage(String file) {
        float usedSpacePercentage;
        block10: {
            usedSpacePercentage = -1.0f;
            if (osName.equals("Linux")) {
                String[] command = new String[]{"/bin/sh", "-c", "df -h " + file + " | grep -vE '^Filesystem|tmpfs|/dev/loop0' | awk '{ print $5 }' | cut -d'%' -f1 "};
                try {
                    Process findspace = Runtime.getRuntime().exec(command);
                    BufferedReader resultset = new BufferedReader(new InputStreamReader(findspace.getInputStream()));
                    String str = resultset.readLine();
                    usedSpacePercentage = Float.valueOf(str.trim()).floatValue();
                }
                catch (IOException e) {
                    if (_log.isErrorEnabled()) {
                        _log.error((Object)"File cannot be read", (Throwable)e);
                    }
                    break block10;
                }
                catch (Exception e) {
                    if (_log.isErrorEnabled()) {
                        _log.error((Object)("Cannot read the parition/drive " + file), (Throwable)e);
                    }
                    break block10;
                }
            }
            if (osName.matches("Windows.*")) {
                try {
                    File dir = new File(file);
                    if (dir.exists()) {
                        float totalSpace = dir.getTotalSpace();
                        float freeSpace = dir.getUsableSpace();
                        usedSpacePercentage = (totalSpace - freeSpace) * 100.0f / totalSpace;
                    }
                }
                catch (Exception e) {
                    if (!_log.isErrorEnabled()) break block10;
                    _log.error((Object)("Cannot read the parition/drive " + file), (Throwable)e);
                }
            }
        }
        return usedSpacePercentage;
    }
}

