/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.client.transport.vapi;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.ImmutableChangeEvent;
import com.vmware.cdc.internal.ImmutableChangeList;
import com.vmware.cdc.transport.vapi.ChangeLogTypes;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.Unauthorized;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VapiChangeLogProxy
implements ChangeLog {
    private static final Logger _logger = LoggerFactory.getLogger(VapiChangeLogProxy.class);
    private static final String DUMMY_SEQUENCE = "0";
    private static final ChangeList EMPTY_CHANGE_LIST = new ImmutableChangeList("0", Collections.emptyList());
    private final com.vmware.cdc.transport.vapi.ChangeLog _stub;

    public VapiChangeLogProxy(ApiProvider vapiProvider) {
        assert (vapiProvider != null);
        this._stub = VapiChangeLogProxy.createStub(vapiProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static com.vmware.cdc.transport.vapi.ChangeLog createStub(ApiProvider vapiProvider) {
        StubFactory stubFactory = new StubFactory(vapiProvider);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(com.vmware.cdc.transport.vapi.ChangeLog.class.getClassLoader());
        try {
            com.vmware.cdc.transport.vapi.ChangeLog changeLog = (com.vmware.cdc.transport.vapi.ChangeLog)stubFactory.createStub(com.vmware.cdc.transport.vapi.ChangeLog.class);
            return changeLog;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    @Override
    public String getCurrentSequence() {
        try {
            return this._stub.getCurrentSequence();
        }
        catch (Unauthorized e) {
            _logger.debug("Return dummy change sequence because user is unauthorized");
            return DUMMY_SEQUENCE;
        }
    }

    @Override
    public ChangeList getChanges(String sequenceToken) throws SequenceExpiredException {
        try {
            ChangeLogTypes.ChangeList changes = this._stub.getChanges(sequenceToken);
            return VapiChangeLogProxy.toCoreChangeList(changes);
        }
        catch (InvalidArgument e) {
            String msg = "Invalid token '{}' used, will signal SequenceExpiredException: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Object)sequenceToken, (Object)e);
            } else {
                _logger.warn(msg + e.getMessage(), (Object)sequenceToken);
            }
            throw new SequenceExpiredException(sequenceToken);
        }
        catch (Unauthorized e) {
            _logger.debug("Return empty change list because user is unauthorized");
            return EMPTY_CHANGE_LIST;
        }
    }

    private static ChangeList toCoreChangeList(ChangeLogTypes.ChangeList changeList) {
        assert (changeList != null);
        ArrayList<ChangeEvent> coreChanges = new ArrayList<ChangeEvent>(changeList.getChanges().size());
        for (ChangeLogTypes.ChangeEvent changeEvent : changeList.getChanges()) {
            ChangeEvent coreChangeEvent = VapiChangeLogProxy.toCoreChangeEvent(changeEvent);
            coreChanges.add(coreChangeEvent);
        }
        ImmutableChangeList coreChangeList = new ImmutableChangeList(changeList.getSequence(), coreChanges);
        return coreChangeList;
    }

    private static ChangeEvent toCoreChangeEvent(ChangeLogTypes.ChangeEvent changeEvent) {
        assert (changeEvent != null);
        ChangeEvent.ChangeKind changeKind = VapiChangeLogProxy.toCoreChangeKind(changeEvent.getKind());
        DynamicID vapiId = changeEvent.getResource();
        ImmutableChangeEvent coreChangeEvent = new ImmutableChangeEvent(changeKind, vapiId.getId(), vapiId.getType(), changeEvent.getProperties());
        return coreChangeEvent;
    }

    private static ChangeEvent.ChangeKind toCoreChangeKind(ChangeLogTypes.ChangeEvent.ChangeKind changeKind) {
        assert (changeKind != null);
        switch (changeKind.getEnumValue()) {
            case CREATE: {
                return ChangeEvent.ChangeKind.CREATE;
            }
            case DELETE: {
                return ChangeEvent.ChangeKind.DELETE;
            }
            case UPDATE: {
                return ChangeEvent.ChangeKind.UPDATE;
            }
        }
        throw new IllegalArgumentException("Unsupported change kind: " + (Object)((Object)changeKind.getEnumValue()));
    }
}

