/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter;

import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.cdc.vcenter.ResourceChange;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class ChangeSet {
    private final String _sequenceToken;
    private final List<ResourceChange> _resourceChanges;
    private final List<AlarmChange> _alarmChanges;

    public ChangeSet(String sequenceToken, List<ResourceChange> resourceChanges, List<AlarmChange> alarmChanges) {
        assert (sequenceToken != null);
        assert (resourceChanges != null);
        assert (alarmChanges != null);
        this._sequenceToken = sequenceToken;
        this._resourceChanges = Collections.unmodifiableList(resourceChanges);
        this._alarmChanges = Collections.unmodifiableList(alarmChanges);
    }

    public String getSequence() {
        return this._sequenceToken;
    }

    public List<ResourceChange> getResourceChanges() {
        return this._resourceChanges;
    }

    public List<AlarmChange> getAlarmChanges() {
        return this._alarmChanges;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[\n" + "   _sequenceToken = " + this._sequenceToken + ",\n   " + "   _resourceChanges = " + StringUtils.join(this._resourceChanges, (String)",\n   ") + "   _alarmChanges = " + StringUtils.join(this._alarmChanges, (String)"\n   ") + "\n]";
    }
}

