/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.client.transport.vapi;

import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.ChangeSet;
import com.vmware.cdc.transport.vapi.ChangeLog;
import com.vmware.cdc.transport.vapi.ChangeLogTypes;
import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.cdc.vcenter.listener.vapi.VapiServiceStubFactory;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.Unauthorized;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VapiChangeLogCollectorProxy
implements ChangeLogCollector {
    private static final Logger _logger = LoggerFactory.getLogger(VapiChangeLogCollectorProxy.class);
    private static final String DUMMY_SEQUENCE = "0";
    private static final ChangeSet EMPTY_CHANGE_SET = new ChangeSet("0", Collections.emptyList(), Collections.emptyList());
    private final ChangeLog _stub;

    public VapiChangeLogCollectorProxy(VapiServiceStubFactory vapiServiceStubFactory) {
        assert (vapiServiceStubFactory != null);
        this._stub = vapiServiceStubFactory.createServiceStub(ChangeLog.class);
    }

    @Override
    public String initializeSequence(ChangeLogCollector.ChangeLog[] changeLogs) {
        try {
            return this._stub.getCurrentSequence();
        }
        catch (Unauthorized e) {
            _logger.debug("Return dummy change sequence because user is unauthorized");
            return DUMMY_SEQUENCE;
        }
    }

    @Override
    public String exchangeSequence(String sequenceToken, ChangeLogCollector.ChangeLog[] add, ChangeLogCollector.ChangeLog[] remove) {
        return sequenceToken;
    }

    @Override
    public ChangeSet waitForChanges(String sequenceToken) throws SequenceExpiredException {
        try {
            ChangeLogTypes.ChangeList changes = this._stub.getChanges(sequenceToken);
            return VapiChangeLogCollectorProxy.toChangeSet(changes);
        }
        catch (InvalidArgument e) {
            String msg = "Invalid token '{}' used, will signal SequenceExpiredException: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Object)sequenceToken, (Object)e);
            } else {
                _logger.warn(msg + e.getMessage(), (Object)sequenceToken);
            }
            throw new SequenceExpiredException(sequenceToken);
        }
        catch (Unauthorized e) {
            _logger.debug("Return empty change set because user is unauthorized");
            return EMPTY_CHANGE_SET;
        }
    }

    private static ChangeSet toChangeSet(ChangeLogTypes.ChangeList changeList) {
        assert (changeList != null);
        ArrayList<ResourceChange> resourceChanges = new ArrayList<ResourceChange>(changeList.getChanges().size());
        for (ChangeLogTypes.ChangeEvent changeEvent : changeList.getChanges()) {
            ResourceChange resourceChange = VapiChangeLogCollectorProxy.toResourceChange(changeEvent);
            resourceChanges.add(resourceChange);
        }
        return new ChangeSet(changeList.getSequence(), resourceChanges, Collections.emptyList());
    }

    private static ResourceChange toResourceChange(ChangeLogTypes.ChangeEvent changeEvent) {
        ResourceChange.Kind kind;
        assert (changeEvent != null);
        switch (changeEvent.getKind().getEnumValue()) {
            case CREATE: {
                kind = ResourceChange.Kind.CREATE;
                break;
            }
            case UPDATE: {
                kind = ResourceChange.Kind.UPDATE;
                break;
            }
            case DELETE: {
                kind = ResourceChange.Kind.DELETE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported resource change kind: " + (Object)((Object)changeEvent.getKind().getEnumValue()));
            }
        }
        DynamicID resourceId = changeEvent.getResource();
        return new ResourceChange(kind, resourceId.getId(), resourceId.getType(), changeEvent.getProperties());
    }
}

