/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.client.transport.vmomi;

import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.ChangeSet;
import com.vmware.cdc.internal.vcenter.exception.WaitForChangesCanceledException;
import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.cdc.vcenter.listener.vmomi.VmomiServiceStubFactory;
import com.vmware.vim.binding.vim.cdc.AlarmChange;
import com.vmware.vim.binding.vim.cdc.InventoryChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.RequestCanceled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VmomiChangeLogCollectorProxy
implements ChangeLogCollector {
    private static final Logger _logger = LoggerFactory.getLogger(VmomiChangeLogCollectorProxy.class);
    private static final String CHANGE_LOG_COLLECTOR_TYPE_NAME = "CDCChangeLogCollector";
    private static final String CHANGE_LOG_COLLECTOR_MO_NAME = "ChangeLogCollector";
    private final com.vmware.vim.binding.vim.cdc.ChangeLogCollector _stub;

    public VmomiChangeLogCollectorProxy(VmomiServiceStubFactory vmomiServiceStubFactory) {
        assert (vmomiServiceStubFactory != null);
        ManagedObjectReference moRef = new ManagedObjectReference(CHANGE_LOG_COLLECTOR_TYPE_NAME, CHANGE_LOG_COLLECTOR_MO_NAME, null);
        this._stub = vmomiServiceStubFactory.createServiceStub(com.vmware.vim.binding.vim.cdc.ChangeLogCollector.class, moRef);
    }

    @Override
    public String initializeSequence(ChangeLogCollector.ChangeLog[] changeLogs) {
        ChangeLogCollector.ChangeLog[] changeLogArray;
        assert (changeLogs == null || changeLogs.length > 0);
        if (changeLogs != null) {
            changeLogArray = changeLogs;
        } else {
            ChangeLogCollector.ChangeLog[] changeLogArray2 = new ChangeLogCollector.ChangeLog[2];
            changeLogArray2[0] = ChangeLogCollector.ChangeLog.RESOURCE;
            changeLogArray = changeLogArray2;
            changeLogArray2[1] = ChangeLogCollector.ChangeLog.ALARM_STATUS;
        }
        ChangeLogCollector.ChangeLog[] changeLogEnums = changeLogArray;
        Object[] changeLogNames = new String[changeLogEnums.length];
        for (int i = 0; i < changeLogEnums.length; ++i) {
            changeLogNames[i] = changeLogEnums[i].value();
        }
        try {
            return this._stub.initializeSequence((String[])changeLogNames);
        }
        catch (InvalidArgument e) {
            throw new IllegalArgumentException(String.format("Invalid change log names provided [%s]", Arrays.toString(changeLogNames)));
        }
    }

    @Override
    public String exchangeSequence(String sequenceToken, ChangeLogCollector.ChangeLog[] add, ChangeLogCollector.ChangeLog[] remove) {
        Object[] changeLogsToAdd = null;
        if (add != null && add.length > 0) {
            changeLogsToAdd = new String[add.length];
            for (int i = 0; i < add.length; ++i) {
                changeLogsToAdd[i] = add[i].value();
            }
        }
        Object[] changeLogsToRemove = null;
        if (remove != null && remove.length > 0) {
            changeLogsToRemove = new String[remove.length];
            for (int i = 0; i < remove.length; ++i) {
                changeLogsToRemove[i] = remove[i].value();
            }
        }
        try {
            return this._stub.exchangeSequence(sequenceToken, (String[])changeLogsToAdd, (String[])changeLogsToRemove);
        }
        catch (InvalidArgument e) {
            throw new IllegalArgumentException(String.format("Invalid change log names provided [%s, %s]", Arrays.toString(changeLogsToAdd), Arrays.toString(changeLogsToRemove)));
        }
    }

    @Override
    public ChangeSet waitForChanges(String sequenceToken) throws SequenceExpiredException, WaitForChangesCanceledException {
        try {
            com.vmware.vim.binding.vim.cdc.ChangeSet vmodlChangeSet = this._stub.waitForChanges(sequenceToken);
            return this.convertFromBinding(vmodlChangeSet);
        }
        catch (InvalidArgument e) {
            String msg = "Invalid token '{}' used, will signal SequenceExpiredException: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Object)sequenceToken, (Object)e);
            } else {
                _logger.warn(msg + e.getMessage(), (Object)sequenceToken);
            }
            throw new SequenceExpiredException(sequenceToken);
        }
        catch (RequestCanceled e) {
            throw new WaitForChangesCanceledException(sequenceToken);
        }
    }

    private ChangeSet convertFromBinding(com.vmware.vim.binding.vim.cdc.ChangeSet vmodlChangeSet) {
        List<AlarmChange> alarmChanges;
        List<ResourceChange> resourceChanges;
        if (vmodlChangeSet.inventoryChanges == null) {
            resourceChanges = Collections.emptyList();
        } else {
            resourceChanges = new ArrayList(vmodlChangeSet.inventoryChanges.length);
            for (InventoryChange vmodlInventoryChange : vmodlChangeSet.inventoryChanges) {
                ResourceChange resourceChange = this.convertFromBinding(vmodlInventoryChange);
                resourceChanges.add(resourceChange);
            }
        }
        if (vmodlChangeSet.alarmChanges == null) {
            alarmChanges = Collections.emptyList();
        } else {
            alarmChanges = new ArrayList(vmodlChangeSet.alarmChanges.length);
            for (com.vmware.vim.binding.vim.cdc.AlarmChange vmodlAlarmChange : vmodlChangeSet.alarmChanges) {
                AlarmChange alarmChange = this.convertFromBinding(vmodlAlarmChange);
                alarmChanges.add(alarmChange);
            }
        }
        return new ChangeSet(vmodlChangeSet.sequence, resourceChanges, alarmChanges);
    }

    private ResourceChange convertFromBinding(InventoryChange vmodlInventoryChange) {
        ResourceChange.Kind kind;
        if (InventoryChange.Kind.created.name().equals(vmodlInventoryChange.kind)) {
            kind = ResourceChange.Kind.CREATE;
        } else if (InventoryChange.Kind.updated.name().equals(vmodlInventoryChange.kind)) {
            kind = ResourceChange.Kind.UPDATE;
        } else if (InventoryChange.Kind.deleted.name().equals(vmodlInventoryChange.kind)) {
            kind = ResourceChange.Kind.DELETE;
        } else {
            throw new IllegalArgumentException("Unsupported resource change kind: " + vmodlInventoryChange.kind);
        }
        ManagedObjectReference resourceId = vmodlInventoryChange.object;
        List<String> properties = ArrayUtils.isEmpty((Object[])vmodlInventoryChange.properties) ? null : Arrays.asList(vmodlInventoryChange.properties);
        return new ResourceChange(kind, resourceId, resourceId.getType(), properties);
    }

    private AlarmChange convertFromBinding(com.vmware.vim.binding.vim.cdc.AlarmChange vmodlAlarmChange) {
        AlarmChange.Kind kind;
        String overallStatus = vmodlAlarmChange.overallStatus.name();
        Calendar time = vmodlAlarmChange.time;
        Integer eventKey = vmodlAlarmChange.eventKey;
        String acknowledgedByUser = null;
        Calendar acknowledgedTime = null;
        if (AlarmChange.Kind.triggered.name().equals(vmodlAlarmChange.kind)) {
            kind = AlarmChange.Kind.TRIGGER;
        } else if (AlarmChange.Kind.retriggered.name().equals(vmodlAlarmChange.kind)) {
            kind = AlarmChange.Kind.RETRIGGER;
        } else if (AlarmChange.Kind.acknowledged.name().equals(vmodlAlarmChange.kind)) {
            kind = AlarmChange.Kind.ACKNOWLEDGE;
            acknowledgedByUser = vmodlAlarmChange.acknowledgedByUser;
            acknowledgedTime = vmodlAlarmChange.acknowledgedTime;
        } else if (AlarmChange.Kind.cleared.name().equals(vmodlAlarmChange.kind)) {
            kind = AlarmChange.Kind.CLEAR;
            overallStatus = null;
            time = null;
            eventKey = null;
        } else {
            throw new IllegalArgumentException("Unsupported alarm change kind: " + vmodlAlarmChange.kind);
        }
        return new AlarmChange(kind, vmodlAlarmChange.entity, vmodlAlarmChange.alarm, overallStatus, time, eventKey, acknowledgedByUser, acknowledgedTime);
    }
}

