/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.listener;

import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.ChangeSet;
import com.vmware.cdc.internal.vcenter.listener.ListenerSpec;
import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChangeDemultiplexer {
    private static final Logger _logger = LoggerFactory.getLogger(ChangeDemultiplexer.class);
    private final ChangeNotifier _changeNotifier;
    private final ResourceChangeListener _resourceChangeListener;
    private final AlarmChangeListener _alarmChangeListener;

    ChangeDemultiplexer(ChangeNotifier changeNotifier, ListenerSpec listenerSpec) {
        this(changeNotifier, listenerSpec.getResourceChangeListenerToAdd(), listenerSpec.getAlarmChangeListenerToAdd());
        if (listenerSpec.getResourceChangeListenerToRemove() != null) {
            throw new IllegalArgumentException("Not possible to remove a ResourceChangeListener during initial subscription.");
        }
        if (listenerSpec.getAlarmChangeListenerToRemove() != null) {
            throw new IllegalArgumentException("Not possible to remove an AlarmChangeListener during initial subscription.");
        }
    }

    private ChangeDemultiplexer(ChangeNotifier changeNotifier, ResourceChangeListener resourceChangeListener, AlarmChangeListener alarmChangeListener) {
        assert (changeNotifier != null);
        assert (resourceChangeListener != null || alarmChangeListener != null) : "Should provide at least one change listener";
        this._changeNotifier = changeNotifier;
        this._resourceChangeListener = resourceChangeListener;
        this._alarmChangeListener = alarmChangeListener;
    }

    void notifyForChanges(ChangeSet changeSet) {
        assert (changeSet != null);
        this.notifyForResourceChanges(changeSet.getResourceChanges());
        this.notifyForAlarmChanges(changeSet.getAlarmChanges());
    }

    void notifyFatalError(IllegalStateException error) {
        assert (error != null);
        if (this._resourceChangeListener != null) {
            try {
                this._resourceChangeListener.onError(this._changeNotifier, error);
            }
            catch (RuntimeException e) {
                _logger.error("Error while notifying '{}' for error: {}", (Object)this._resourceChangeListener, (Object)e);
            }
        }
        if (this._alarmChangeListener != null) {
            try {
                this._alarmChangeListener.onError(this._changeNotifier, error);
            }
            catch (RuntimeException e) {
                _logger.error("Error while notifying '{}' for error: {}", (Object)this._alarmChangeListener, (Object)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ChangeDemultiplexer exchangeDemultiplexer(ListenerSpec listenerSpec) {
        assert (listenerSpec != null);
        ResourceChangeListener resourceChangeListener = this._resourceChangeListener;
        AlarmChangeListener alarmChangeListener = this._alarmChangeListener;
        ResourceChangeListener resourceChangeListenerToAdd = listenerSpec.getResourceChangeListenerToAdd();
        ResourceChangeListener resourceChangeListenerToRemove = listenerSpec.getResourceChangeListenerToRemove();
        assert (resourceChangeListenerToAdd == null || resourceChangeListenerToRemove == null) : "Not possible to both add and remove a ResourceChangeListener";
        if (resourceChangeListenerToRemove != null) {
            if (!resourceChangeListenerToRemove.equals(resourceChangeListener)) throw new IllegalArgumentException("Trying to remove a ResourceChangeListener which is not previously registered.");
            resourceChangeListener = null;
        } else if (resourceChangeListenerToAdd != null) {
            if (resourceChangeListener != null) {
                throw new IllegalArgumentException("Only one ResourceChangeListener allowed to be added.");
            }
            resourceChangeListener = resourceChangeListenerToAdd;
        }
        AlarmChangeListener alarmChangeListenerToAdd = listenerSpec.getAlarmChangeListenerToAdd();
        AlarmChangeListener alarmChangeListenerToRemove = listenerSpec.getAlarmChangeListenerToRemove();
        assert (alarmChangeListenerToAdd == null || alarmChangeListenerToRemove == null) : "Not possible to both add and remove an AlarmChangeListener";
        if (alarmChangeListenerToRemove != null) {
            if (!alarmChangeListenerToRemove.equals(alarmChangeListener)) throw new IllegalArgumentException("Trying to remove an AlarmChangeListener which is not previously registered.");
            alarmChangeListener = null;
        } else if (alarmChangeListenerToAdd != null) {
            if (alarmChangeListener != null) {
                throw new IllegalArgumentException("Only one AlarmChangeListener allowed to be added.");
            }
            alarmChangeListener = alarmChangeListenerToAdd;
        }
        if (resourceChangeListener != null || alarmChangeListener != null) return new ChangeDemultiplexer(this._changeNotifier, resourceChangeListener, alarmChangeListener);
        throw new IllegalArgumentException("Should close the ChangeNotifier instead of removing all listeners.");
    }

    ChangeLogCollector.ChangeLog[] getSubscribedChangeLogs() {
        ArrayList<ChangeLogCollector.ChangeLog> subscribedChangeLogs = new ArrayList<ChangeLogCollector.ChangeLog>();
        if (this._resourceChangeListener != null) {
            subscribedChangeLogs.add(ChangeLogCollector.ChangeLog.RESOURCE);
        }
        if (this._alarmChangeListener != null) {
            subscribedChangeLogs.add(ChangeLogCollector.ChangeLog.ALARM_STATUS);
        }
        return subscribedChangeLogs.toArray(new ChangeLogCollector.ChangeLog[subscribedChangeLogs.size()]);
    }

    private void notifyForResourceChanges(Collection<ResourceChange> resourceChanges) {
        assert (resourceChanges != null);
        if (this._resourceChangeListener == null || resourceChanges.isEmpty()) {
            return;
        }
        try {
            _logger.trace("Notifying listener '{}' for resource changes: {}", (Object)this._resourceChangeListener, resourceChanges);
            this._resourceChangeListener.onChanges(this._changeNotifier, resourceChanges);
            _logger.trace("Notified listener '{}' for resource changes.", (Object)this._resourceChangeListener);
        }
        catch (RuntimeException e) {
            _logger.error("Error while notifying '{}' for resource changes: {}", (Object)this._resourceChangeListener, (Object)e);
        }
    }

    private void notifyForAlarmChanges(Collection<AlarmChange> alarmChanges) {
        assert (alarmChanges != null);
        if (this._alarmChangeListener == null || alarmChanges.isEmpty()) {
            return;
        }
        try {
            _logger.trace("Notifying listener '{}' for alarm state changes: {}", (Object)this._alarmChangeListener, alarmChanges);
            this._alarmChangeListener.onChanges(this._changeNotifier, alarmChanges);
            _logger.trace("Notified listener '{}' for alarm state changes.", (Object)this._alarmChangeListener);
        }
        catch (RuntimeException e) {
            _logger.error("Error while notifying '{}' for alarm state changes: {}", (Object)this._alarmChangeListener, (Object)e);
        }
    }
}

