/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.listener;

import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.listener.ChangeDemultiplexer;
import com.vmware.cdc.internal.vcenter.listener.ChangeLogCollectorPoller;
import com.vmware.cdc.internal.vcenter.listener.ListenerSpec;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ListenerSpecBuilder;
import java.util.concurrent.ExecutorService;

public final class ChangeNotifierImpl
implements ChangeNotifier {
    private final ChangeLogCollectorPollerFactory _changeLogCollectorPollerFactory;
    private ChangeDemultiplexer _changeDemultiplexer = null;
    private ChangeLogCollectorPoller _changePoller = null;

    public ChangeNotifierImpl(ChangeLogCollectorPollerFactory changeLogCollectorPollerFactory) {
        assert (changeLogCollectorPollerFactory != null);
        this._changeLogCollectorPollerFactory = changeLogCollectorPollerFactory;
    }

    @Override
    public ListenerSpecBuilder listeners() {
        return new ListenerSpecBuilder(this);
    }

    public synchronized void commit(ListenerSpec listenerSpec) {
        assert (listenerSpec != null);
        ChangeDemultiplexer changeDemultiplexer = null;
        ChangeLogCollectorPoller changePoller = null;
        if (this._changeDemultiplexer == null) {
            changeDemultiplexer = new ChangeDemultiplexer(this, listenerSpec);
            changePoller = this._changeLogCollectorPollerFactory.forChangeDemultiplexer(changeDemultiplexer);
        } else {
            changeDemultiplexer = this._changeDemultiplexer.exchangeDemultiplexer(listenerSpec);
            changePoller = this._changePoller.exchangeChangePoller(changeDemultiplexer, listenerSpec);
        }
        this._changeDemultiplexer = changeDemultiplexer;
        this._changePoller = changePoller;
        this._changePoller.start();
    }

    @Override
    public synchronized void close() {
        if (this._changePoller != null) {
            this._changePoller.stop();
            this._changeDemultiplexer = null;
        }
    }

    public static final class ChangeLogCollectorPollerFactory {
        private final String _serviceName;
        private final ExecutorService _pollingExecutor;
        private final long _pollingInterval;
        private final ChangeLogCollector _changeLogCollector;

        public ChangeLogCollectorPollerFactory(String serviceName, ExecutorService pollingExecutor, long pollingInterval, ChangeLogCollector changeLogCollector) {
            assert (serviceName != null);
            assert (pollingExecutor != null);
            assert (pollingInterval > 0L);
            assert (changeLogCollector != null);
            this._serviceName = serviceName;
            this._pollingExecutor = pollingExecutor;
            this._pollingInterval = pollingInterval;
            this._changeLogCollector = changeLogCollector;
        }

        ChangeLogCollectorPoller forChangeDemultiplexer(ChangeDemultiplexer changeDemultiplexer) {
            return new ChangeLogCollectorPoller(this._serviceName, this._pollingExecutor, this._pollingInterval, this._changeLogCollector, changeDemultiplexer);
        }
    }
}

