/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.provider;

import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.internal.provider.MultiWriterChangeLogRecorder;
import com.vmware.cdc.provider.ChangeRecorder;
import org.apache.commons.lang.Validate;

public final class ChangeLogRecorder {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final MultiWriterChangeLogRecorder _changeLogRecorder;

    private ChangeLogRecorder(MultiWriterChangeLogRecorder logRecorder) {
        assert (logRecorder != null);
        this._changeLogRecorder = logRecorder;
    }

    public static ChangeLogRecorder forCircularChangeLog() {
        return ChangeLogRecorder.forCircularChangeLog(1024);
    }

    public static ChangeLogRecorder forCircularChangeLog(int size) {
        Validate.isTrue((Integer.bitCount(size) == 1 ? 1 : 0) != 0, (String)"The size of the Change Log must be a power of 2");
        MultiWriterChangeLogRecorder changeLogRecorder = new MultiWriterChangeLogRecorder(size);
        return new ChangeLogRecorder(changeLogRecorder);
    }

    public ChangeRecorder getRecorder() {
        return this._changeLogRecorder;
    }

    public ChangeLog getLog() {
        return this._changeLogRecorder;
    }
}

