/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.provider.transport;

import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.internal.provider.transport.vapi.ChangeLogProviderImpl;
import com.vmware.cdc.provider.transport.ChangeLogResolver;
import com.vmware.cdc.transport.vapi.ChangeLogApiInterface;
import com.vmware.vapi.bindings.ApiError;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.provider.ApiInterface;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.Validate;

public final class RemoteApiProvider {
    private static final int DEFAULT_MAX_POLL_ITERATIONS = 600;
    private static final long DEFAULT_POLL_INTERVAL_MS = 500L;
    private static final int DEFAULT_MAX_CONCURRENT_CALLS = 2048;

    public static ApiInterface createVapiFor(final ChangeLog changeLog) {
        Validate.notNull((Object)changeLog);
        ChangeLogResolver fixedChangeLog = new ChangeLogResolver(){

            @Override
            public ChangeLog fromInvocationContext(InvocationContext executionContext) throws ApiError {
                return changeLog;
            }
        };
        return RemoteApiProvider.createVapiFor(fixedChangeLog);
    }

    public static ApiInterface createVapiFor(ChangeLogResolver changeLogResolver) {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ChangeLogThreadFactory());
        ChangeLogProviderImpl vapiProvider = new ChangeLogProviderImpl(changeLogResolver, executor, 2048, 500L, 600);
        ChangeLogApiInterface vapiInterface = new ChangeLogApiInterface(vapiProvider);
        return vapiInterface;
    }

    private static final class ChangeLogThreadFactory
    implements ThreadFactory {
        private ChangeLogThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "change-log-long-polling-daemon");
            t.setDaemon(true);
            return t;
        }
    }
}

